# Changelog

[npm history][1]

[1]: https://www.npmjs.com/package/gtoken?activeTab=versions

### [4.1.1](https://www.github.com/googleapis/node-gtoken/compare/v4.1.0...v4.1.1) (2019-10-31)


### Bug Fixes

* **deps:** update gaxios to 2.1.0 ([#238](https://www.github.com/googleapis/node-gtoken/issues/238)) ([bb12064](https://www.github.com/googleapis/node-gtoken/commit/bb1206420388399ef8992efe54c70bdb3fdcd965))

## [4.1.0](https://www.github.com/googleapis/node-gtoken/compare/v4.0.0...v4.1.0) (2019-09-24)


### Features

* allow upstream libraries to force token refresh ([#229](https://www.github.com/googleapis/node-gtoken/issues/229)) ([1fd4dd1](https://www.github.com/googleapis/node-gtoken/commit/1fd4dd1))

## [4.0.0](https://www.github.com/googleapis/node-gtoken/compare/v3.0.2...v4.0.0) (2019-07-09)


### ⚠ BREAKING CHANGES

* This commit creates multiple breaking changes. The `getToken()`
method previously returned `Promise<string>`, where the string was the
`access_token` returned from the response.  However, the `oauth2` endpoint could
return a variety of other fields, such as an `id_token` in special cases.

```js
const token = await getToken();
// old response: 'some.access.token'
// new response: { access_token: 'some.access.token'}
```

To further support this change, the `GoogleToken` class no longer exposes
a `token` variable.  It now exposes `rawToken`, `accessToken`, and `idToken`
fields which can be used to access the relevant values returned in the
response.

### Bug Fixes

* expose all fields from response ([#218](https://www.github.com/googleapis/node-gtoken/issues/218)) ([d463370](https://www.github.com/googleapis/node-gtoken/commit/d463370))

### [3.0.2](https://www.github.com/googleapis/node-gtoken/compare/v3.0.1...v3.0.2) (2019-06-26)


### Bug Fixes

* **docs:** make anchors work in jsdoc ([#215](https://www.github.com/googleapis/node-gtoken/issues/215)) ([c5f6c89](https://www.github.com/googleapis/node-gtoken/commit/c5f6c89))

### [3.0.1](https://www.github.com/googleapis/node-gtoken/compare/v3.0.0...v3.0.1) (2019-06-13)


### Bug Fixes

* **docs:** move to new client docs URL ([#212](https://www.github.com/googleapis/node-gtoken/issues/212)) ([b7a8c75](https://www.github.com/googleapis/node-gtoken/commit/b7a8c75))

## [3.0.0](https://www.github.com/googleapis/node-gtoken/compare/v2.3.3...v3.0.0) (2019-05-07)


### Bug Fixes

* **deps:** update dependency gaxios to v2 ([#191](https://www.github.com/googleapis/node-gtoken/issues/191)) ([da65ea7](https://www.github.com/googleapis/node-gtoken/commit/da65ea7))
* **deps:** update dependency google-p12-pem to v2 ([#196](https://www.github.com/googleapis/node-gtoken/issues/196)) ([b510f06](https://www.github.com/googleapis/node-gtoken/commit/b510f06))
* fs.readFile does not exist in browser ([#186](https://www.github.com/googleapis/node-gtoken/issues/186)) ([a16d8e7](https://www.github.com/googleapis/node-gtoken/commit/a16d8e7))


### Build System

* upgrade engines field to >=8.10.0 ([#194](https://www.github.com/googleapis/node-gtoken/issues/194)) ([ee4d6c8](https://www.github.com/googleapis/node-gtoken/commit/ee4d6c8))


### BREAKING CHANGES

* upgrade engines field to >=8.10.0 (#194)

## v2.3.3

03-13-2019 14:54 PDT

### Bug Fixes
- fix: propagate error message ([#173](https://github.com/google/node-gtoken/pull/173))

### Documentation
- docs: update links in contrib guide ([#171](https://github.com/google/node-gtoken/pull/171))
- docs: move CONTRIBUTING.md to root ([#166](https://github.com/google/node-gtoken/pull/166))
- docs: add lint/fix example to contributing guide ([#164](https://github.com/google/node-gtoken/pull/164))

### Internal / Testing Changes
- build: Add docuploader credentials to node publish jobs ([#176](https://github.com/google/node-gtoken/pull/176))
- build: use node10 to run samples-test, system-test etc ([#175](https://github.com/google/node-gtoken/pull/175))
- build: update release configuration
- chore(deps): update dependency mocha to v6
- build: use linkinator for docs test ([#170](https://github.com/google/node-gtoken/pull/170))
- build: create docs test npm scripts ([#169](https://github.com/google/node-gtoken/pull/169))
- build: test using @grpc/grpc-js in CI ([#168](https://github.com/google/node-gtoken/pull/168))
- build: ignore googleapis.com in doc link check ([#162](https://github.com/google/node-gtoken/pull/162))
- build: check for 404s on all docs

## v2.3.2

01-09-2019 13:40 PST

### Documentation
- docs: generate docs with compodoc ([#154](https://github.com/googleapis/node-gtoken/pull/154))
- docs: fix up the readme ([#153](https://github.com/googleapis/node-gtoken/pull/153))

### Internal / Testing Changes
- build: Re-generated  to pick up changes in the API or client library generator. ([#158](https://github.com/googleapis/node-gtoken/pull/158))
- build: check broken links in generated docs ([#152](https://github.com/googleapis/node-gtoken/pull/152))
- fix: add a system test and get it passing ([#150](https://github.com/googleapis/node-gtoken/pull/150))
- chore(build): inject yoshi automation key ([#149](https://github.com/googleapis/node-gtoken/pull/149))

## v2.3.1

12-10-2018 15:28 PST

### Dependencies
- fix(deps): update dependency pify to v4 ([#87](https://github.com/google/node-gtoken/pull/87))
- fix(deps): use gaxios for http requests ([#125](https://github.com/google/node-gtoken/pull/125))

### Internal / Testing Changes
- build: add Kokoro configs for autorelease ([#143](https://github.com/google/node-gtoken/pull/143))
- chore: always nyc report before calling codecov ([#141](https://github.com/google/node-gtoken/pull/141))
- chore: nyc ignore build/test by default ([#140](https://github.com/google/node-gtoken/pull/140))
- chore: update synth metadata and templates ([#138](https://github.com/google/node-gtoken/pull/138))
- fix(build): fix system key decryption ([#133](https://github.com/google/node-gtoken/pull/133))
- chore(deps): update dependency typescript to ~3.2.0 ([#132](https://github.com/google/node-gtoken/pull/132))
- chore: add a synth.metadata
- chore(deps): update dependency gts to ^0.9.0 ([#127](https://github.com/google/node-gtoken/pull/127))
- chore: update eslintignore config ([#126](https://github.com/google/node-gtoken/pull/126))
- chore: use latest npm on Windows ([#124](https://github.com/google/node-gtoken/pull/124))
- chore: update CircleCI config ([#123](https://github.com/google/node-gtoken/pull/123))
- chore: include build in eslintignore ([#120](https://github.com/google/node-gtoken/pull/120))
- chore: update issue templates ([#116](https://github.com/google/node-gtoken/pull/116))
- chore: remove old issue template ([#114](https://github.com/google/node-gtoken/pull/114))
- build: run tests on node11 ([#113](https://github.com/google/node-gtoken/pull/113))
- chore(deps): update dependency nock to v10 ([#111](https://github.com/google/node-gtoken/pull/111))
- chores(build): do not collect sponge.xml from windows builds ([#112](https://github.com/google/node-gtoken/pull/112))
- chore(deps): update dependency typescript to ~3.1.0 ([#110](https://github.com/google/node-gtoken/pull/110))
- chores(build): run codecov on continuous builds ([#109](https://github.com/google/node-gtoken/pull/109))
- chore: update new issue template ([#108](https://github.com/google/node-gtoken/pull/108))
- chore: update CI config ([#105](https://github.com/google/node-gtoken/pull/105))
- Update kokoro config ([#103](https://github.com/google/node-gtoken/pull/103))
- Update CI config ([#101](https://github.com/google/node-gtoken/pull/101))
- Don't publish sourcemaps ([#99](https://github.com/google/node-gtoken/pull/99))
- Update kokoro config ([#97](https://github.com/google/node-gtoken/pull/97))
- test: remove appveyor config ([#96](https://github.com/google/node-gtoken/pull/96))
- Update CI config ([#95](https://github.com/google/node-gtoken/pull/95))
- Enable prefer-const in the eslint config ([#94](https://github.com/google/node-gtoken/pull/94))
- Enable no-var in eslint ([#93](https://github.com/google/node-gtoken/pull/93))
- Update CI config ([#92](https://github.com/google/node-gtoken/pull/92))
- Add synth and update CI config ([#91](https://github.com/google/node-gtoken/pull/91))
- Retry npm install in CI ([#90](https://github.com/google/node-gtoken/pull/90))
- chore(deps): update dependency nyc to v13 ([#88](https://github.com/google/node-gtoken/pull/88))
- chore: ignore package-log.json ([#86](https://github.com/google/node-gtoken/pull/86))
- chore: update renovate config ([#83](https://github.com/google/node-gtoken/pull/83))
- chore(deps): lock file maintenance ([#85](https://github.com/google/node-gtoken/pull/85))
- chore: remove greenkeeper badge ([#82](https://github.com/google/node-gtoken/pull/82))
- test: throw on deprecation ([#81](https://github.com/google/node-gtoken/pull/81))
- chore(deps): update dependency typescript to v3 ([#80](https://github.com/google/node-gtoken/pull/80))
- chore: move mocha options to mocha.opts ([#78](https://github.com/google/node-gtoken/pull/78))
- chore(deps): lock file maintenance ([#79](https://github.com/google/node-gtoken/pull/79))
- test: use strictEqual in tests ([#76](https://github.com/google/node-gtoken/pull/76))
- chore(deps): lock file maintenance ([#77](https://github.com/google/node-gtoken/pull/77))
- chore(deps): update dependency typescript to ~2.9.0 ([#75](https://github.com/google/node-gtoken/pull/75))
- chore: Configure Renovate ([#74](https://github.com/google/node-gtoken/pull/74))
- Update gts to the latest version 🚀 ([#73](https://github.com/google/node-gtoken/pull/73))
- Add Code of Conduct
- build: start testing against Node 10 ([#69](https://github.com/google/node-gtoken/pull/69))
- chore(package): update nyc to version 12.0.2 ([#67](https://github.com/google/node-gtoken/pull/67))
- chore(package): update @types/node to version 10.0.3 ([#65](https://github.com/google/node-gtoken/pull/65))

### 2.0.0
New features:
- API now supports callback and promise based workflows

Breaking changes:
- `GoogleToken` is now a class type, and must be instantiated.
- `GoogleToken.expires_at` renamed to `GoogleToken.expiresAt`
- `GoogleToken.raw_token` renamed to `GoogleToken.rawToken`
- `GoogleToken.token_expires` renamed to `GoogleToken.tokenExpires`
