import * as protobuf from 'protobufjs';
import { Descriptor } from '../descriptor';
import { CallSettings } from '../gax';
import { OperationsClient } from '../operationsClient';
import { LongrunningApiCaller } from './longRunningApiCaller';
/**
 * A callback to upack a google.protobuf.Any message.
 */
export interface AnyDecoder {
    (reader: protobuf.Reader | Uint8Array, length?: number): protobuf.Message<{}>;
}
/**
 * A descriptor for long-running operations.
 */
export declare class LongRunningDescriptor implements Descriptor {
    operationsClient: OperationsClient;
    responseDecoder: AnyDecoder;
    metadataDecoder: AnyDecoder;
    constructor(operationsClient: OperationsClient, responseDecoder: AnyDecoder, metadataDecoder: AnyDecoder);
    getApiCaller(settings: CallSettings): LongrunningApiCaller;
}
