"use strict";
/**
 * Copyright 2019 Google LLC
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following disclaimer
 * in the documentation and/or other materials provided with the
 * distribution.
 *     * Neither the name of Google Inc. nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const grpc_1 = require("./grpc");
const operationsClient = require("./operationsClient");
const routingHeader = require("./routingHeader");
exports.routingHeader = routingHeader;
var google_auth_library_1 = require("google-auth-library");
exports.GoogleAuth = google_auth_library_1.GoogleAuth;
var call_1 = require("./call");
exports.OngoingCall = call_1.OngoingCall;
var createApiCall_1 = require("./createApiCall");
exports.createApiCall = createApiCall_1.createApiCall;
var descriptor_1 = require("./descriptor");
exports.BundleDescriptor = descriptor_1.BundleDescriptor;
exports.LongrunningDescriptor = descriptor_1.LongrunningDescriptor;
exports.PageDescriptor = descriptor_1.PageDescriptor;
exports.StreamDescriptor = descriptor_1.StreamDescriptor;
var gax_1 = require("./gax");
exports.CallSettings = gax_1.CallSettings;
exports.constructSettings = gax_1.constructSettings;
exports.RetryOptions = gax_1.RetryOptions;
var googleError_1 = require("./googleError");
exports.GoogleError = googleError_1.GoogleError;
var grpc_2 = require("./grpc");
exports.ClientStub = grpc_2.ClientStub;
exports.GoogleProtoFilesRoot = grpc_2.GoogleProtoFilesRoot;
exports.GrpcClient = grpc_2.GrpcClient;
var longrunning_1 = require("./longRunningCalls/longrunning");
exports.Operation = longrunning_1.Operation;
exports.operation = longrunning_1.operation;
var pathTemplate_1 = require("./pathTemplate");
exports.PathTemplate = pathTemplate_1.PathTemplate;
var streaming_1 = require("./streamingCalls/streaming");
exports.StreamType = streaming_1.StreamType;
function lro(options) {
    options = Object.assign({ scopes: lro.ALL_SCOPES }, options);
    const gaxGrpc = new grpc_1.GrpcClient(options);
    return new operationsClient.OperationsClientBuilder(gaxGrpc);
}
exports.lro = lro;
lro.SERVICE_ADDRESS = operationsClient.SERVICE_ADDRESS;
lro.ALL_SCOPES = operationsClient.ALL_SCOPES;
exports.createByteLengthFunction = grpc_1.GrpcClient.createByteLengthFunction;
exports.version = require('../../package.json').version;
const protobuf = require("protobufjs");
exports.protobuf = protobuf;
const fallback = require("./fallback");
exports.fallback = fallback;
//# sourceMappingURL=index.js.map