import { CloudFunction, EventContext } from '../cloud-functions';
import { DeploymentOptions, ScheduleRetryConfig } from '../function-configuration';
/** @hidden */
export declare const provider = "google.pubsub";
/** @hidden */
export declare const service = "pubsub.googleapis.com";
/**
 * Registers a Cloud Function triggered when a Google Cloud Pub/Sub message
 * is sent to a specified topic.
 *
 * @param topic The Pub/Sub topic to watch for message events.
 * @return Pub/Sub topic builder interface.
 */
export declare function topic(topic: string): TopicBuilder;
/** @hidden */
export declare function _topicWithOptions(topic: string, options: DeploymentOptions): TopicBuilder;
export declare function schedule(schedule: string): ScheduleBuilder;
export declare class ScheduleBuilder {
    private options;
    /** @hidden */
    constructor(options: DeploymentOptions);
    retryConfig(config: ScheduleRetryConfig): ScheduleBuilder;
    timeZone(timeZone: string): ScheduleBuilder;
    onRun(handler: (context: EventContext) => PromiseLike<any> | any): CloudFunction<unknown>;
}
/** @hidden */
export declare function _scheduleWithOptions(schedule: string, options: DeploymentOptions): ScheduleBuilder;
/**
 * The Google Cloud Pub/Sub topic builder.
 *
 * Access via [`functions.pubsub.topic()`](functions.pubsub#.topic).
 */
export declare class TopicBuilder {
    private triggerResource;
    private options;
    /** @hidden */
    constructor(triggerResource: () => string, options: DeploymentOptions);
    /**
     * Event handler that fires every time a Cloud Pub/Sub message is
     * published.
     *
     * @param handler Event handler that runs every time a Cloud Pub/Sub message
     *   is published.
     * @return A Cloud Function that you can export and deploy.
     */
    onPublish(handler: (message: Message, context: EventContext) => PromiseLike<any> | any): CloudFunction<Message>;
}
/**
 * Interface representing a Google Cloud Pub/Sub message.
 *
 * @param data Payload of a Pub/Sub message.
 */
export declare class Message {
    /**
     * The data payload of this message object as a base64-encoded string.
     */
    readonly data: string;
    /**
     * User-defined attributes published with the message, if any.
     */
    readonly attributes: {
        [key: string]: string;
    };
    /** @hidden */
    private _json;
    constructor(data: any);
    /**
     * The JSON data payload of this message object, if any.
     */
    readonly json: any;
    /**
     * Returns a JSON-serializable representation of this object.
     *
     * @return A JSON-serializable representation of this object.
     */
    toJSON(): any;
}
