"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * List of all regions supported by Cloud Functions.
 */
exports.SUPPORTED_REGIONS = [
    'us-central1',
    'us-east1',
    'us-east4',
    'europe-west1',
    'europe-west2',
    'asia-east2',
    'asia-northeast1',
];
/**
 * Cloud Functions min timeout value.
 */
exports.MIN_TIMEOUT_SECONDS = 0;
/**
 * Cloud Functions max timeout value.
 */
exports.MAX_TIMEOUT_SECONDS = 540;
/**
 * List of available memory options supported by Cloud Functions.
 */
exports.VALID_MEMORY_OPTIONS = [
    '128MB',
    '256MB',
    '512MB',
    '1GB',
    '2GB',
];
