import 'package:flutter/material.dart';
import 'package:flux_localization/flux_localization.dart';
import 'package:provider/provider.dart';

import '../../../models/index.dart';
import '../../../modules/dynamic_layout/config/index.dart';
import '../../../modules/dynamic_layout/product/product_list_default.dart';
import '../../../modules/dynamic_layout/product/product_recent_placeholder.dart';
import '../../../services/index.dart';

class RecentProducts extends StatelessWidget {
  final Product? excludeProduct;
  final Color? background;

  const RecentProducts({
    super.key,
    this.excludeProduct,
    this.background,
  });

  @override
  Widget build(BuildContext context) {
    final products = List.from(
        context.select((RecentModel recentModel) => recentModel.products));
    if (excludeProduct != null) {
      products.removeWhere((item) => item.id == excludeProduct?.id);
    }
    if (products.length < 3) {
      return const SizedBox();
    }

    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Container(
          margin: const EdgeInsets.symmetric(
            vertical: 18.0,
          ),
          padding: const EdgeInsets.symmetric(
            horizontal: 16.0,
          ),
          child: Text(
            S.of(context).recentlyViewed,
            style: const TextStyle(
              fontSize: 20,
              fontWeight: FontWeight.w600,
            ),
          ),
        ),
        ServerConfig().isBuilder
            ? ProductRecentPlaceholder()
            : ProductListDefault(
                products: products,
                config: ProductConfig.empty(),
                maxWidth: MediaQuery.of(context).size.width,
                background: background,
              ),
      ],
    );
  }
}
