//
//  STDSWarning.h
//  Stripe3DS2
//
//  Created by Cameron Sabol on 2/12/19.
//  Copyright © 2019 Stripe. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

/**
 The `STDSWarningSeverity` enum defines the severity levels of warnings generated
 during SDK initialization. @see STDSThreeDS2Service
 */
typedef NS_ENUM(NSInteger, STDSWarningSeverity) {
    /**
     Low severity
     */
    STDSWarningSeverityLow = 0,

    /**
     Medium severity
     */
    STDSWarningSeverityMedium,

    /**
     High severity
     */
    STDSWarningSeverityHigh,
};

/**
 The `STDSWarning` class represents warnings generated by `STDSThreeDS2Service` during
 security checks run during initialization. @see STDSThreeDS2Service
 */
@interface STDSWarning : NSObject

/**
 Designated initializer for `STDSWarning`.
 */
- (instancetype)initWithIdentifier:(NSString *)identifier
                           message:(NSString *)message
                          severity:(STDSWarningSeverity)severity NS_DESIGNATED_INITIALIZER;

/**
 `STDSWarning` should not be directly initialized.
 */
- (instancetype)init NS_UNAVAILABLE;

/**
 The identifier for this warning instance.
 */
@property (nonatomic, readonly) NSString *identifier;

/**
 The descriptive message for this warning.
 */
@property (nonatomic, readonly) NSString *message;

/**
 The severity of this warning.
 */
@property (nonatomic, readonly) STDSWarningSeverity severity;

@end

NS_ASSUME_NONNULL_END
