//
//  SetupIntentParams.swift
//  StripeApplePay
//
//  Created by David Estes on 6/29/21.
//  Copyright © 2021 Stripe, Inc. All rights reserved.
//

import Foundation
@_spi(STP) import StripeCore

extension StripeAPI {
    @_spi(STP) public struct SetupIntentConfirmParams: UnknownFieldsEncodable {
        /// Generated by by Editor -> Refactor -> Generate Memberwise Initializer
        @_spi(STP) public init(
            clientSecret: String,
            paymentMethodData: StripeAPI.PaymentMethodParams? = nil,
            paymentMethod: String? = nil,
            returnUrl: String? = nil,
            useStripeSdk: Bool? = nil,
            _additionalParametersStorage: NonEncodableParameters? = nil
        ) {
            self.clientSecret = clientSecret
            self.paymentMethodData = paymentMethodData
            self.paymentMethod = paymentMethod
            self.returnUrl = returnUrl
            self.useStripeSdk = useStripeSdk
            self._additionalParametersStorage = _additionalParametersStorage
        }

        /// The client secret of the SetupIntent. Required.
        @_spi(STP) public let clientSecret: String
        /// Provide a supported `PaymentMethodParams` object, and Stripe will create a
        /// PaymentMethod during PaymentIntent confirmation.
        /// @note alternative to `paymentMethodId`
        @_spi(STP) public var paymentMethodData: PaymentMethodParams?
        /// Provide an already created PaymentMethod's id, and it will be used to confirm the SetupIntent.
        /// @note alternative to `paymentMethodParams`
        @_spi(STP) public var paymentMethod: String?
        /// The URL to redirect your customer back to after they authenticate or cancel
        /// their payment on the payment method’s app or site.
        /// This should probably be a URL that opens your iOS app.
        @_spi(STP) public var returnUrl: String?
        /// A boolean number to indicate whether you intend to use the Stripe SDK's functionality to handle any SetupIntent next actions.
        /// If set to false, SetupIntent.nextAction will only ever contain a redirect url that can be opened in a webview or mobile browser.
        /// When set to true, the nextAction may contain information that the Stripe SDK can use to perform native authentication within your
        /// app.
        @_spi(STP) public var useStripeSdk: Bool?

        @_spi(STP) public var _additionalParametersStorage: NonEncodableParameters?

        // MARK: - Utilities
        static private let regex = try! NSRegularExpression(
            pattern: "^seti_[^_]+_secret_[^_]+$",
            options: []
        )
        @_spi(STP) public static func isClientSecretValid(_ clientSecret: String) -> Bool {
            return
                (regex.numberOfMatches(
                    in: clientSecret,
                    options: .anchored,
                    range: NSRange(location: 0, length: clientSecret.count)
                )) == 1
        }
    }
}
