#if 0
#elif defined(__arm64__) && __arm64__
// Generated by Apple Swift version 5.7.1 (swiftlang-5.7.1.135.3 clang-1400.0.29.51)
#ifndef PAYPALCHECKOUT_SWIFT_H
#define PAYPALCHECKOUT_SWIFT_H
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wgcc-compat"

#if !defined(__has_include)
# define __has_include(x) 0
#endif
#if !defined(__has_attribute)
# define __has_attribute(x) 0
#endif
#if !defined(__has_feature)
# define __has_feature(x) 0
#endif
#if !defined(__has_warning)
# define __has_warning(x) 0
#endif

#if __has_include(<swift/objc-prologue.h>)
# include <swift/objc-prologue.h>
#endif

#pragma clang diagnostic ignored "-Wduplicate-method-match"
#pragma clang diagnostic ignored "-Wauto-import"
#if defined(__OBJC__)
#include <Foundation/Foundation.h>
#endif
#if defined(__cplusplus)
#include <cstdint>
#include <cstddef>
#include <cstdbool>
#else
#include <stdint.h>
#include <stddef.h>
#include <stdbool.h>
#endif

#if !defined(SWIFT_TYPEDEFS)
# define SWIFT_TYPEDEFS 1
# if __has_include(<uchar.h>)
#  include <uchar.h>
# elif !defined(__cplusplus)
typedef uint_least16_t char16_t;
typedef uint_least32_t char32_t;
# endif
typedef float swift_float2  __attribute__((__ext_vector_type__(2)));
typedef float swift_float3  __attribute__((__ext_vector_type__(3)));
typedef float swift_float4  __attribute__((__ext_vector_type__(4)));
typedef double swift_double2  __attribute__((__ext_vector_type__(2)));
typedef double swift_double3  __attribute__((__ext_vector_type__(3)));
typedef double swift_double4  __attribute__((__ext_vector_type__(4)));
typedef int swift_int2  __attribute__((__ext_vector_type__(2)));
typedef int swift_int3  __attribute__((__ext_vector_type__(3)));
typedef int swift_int4  __attribute__((__ext_vector_type__(4)));
typedef unsigned int swift_uint2  __attribute__((__ext_vector_type__(2)));
typedef unsigned int swift_uint3  __attribute__((__ext_vector_type__(3)));
typedef unsigned int swift_uint4  __attribute__((__ext_vector_type__(4)));
#endif

#if !defined(SWIFT_PASTE)
# define SWIFT_PASTE_HELPER(x, y) x##y
# define SWIFT_PASTE(x, y) SWIFT_PASTE_HELPER(x, y)
#endif
#if !defined(SWIFT_METATYPE)
# define SWIFT_METATYPE(X) Class
#endif
#if !defined(SWIFT_CLASS_PROPERTY)
# if __has_feature(objc_class_property)
#  define SWIFT_CLASS_PROPERTY(...) __VA_ARGS__
# else
#  define SWIFT_CLASS_PROPERTY(...)
# endif
#endif

#if __has_attribute(objc_runtime_name)
# define SWIFT_RUNTIME_NAME(X) __attribute__((objc_runtime_name(X)))
#else
# define SWIFT_RUNTIME_NAME(X)
#endif
#if __has_attribute(swift_name)
# define SWIFT_COMPILE_NAME(X) __attribute__((swift_name(X)))
#else
# define SWIFT_COMPILE_NAME(X)
#endif
#if __has_attribute(objc_method_family)
# define SWIFT_METHOD_FAMILY(X) __attribute__((objc_method_family(X)))
#else
# define SWIFT_METHOD_FAMILY(X)
#endif
#if __has_attribute(noescape)
# define SWIFT_NOESCAPE __attribute__((noescape))
#else
# define SWIFT_NOESCAPE
#endif
#if __has_attribute(ns_consumed)
# define SWIFT_RELEASES_ARGUMENT __attribute__((ns_consumed))
#else
# define SWIFT_RELEASES_ARGUMENT
#endif
#if __has_attribute(warn_unused_result)
# define SWIFT_WARN_UNUSED_RESULT __attribute__((warn_unused_result))
#else
# define SWIFT_WARN_UNUSED_RESULT
#endif
#if __has_attribute(noreturn)
# define SWIFT_NORETURN __attribute__((noreturn))
#else
# define SWIFT_NORETURN
#endif
#if !defined(SWIFT_CLASS_EXTRA)
# define SWIFT_CLASS_EXTRA
#endif
#if !defined(SWIFT_PROTOCOL_EXTRA)
# define SWIFT_PROTOCOL_EXTRA
#endif
#if !defined(SWIFT_ENUM_EXTRA)
# define SWIFT_ENUM_EXTRA
#endif
#if !defined(SWIFT_CLASS)
# if __has_attribute(objc_subclassing_restricted)
#  define SWIFT_CLASS(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) __attribute__((objc_subclassing_restricted)) SWIFT_CLASS_EXTRA
#  define SWIFT_CLASS_NAMED(SWIFT_NAME) __attribute__((objc_subclassing_restricted)) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
# else
#  define SWIFT_CLASS(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
#  define SWIFT_CLASS_NAMED(SWIFT_NAME) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
# endif
#endif
#if !defined(SWIFT_RESILIENT_CLASS)
# if __has_attribute(objc_class_stub)
#  define SWIFT_RESILIENT_CLASS(SWIFT_NAME) SWIFT_CLASS(SWIFT_NAME) __attribute__((objc_class_stub))
#  define SWIFT_RESILIENT_CLASS_NAMED(SWIFT_NAME) __attribute__((objc_class_stub)) SWIFT_CLASS_NAMED(SWIFT_NAME)
# else
#  define SWIFT_RESILIENT_CLASS(SWIFT_NAME) SWIFT_CLASS(SWIFT_NAME)
#  define SWIFT_RESILIENT_CLASS_NAMED(SWIFT_NAME) SWIFT_CLASS_NAMED(SWIFT_NAME)
# endif
#endif

#if !defined(SWIFT_PROTOCOL)
# define SWIFT_PROTOCOL(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) SWIFT_PROTOCOL_EXTRA
# define SWIFT_PROTOCOL_NAMED(SWIFT_NAME) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_PROTOCOL_EXTRA
#endif

#if !defined(SWIFT_EXTENSION)
# define SWIFT_EXTENSION(M) SWIFT_PASTE(M##_Swift_, __LINE__)
#endif

#if !defined(OBJC_DESIGNATED_INITIALIZER)
# if __has_attribute(objc_designated_initializer)
#  define OBJC_DESIGNATED_INITIALIZER __attribute__((objc_designated_initializer))
# else
#  define OBJC_DESIGNATED_INITIALIZER
# endif
#endif
#if !defined(SWIFT_ENUM_ATTR)
# if defined(__has_attribute) && __has_attribute(enum_extensibility)
#  define SWIFT_ENUM_ATTR(_extensibility) __attribute__((enum_extensibility(_extensibility)))
# else
#  define SWIFT_ENUM_ATTR(_extensibility)
# endif
#endif
#if !defined(SWIFT_ENUM)
# define SWIFT_ENUM(_type, _name, _extensibility) enum _name : _type _name; enum SWIFT_ENUM_ATTR(_extensibility) SWIFT_ENUM_EXTRA _name : _type
# if __has_feature(generalized_swift_name)
#  define SWIFT_ENUM_NAMED(_type, _name, SWIFT_NAME, _extensibility) enum _name : _type _name SWIFT_COMPILE_NAME(SWIFT_NAME); enum SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_ENUM_ATTR(_extensibility) SWIFT_ENUM_EXTRA _name : _type
# else
#  define SWIFT_ENUM_NAMED(_type, _name, SWIFT_NAME, _extensibility) SWIFT_ENUM(_type, _name, _extensibility)
# endif
#endif
#if !defined(SWIFT_UNAVAILABLE)
# define SWIFT_UNAVAILABLE __attribute__((unavailable))
#endif
#if !defined(SWIFT_UNAVAILABLE_MSG)
# define SWIFT_UNAVAILABLE_MSG(msg) __attribute__((unavailable(msg)))
#endif
#if !defined(SWIFT_AVAILABILITY)
# define SWIFT_AVAILABILITY(plat, ...) __attribute__((availability(plat, __VA_ARGS__)))
#endif
#if !defined(SWIFT_WEAK_IMPORT)
# define SWIFT_WEAK_IMPORT __attribute__((weak_import))
#endif
#if !defined(SWIFT_DEPRECATED)
# define SWIFT_DEPRECATED __attribute__((deprecated))
#endif
#if !defined(SWIFT_DEPRECATED_MSG)
# define SWIFT_DEPRECATED_MSG(...) __attribute__((deprecated(__VA_ARGS__)))
#endif
#if __has_feature(attribute_diagnose_if_objc)
# define SWIFT_DEPRECATED_OBJC(Msg) __attribute__((diagnose_if(1, Msg, "warning")))
#else
# define SWIFT_DEPRECATED_OBJC(Msg) SWIFT_DEPRECATED_MSG(Msg)
#endif
#if defined(__OBJC__)
#if !defined(IBSegueAction)
# define IBSegueAction
#endif
#endif
#if !defined(SWIFT_EXTERN)
# if defined(__cplusplus)
#  define SWIFT_EXTERN extern "C"
# else
#  define SWIFT_EXTERN extern
# endif
#endif
#if !defined(SWIFT_CALL)
# define SWIFT_CALL __attribute__((swiftcall))
#endif
#if defined(__cplusplus)
#if !defined(SWIFT_NOEXCEPT)
# define SWIFT_NOEXCEPT noexcept
#endif
#else
#if !defined(SWIFT_NOEXCEPT)
# define SWIFT_NOEXCEPT 
#endif
#endif
#if defined(__cplusplus)
#if !defined(SWIFT_CXX_INT_DEFINED)
#define SWIFT_CXX_INT_DEFINED
namespace swift {
using Int = ptrdiff_t;
using UInt = size_t;
}
#endif
#endif
#if defined(__OBJC__)
#if __has_feature(modules)
#if __has_warning("-Watimport-in-framework-header")
#pragma clang diagnostic ignored "-Watimport-in-framework-header"
#endif
@import CoreFoundation;
@import Foundation;
@import ObjectiveC;
@import UIKit;
#endif

#endif
#pragma clang diagnostic ignored "-Wproperty-attribute-mismatch"
#pragma clang diagnostic ignored "-Wduplicate-method-arg"
#if __has_warning("-Wpragma-clang-attribute")
# pragma clang diagnostic ignored "-Wpragma-clang-attribute"
#endif
#pragma clang diagnostic ignored "-Wunknown-pragmas"
#pragma clang diagnostic ignored "-Wnullability"
#pragma clang diagnostic ignored "-Wdollar-in-identifier-extension"

#if __has_attribute(external_source_symbol)
# pragma push_macro("any")
# undef any
# pragma clang attribute push(__attribute__((external_source_symbol(language="Swift", defined_in="PayPalCheckout",generated_declaration))), apply_to=any(function,enum,objc_interface,objc_category,objc_protocol))
# pragma pop_macro("any")
#endif

#if defined(__OBJC__)
@class NSCoder;

SWIFT_CLASS("_TtC14PayPalCheckout24AccessibilityCloseButton")
@interface AccessibilityCloseButton : UIView
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)coder SWIFT_UNAVAILABLE;
- (nonnull instancetype)initWithFrame:(CGRect)frame SWIFT_UNAVAILABLE;
@end


SWIFT_CLASS("_TtC14PayPalCheckout10AmountView")
@interface AmountView : UIView
- (nonnull instancetype)initWithFrame:(CGRect)frame SWIFT_UNAVAILABLE;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)aDecoder SWIFT_UNAVAILABLE;
@end

@class PPCApprovalData;
@class PPCApprovalActions;

/// Encapsulates metadata after <code>CheckoutConfig.onApprove</code> is called.
/// This meta information can be utilized to properly capture an order.
SWIFT_CLASS_NAMED("Approval")
@interface PPCApproval : NSObject
/// Data associated with the approved payment
@property (nonatomic, readonly, strong) PPCApprovalData * _Nonnull data;
/// Actions to handle capturing or authorizing an approved payment.
/// These could be used in place of server side functions to do the same.
@property (nonatomic, readonly, strong) PPCApprovalActions * _Nonnull actions;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@class PPCCaptureActionSuccess;
@class PPCAuthorizeActionSuccess;
@class PPCPatchRequest;
@class PPCPatchActionSuccess;
@class PPCBillingActionData;
@class PPCOrderDetails;

/// Provides an interface to make common order requests from within the PayPal Checkout SDK.
SWIFT_CLASS_NAMED("ApprovalActions")
@interface PPCApprovalActions : NSObject
/// Makes a request to the PayPal API to capture the approved payment.
/// Uses the approval data to
/// <ul>
///   <li>
///     Generate a low scoped access token
///   </li>
///   <li>
///     Upgrade the access token in order to capture the payment
///   </li>
///   <li>
///     Make a request to capture the approved payment
///   </li>
/// </ul>
/// More information can be found in the API documentation:
/// <a href="https://developer.paypal.com/docs/api/orders/v2/#orders_capture">Capture Documentation</a>
/// note:
///
/// <ul>
///   <li>
///     Should only be invoked on transactions with an <code>intent</code> value of <code>CAPTURE</code>.
///   </li>
///   <li>
///     Only compatible with pay tokens generated by the PayPal <code>v2</code> API
///   </li>
/// </ul>
/// \param onComplete Asynchronously vends either a <code>CaptureActionSuccess</code> or an <code>Error</code> object.
///
- (void)captureOnComplete:(void (^ _Nonnull)(PPCCaptureActionSuccess * _Nullable, NSError * _Nullable))onComplete;
/// Makes a request to the PayPal API to authorize the approved payment.
/// Uses the approval data to
/// <ul>
///   <li>
///     Generate a low scoped access token
///   </li>
///   <li>
///     Upgrade the access token in order to authorize the payment
///   </li>
///   <li>
///     Make a request to authorize the payment
///   </li>
/// </ul>
/// More information can be found in the API documentation:
/// <a href="https://developer.paypal.com/docs/api/orders/v2/#orders_authorize">Authorization Documentation</a>
/// note:
///
/// <ul>
///   <li>
///     Should only be invoked on transactions with an <code>intent</code> value of <code>AUTHORIZE</code>.
///   </li>
///   <li>
///     Only compatible with pay tokens generated by the PayPal <code>v2</code> API
///   </li>
/// </ul>
/// \param onComplete Asynchronously vends either an <code>AuthorizationActionSuccess</code> or an <code>Error</code> object.
///
- (void)authorizeOnComplete:(void (^ _Nonnull)(PPCAuthorizeActionSuccess * _Nullable, NSError * _Nullable))onComplete;
/// Makes a request to the PayPal API to update an order.
/// note:
///
/// <ul>
///   <li>
///     Only compatible with pay tokens generated by the PayPal <code>v2</code> API.
///   </li>
///   <li>
///     Can only be applied to orders with the <code>CREATED</code> or <code>APPROVED</code> status.
///     You cannot update an order with the <code>COMPLETED</code> status.
///   </li>
///   <li>
///     You will need to handle any errors vended on the order request as part of the patch function.
///   </li>
/// </ul>
/// \param request The request(s) to update the order with.
/// <ul>
///   <li>
///     Currently only supports the following:
///     <ul>
///       <li>
///         <code>shippingName</code> - add, replace
///       </li>
///       <li>
///         <code>shippingAddress</code> - add, replace
///       </li>
///       <li>
///         <code>shippingOptions</code> - add, replace
///       </li>
///       <li>
///         <code>amount</code> - replace
///       </li>
///     </ul>
///   </li>
/// </ul>
///
/// \param onComplete Closure invoked when the patch request has resolved.
/// Asynchronously vends either a <code>PatchActionSuccess</code> or an <code>Error</code> object.
///
- (void)patchWithRequest:(PPCPatchRequest * _Nonnull)request onComplete:(void (^ _Nonnull)(PPCPatchActionSuccess * _Nullable, NSError * _Nullable))onComplete;
/// Execute the <code>billingToken</code> to create a billing agreement and get a Billing-ID to be used for subsequent transactions.
/// Uses the approval data to
/// note:
///
/// <ul>
///   <li>
///     Should only be invoked on billing agreement transactions with a <code>billingToken</code> in the <code>ApprovalData</code>.
///   </li>
///   <li>
///     Only compatible with billing token generated by the PayPal Billing Agreements <code>v1</code> API
///   </li>
/// </ul>
/// <ul>
///   <li>
///     Generate a low scoped access token
///   </li>
///   <li>
///     Make a request to execute the billing agreement to obtain a Billing-ID
///   </li>
/// </ul>
/// \param onComplete Asynchronously vends either a <code>BillingActionData</code> or an <code>Error</code> object.
///
- (void)executeBillingAgreementOnComplete:(void (^ _Nonnull)(PPCBillingActionData * _Nullable, NSError * _Nullable))onComplete;
/// Get the details for an Order previously approved by the buyer. This function makes REST request to the <code>orders/v2</code> API to
/// retrieve the order details.
/// For more information on the data returned from the Orders API, see https://developer.paypal.com/docs/api/orders/v2/#orders_get
/// note:
/// <em>Getting order details is only supported for tokens generated using the <code>orders/v2/</code> API</em>.
/// Tokens generated using other endpoints (for example, billing agreements, or the <code>payments/v1/</code>, will not be compatible with
/// this function.
/// \param onComplete Callback for when the order details have been fetched or an error is encountered.
///
- (void)getOrderDetailsOnComplete:(void (^ _Nonnull)(PPCOrderDetails * _Nullable, NSError * _Nullable))onComplete;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@class NSString;
enum PPCApprovalOrderIntent : NSInteger;
@class NSURL;
@class PPCVaultData;
@class PPCCorrelationIDs;

/// Data describing an approved order
SWIFT_CLASS_NAMED("ApprovalData")
@interface PPCApprovalData : NSObject
/// Payer ID is also the user id associated with the transaction.
@property (nonatomic, readonly, copy) NSString * _Nonnull payerID;
/// The payment token associated with the order, also known as the order id.
@property (nonatomic, readonly, copy) NSString * _Nonnull ecToken;
/// The billing agreement token
@property (nonatomic, readonly, copy) NSString * _Nullable billingToken;
/// Intent, this will be <code>CAPTURE</code> or <code>AUTHORIZE</code> if the order token was generated using the <code>v2/</code> API
/// and can be <code>CAPTURE</code>, <code>AUTHORIZE</code> or <code>ORDER</code> if order token was generated using the <code>v1/</code> API
/// <code>SALE</code> intent on <code>v1/</code> will be considered as a <code>CAPTURE</code>
@property (nonatomic, readonly) enum PPCApprovalOrderIntent intent;
/// Return URL can be used to redirect control back to the merchant
@property (nonatomic, readonly, copy) NSURL * _Nullable returnURL;
/// Unique identifier for a payment. Associated with tokens generated with the <code>v1/payments</code> API.
/// Will be <code>nil</code> for payments associated with the <code>v2</code> API.
@property (nonatomic, readonly, copy) NSString * _Nullable paymentID;
/// Data describing an approved vault flow
@property (nonatomic, readonly, strong) PPCVaultData * _Nullable vaultData;
/// Container for identifiers associated with PayPal domain specific events
@property (nonatomic, readonly, strong) PPCCorrelationIDs * _Nonnull correlationIDs;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// The intent of an order.
/// <ul>
///   <li>
///     <code>authorize</code>: The merchant intends to authorize a payment and place funds on hold after the customer makes a payment.
///   </li>
///   <li>
///     <code>capture</code>: The merchant intends to capture payment immediately after the customer makes a payment.
///   </li>
///   <li>
///     <code>order</code>: The merchant intends to save an order, then authorize to place funds on hold after the customer makes a payment.
///   </li>
/// </ul>
/// <a href="https://developer.paypal.com/docs/api/orders/v2/#orders_create">Intent enum documentation guide</a>
typedef SWIFT_ENUM_NAMED(NSInteger, PPCApprovalOrderIntent, "ApprovalOrderIntent", open) {
/// Non mapped or empty intent
  PPCApprovalOrderIntentNone = 0,
/// The merchant intends to capture payment immediately after the customer makes a payment.
  PPCApprovalOrderIntentCapture = 1,
/// The merchant intends to authorize a payment and place funds on hold after the customer makes a payment.
  PPCApprovalOrderIntentAuthorize = 2,
/// The merchant intends to save an order, then authorize to place funds on hold after the customer makes a payment.
  PPCApprovalOrderIntentOrder = 3,
};

@class UIImage;

SWIFT_CLASS("_TtC14PayPalCheckout20AspectRatioImageView")
@interface AspectRatioImageView : UIImageView
- (nonnull instancetype)initWithFrame:(CGRect)frame OBJC_DESIGNATED_INITIALIZER;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)coder OBJC_DESIGNATED_INITIALIZER SWIFT_UNAVAILABLE;
- (nonnull instancetype)initWithImage:(UIImage * _Nullable)image SWIFT_UNAVAILABLE;
- (nonnull instancetype)initWithImage:(UIImage * _Nullable)image highlightedImage:(UIImage * _Nullable)highlightedImage SWIFT_UNAVAILABLE;
@end

@class PPCOrderActionData;

/// Object representing a successful Authorize action. Currently exclusively wraps the <code>OrderActionData</code>,
/// but may be extended in the future.
SWIFT_CLASS_NAMED("AuthorizeActionSuccess")
@interface PPCAuthorizeActionSuccess : NSObject
/// Data associated with a successful <code>authorize</code> order action
@property (nonatomic, readonly, strong) PPCOrderActionData * _Nonnull data;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


SWIFT_CLASS("_TtC14PayPalCheckout10BackAction")
@interface BackAction : UIButton
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
- (nonnull instancetype)initWithFrame:(CGRect)frame OBJC_DESIGNATED_INITIALIZER;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)coder OBJC_DESIGNATED_INITIALIZER;
@end

@class UIEvent;

/// A specified parent class that indicates background views which are applied
/// when specific pages are presented. These background views will be applied to
/// the view controller where the paysheet itself is presented into.
SWIFT_CLASS("_TtC14PayPalCheckout10Background")
@interface Background : UIView
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)coder OBJC_DESIGNATED_INITIALIZER SWIFT_UNAVAILABLE;
/// We need a better means of passing through taps from child views
/// to parent/super views. This is hack to use <code>shouldPassThroughTouches</code>
/// flag to return super view to handle tap from hit test
- (UIView * _Nullable)hitTest:(CGPoint)point withEvent:(UIEvent * _Nullable)event SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)initWithFrame:(CGRect)frame SWIFT_UNAVAILABLE;
@end


/// Data vended in response to a successful OrderAction for executing a billing agreement
SWIFT_CLASS_NAMED("BillingActionData")
@interface PPCBillingActionData : NSObject
/// The Billing-ID to be used for future billing agreement transactions
@property (nonatomic, readonly, copy) NSString * _Nonnull billingId;
/// The state of the billing agreement, which should be <code>ACTIVE</code> after the billing agreement is executed
@property (nonatomic, readonly, copy) NSString * _Nonnull state;
/// Full JSON response to the billing execute action request
@property (nonatomic, readonly, copy) NSDictionary<NSString *, id> * _Nonnull billingData;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


SWIFT_CLASS("_TtC14PayPalCheckout21BrandedBackgroundView") SWIFT_DEPRECATED_MSG("Please use the new backgrounds member in ExtendedCheckoutConfig")
@interface BrandedBackgroundView : UIView
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)coder SWIFT_UNAVAILABLE;
- (nonnull instancetype)initWithFrame:(CGRect)frame SWIFT_UNAVAILABLE;
@end



/// Object representing a successful capture action. Currently exclusively wraps the <code>OrderActionData</code>,
/// but may be extended in the future.
SWIFT_CLASS_NAMED("CaptureActionSuccess")
@interface PPCCaptureActionSuccess : NSObject
/// Data associated with a successful <code>capture</code> order action
@property (nonatomic, readonly, strong) PPCOrderActionData * _Nonnull data;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


/// The <code>Carousel Cell</code> class hold the FI image and labels, notification label and
/// the preferred view
SWIFT_CLASS("_TtC14PayPalCheckout12CarouselCell")
@interface CarouselCell : UICollectionViewCell
- (nonnull instancetype)initWithFrame:(CGRect)frame SWIFT_UNAVAILABLE;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)aDecoder SWIFT_UNAVAILABLE;
/// Re-setting the cells before they’re reused
- (void)prepareForReuse;
/// Custom HitTest has an additional check before the normal behavior to
/// check if this is something preferredView could handle despite being
/// outside of the cell’s bounds. This is necessary to do because the default
/// behavior does not allow for taps outside of the superview to be claimed
/// by subviews.
- (UIView * _Nullable)hitTest:(CGPoint)point withEvent:(UIEvent * _Nullable)event SWIFT_WARN_UNUSED_RESULT;
@end

@class UITraitCollection;
@class UICollectionView;
@class NSIndexPath;
@class UIScrollView;

/// The carousel view denotes the primary wallet and funding instrument selection
/// component
SWIFT_CLASS("_TtC14PayPalCheckout12CarouselView")
@interface CarouselView : UIView <UICollectionViewDelegate>
- (nonnull instancetype)initWithFrame:(CGRect)frame SWIFT_UNAVAILABLE;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)aDecoder SWIFT_UNAVAILABLE;
- (void)traitCollectionDidChange:(UITraitCollection * _Nullable)previousTraitCollection;
- (void)layoutSubviews;
- (void)collectionView:(UICollectionView * _Nonnull)collectionView didSelectItemAtIndexPath:(NSIndexPath * _Nonnull)indexPath;
/// Cancel previous pending performs on this object and ensure that
/// <code>scrollViewDidEndScrollAnimation</code> is called. This also
/// ensures that <code>selectFIIfNeeded</code> is called if the user scrolls
/// and then drags their finger off the screen. The <code>ensureDelay</code>
/// is to simulate the same delay from <code>scrollViewDidEndDecelerating</code>.
- (void)scrollViewDidScroll:(UIScrollView * _Nonnull)scrollView;
/// This specific method detects when the scroll ends due to the following -
/// • When the user lifts their finger off the screen
/// • When the user drags their finger across and off the screen without lifting their finger
- (void)scrollViewDidEndScrollingAnimation:(UIScrollView * _Nonnull)scrollView;
@end


SWIFT_CLASS("_TtC14PayPalCheckout15CartDetailsView")
@interface CartDetailsView : UIView
- (nonnull instancetype)initWithFrame:(CGRect)frame SWIFT_UNAVAILABLE;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)aDecoder SWIFT_UNAVAILABLE;
@end

/// Information about the channel used to start the checkout flow
typedef SWIFT_ENUM_NAMED(NSInteger, PPCChannel, "Channel", open) {
/// Checkout flow started from a native app
  PPCChannelNative = 0,
/// Checkout flow started from a mobile web browser
  PPCChannelMobileWeb = 1,
/// Checkout flow started from a desktop web browser and continued on a mobile device
  PPCChannelDesktopWeb = 2,
};

enum PPCUserAction : NSInteger;
@class PPCCreateOrderAction;
@class PPCShippingChange;
@class PPCShippingChangeAction;
@class PPCErrorInfo;
@class PPCheckoutConfig;
enum PPCCurrencyCode : NSInteger;
@class UIViewController;

/// The main interface where you can change or start behavior of the Checkout paysheet.
SWIFT_CLASS_NAMED("Checkout")
@interface PPCheckout : NSObject
/// The current version of the Checkout SDK
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, copy) NSString * _Nonnull sdkVersion;)
+ (NSString * _Nonnull)sdkVersion SWIFT_WARN_UNUSED_RESULT;
/// Pay mode used for a checkout session (Continue, Pay Now)
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly) enum PPCUserAction userAction;)
+ (enum PPCUserAction)userAction SWIFT_WARN_UNUSED_RESULT;
/// Determines if the SDK displays an alert before dismissing the paysheet
SWIFT_CLASS_PROPERTY(@property (nonatomic, class) BOOL showsExitAlert;)
+ (BOOL)showsExitAlert SWIFT_WARN_UNUSED_RESULT;
+ (void)setShowsExitAlert:(BOOL)value;
SWIFT_CLASS_PROPERTY(@property (nonatomic, class) BOOL showsExitSurvey SWIFT_DEPRECATED_MSG("The exit survey has been removed. Setting a value to this variable will have no effect.");)
+ (BOOL)showsExitSurvey SWIFT_WARN_UNUSED_RESULT;
+ (void)setShowsExitSurvey:(BOOL)value;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
/// Allows you to set the createOrder callback to be passed into the config object.
/// This will be called when creating order/requesting order ID from merchant.
/// note:
///
/// <ul>
///   <li>
///     This function cannot be called before <code>Checkout.set(config:)</code> or during an active session.
///     Attempting to call this function before <code>Checkout.set(config:)</code> or during an active session will result in
///     the callback not being set.
///   </li>
///   <li>
///     Calling this function will override the createOrder callback of the config set with <code>Checkout.set(config:)</code>
///   </li>
/// </ul>
+ (void)setCreateOrderCallback:(void (^ _Nonnull)(PPCCreateOrderAction * _Nonnull))createOrder;
/// Allows you to set the onApprove callback to be passed into the config object.
/// This will be called when the transaction has been approved.
/// note:
///
/// <ul>
///   <li>
///     This function cannot be called before <code>Checkout.set(config:)</code> or during an active session.
///     Attempting to call this function before <code>Checkout.set(config:)</code> or during an active session will result in
///     the callback not being set.
///   </li>
///   <li>
///     Calling this function will override the onApprove callback of the config set with <code>Checkout.set(config:)</code>
///   </li>
/// </ul>
+ (void)setOnApproveCallback:(void (^ _Nonnull)(PPCApproval * _Nonnull))onApprove;
/// Allows you to set the onShippingChange callback to be passed into the config object.
/// This will be called when the shipping address is changed.
/// note:
///
/// <ul>
///   <li>
///     This function cannot be called before <code>Checkout.set(config:)</code> or during an active session.
///     Attempting to call this function before <code>Checkout.set(config:)</code> or during an active session will result in
///     the callback not being set.
///   </li>
///   <li>
///     Calling this function will override the onShippingChange callback of the config set with <code>Checkout.set(config:)</code>
///   </li>
/// </ul>
+ (void)setOnShippingChangeCallback:(void (^ _Nonnull)(PPCShippingChange * _Nonnull, PPCShippingChangeAction * _Nonnull))onShippingChange;
/// Allows you to set the onCancel callback to be passed into the config object.
/// This will be called when the user has cancelled the transaction.
/// note:
///
/// <ul>
///   <li>
///     This function cannot be called before <code>Checkout.set(config:)</code> or during an active session.
///     Attempting to call this function before <code>Checkout.set(config:)</code> or during an active session will result in
///     the callback not being set.
///   </li>
///   <li>
///     Calling this function will override the onCancel callback of the config set with <code>Checkout.set(config:)</code>
///   </li>
/// </ul>
+ (void)setOnCancelCallback:(void (^ _Nonnull)(void))onCancel;
/// Allows you to set the onError callback to be passed into the config object.
/// This will be called when an error cannot be recovered from, and the transaction has been cancelled.
/// note:
///
/// <ul>
///   <li>
///     This function cannot be called before <code>Checkout.set(config:)</code> or during an active session.
///     Attempting to call this function before <code>Checkout.set(config:)</code> or during an active session will result in
///     the callback not being set.
///   </li>
///   <li>
///     Calling this function will override the onError callback of the config set with <code>Checkout.set(config:)</code>
///   </li>
/// </ul>
+ (void)setOnErrorCallback:(void (^ _Nonnull)(PPCErrorInfo * _Nonnull))onError;
/// Logs out the current user, this will force the user to authenticate on the next session.
/// note:
///
/// <ul>
///   <li>
///     This function cannot be called during an active session.
///     Attempting to call this function during an active session will not logout the user.
///   </li>
/// </ul>
+ (void)logoutUser;
+ (void)setConfig:(PPCheckoutConfig * _Nonnull)config;
/// Set the currency code used to check PaymentButton’s eligibility.
/// Funding eligibility request for buttons will be made again if currency code changes.
/// \param currency the currency code
///
+ (void)setCurrencyCode:(enum PPCCurrencyCode)currency;
/// This function invokes the UI experience for display and must be called from main thread.
/// The hosting app may call this but doing so before <code>set(config:)</code> results in
/// an undefined experience likely resulting in error.
/// note:
/// Callbacks provided in this function will be used only for this checkout session, and
/// won’t override the callbacks you set previously with <code>Checkout.set___Callback()</code>, or with <code>CheckoutConfig.init()</code>.
/// If callbacks are not provided in this function, the callbacks you set previously will be used.
/// <ul>
///   <li>
///     Parameters:
///   </li>
///   <li>
///     presentingViewController: The UIViewController to be used to present the SDK’s experience.
///     If not provided, Checkout.config.presentingViewController will be used if available,
///     otherwise, the top most view controller currently being presented will be used.
///   </li>
///   <li>
///     createOrder: Called when creating order
///   </li>
///   <li>
///     onApprove: Called when the transaction has been approved
///   </li>
///   <li>
///     onCancel: Called when the transaction has been canceled
///   </li>
///   <li>
///     onError: Called when an error cannot be recovered from, and the transaction has been cancelled
///   </li>
/// </ul>
+ (void)startWithPresentingViewController:(UIViewController * _Nullable)presentingViewController createOrder:(void (^ _Nullable)(PPCCreateOrderAction * _Nonnull))createOrder onApprove:(void (^ _Nullable)(PPCApproval * _Nonnull))onApprove onShippingChange:(void (^ _Nullable)(PPCShippingChange * _Nonnull, PPCShippingChangeAction * _Nonnull))onShippingChange onCancel:(void (^ _Nullable)(void))onCancel onError:(void (^ _Nullable)(PPCErrorInfo * _Nonnull))onError;
@end


enum PPCEnvironment : NSInteger;
@class EnvironmentConfig;

/// Holds all the configuration values required by checkout experiences and
/// checkout flows. Modified and provided by the merchant, to start the checkout
/// flow desired.
SWIFT_CLASS_NAMED("CheckoutConfig")
@interface PPCheckoutConfig : NSObject <NSCopying>
/// The clientID is a value that application engineers can receive after registering their
/// application for use with PayPal’s services. Setup for this can be performed here:
/// https://developer.paypal.com/developer/applications/create
@property (nonatomic, copy) NSString * _Nonnull clientID;
/// The EC-Token or Pay-Token or Order ID. This token type is generated in various ways by
/// the merchant, in most cases, and sometimes by PayPal. Nonetheless, this token is required
/// on the base configuration for normal operation.
@property (nonatomic, copy) NSString * _Nullable payToken;
/// Value sent to the payments web experience to determine what payment button should be rendered to the user
/// in the case that the native SDK needs to fall back to the web based checkout flow.
/// This is a property to support the deprecated <code>payments/v1</code> web API. It is disregarded for both
/// the native checkout flow and for users of the <code>payments/v2</code> web API.
@property (nonatomic) enum PPCUserAction userAction;
/// Two separate environments are usually set here, either <code>.sandbox</code> or <code>.live</code>; see <code>Environment</code>
/// documentation for more details on other environments
@property (nonatomic) enum PPCEnvironment environment;
/// An object that allows us to tweak the knobs and levers of the  session to suit our development experience
@property (nonatomic, strong) EnvironmentConfig * _Nonnull environmentConfig;
@property (nonatomic, copy) void (^ _Nullable onAuthenticate)(void (^ _Nonnull)(NSString * _Nullable, NSError * _Nullable));
/// Called when the authentication session needs to be passed from native to web
@property (nonatomic, copy) void (^ _Nullable onAuthStepUp)(NSString * _Nullable, void (^ _Nonnull)(NSString * _Nullable, NSError * _Nullable));
/// Called when creating order/requesting order ID from merchant
/// createOrder passes a CreateOrderAction that can be used to either request the SDK to create an order or set the payToken with your order ID/pay token/EC token
@property (nonatomic, copy) void (^ _Nullable createOrder)(PPCCreateOrderAction * _Nonnull);
/// Called when the transaction has been approved.
@property (nonatomic, copy) void (^ _Nullable onApprove)(PPCApproval * _Nonnull);
/// Called when the user has cancelled the transaction.
@property (nonatomic, copy) void (^ _Nullable onCancel)(void);
/// Called when an error cannot be recovered from, and the transaction has been cancelled
@property (nonatomic, copy) void (^ _Nullable onError)(PPCErrorInfo * _Nonnull);
/// Called if the user logs out. The transaction will allow the user to log in?
@property (nonatomic, copy) void (^ _Nullable onLogout)(void);
/// Called when the user changes their shipping address from the paysheet
@property (nonatomic, copy) void (^ _Nullable onShippingChange)(PPCShippingChange * _Nonnull, PPCShippingChangeAction * _Nonnull);
/// When the application needs to specify which view controller will be used
/// to present the SDK’s experience. Failing this, the root most view
/// controller currently being presented will be used.
@property (nonatomic, strong) UIViewController * _Nullable presentingViewController;
/// Value to force a fallback to the Web Checkout experience instead of the Native experience.
@property (nonatomic) BOOL showWebCheckout;
/// Determines whether to show a button to copy debug payload into clipboard
@property (nonatomic) BOOL debugEnabled;
/// Optional merchant ID(s) for partners used for PaymentButton’s eligibility check.
/// This is only used for partner, marketplaces, and cart solutions when they are acting
/// on behalf of another merchant. For merchants acting on behalf of several merchants,
/// pass each merchant ID into the array. For merchants action on behalf of a single merchant,
/// you will only need to pass a single merchant ID into the array.
@property (nonatomic, copy) NSArray<NSString *> * _Nullable merchantIDs;
- (nonnull instancetype)initWithClientID:(NSString * _Nonnull)clientID createOrder:(void (^ _Nullable)(PPCCreateOrderAction * _Nonnull))createOrder onApprove:(void (^ _Nullable)(PPCApproval * _Nonnull))onApprove onShippingChange:(void (^ _Nullable)(PPCShippingChange * _Nonnull, PPCShippingChangeAction * _Nonnull))onShippingChange onCancel:(void (^ _Nullable)(void))onCancel onError:(void (^ _Nullable)(PPCErrorInfo * _Nonnull))onError environment:(enum PPCEnvironment)environment OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)initWithClientID:(NSString * _Nonnull)clientID returnUrl:(NSString * _Nonnull)returnUrl createOrder:(void (^ _Nullable)(PPCCreateOrderAction * _Nonnull))createOrder onApprove:(void (^ _Nullable)(PPCApproval * _Nonnull))onApprove onShippingChange:(void (^ _Nullable)(PPCShippingChange * _Nonnull, PPCShippingChangeAction * _Nonnull))onShippingChange onCancel:(void (^ _Nullable)(void))onCancel onError:(void (^ _Nullable)(PPCErrorInfo * _Nonnull))onError environment:(enum PPCEnvironment)environment SWIFT_DEPRECATED_MSG("`init(clientID:returnUrl: ...)` has been deprecated and will be removed in a future version of the SDK. Use `init(clientID: ...)` instead");
- (id _Nonnull)copyWithZone:(struct _NSZone * _Nullable)zone SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@class PPCSessionIDs;

/// Correlation IDs are debug IDs that the PayPal team uses to track issues.
SWIFT_CLASS_NAMED("CorrelationIDs")
@interface PPCCorrelationIDs : NSObject
/// Our correlation id associated when checking funding eligibility for payment buttons
@property (nonatomic, readonly, copy) NSString * _Nullable fundingEligibilityDebugID;
/// Our correlation id associated when checking eligibility.
@property (nonatomic, readonly, copy) NSString * _Nullable eligibilityDebugID;
/// Our correlation id associated when updating client config.
@property (nonatomic, readonly, copy) NSString * _Nullable updateClientConfigDebugID;
/// Our correlation id associated when upgrading LSAT.
@property (nonatomic, readonly, copy) NSString * _Nullable lsatUpgradeDebugID;
/// Our correlation id associated when fetching user info.
@property (nonatomic, readonly, copy) NSString * _Nullable fetchPayloadDebugID;
/// Our correlation ids associated when fetching cart on shipping callback
@property (nonatomic, readonly, copy) NSArray<NSString *> * _Nonnull fetchCartDebugIDs;
/// Our correlation id associated when converting currency info.
@property (nonatomic, readonly, copy) NSString * _Nullable currencyConversionDebugID;
/// Our correlation id associated when completing SCA.
@property (nonatomic, readonly, copy) NSString * _Nullable completeSCADebugID;
/// Our correlation id associated when finishing the checkout flow.
@property (nonatomic, readonly, copy) NSString * _Nullable finishCheckoutDebugID;
@property (nonatomic, readonly, copy) NSString * _Nullable riskCorrelationID;
/// Our session identifiers
@property (nonatomic, readonly, strong) PPCSessionIDs * _Nonnull sessionIDs;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

@class PPCOrderRequest;

/// CreateOrderAction object to be passed in CreateOrderCallback,
/// allowing merchants options to create order and obtain EC-Token (or Pay-Token or Order ID),
/// either by their own means or using built in functions in the SDK.
SWIFT_CLASS_NAMED("CreateOrderAction")
@interface PPCCreateOrderAction : NSObject
/// Request the SDK to create an order and get an order ID with PayPal Orders API.
/// Once completed, payToken is set with the order ID requested from Orders API to be used internally in the SDK.
/// Documentation on Orders API: https://developer.paypal.com/docs/api/orders/v2/#orders_create
/// \param order an OrderRequest object representing the order
///
/// \param completion a closure with the order ID once the SDK finishes creating order
///
- (void)createWithOrder:(PPCOrderRequest * _Nonnull)order completion:(void (^ _Nonnull)(NSString * _Nullable))completion;
/// Set payToken to be used internally in the SDK if you have an order ID/pay token/EC token
/// \param orderId an order ID/pay token/EC token
///
- (void)setWithOrderId:(NSString * _Nonnull)orderId;
/// Interface to provide the SDK with a Billing Agreement token. This will trigger a fallback to a web experience for a user
/// to log in and complete the agreement.
/// note:
///
/// To generate a billing agreement token using your server implementation,
/// <a href="https://developer.paypal.com/docs/limited-release/reference-transactions/#create-billing-agreement-token">see our documentation on reference transactions</a>
/// \param billingAgreementToken Billing agreement token
///
- (void)setWithBillingAgreementToken:(NSString * _Nonnull)billingAgreementToken;
/// Interface to provide the SDK with a Vault approval session ID to let user add a funding instrument to vault to be used for future transactions.
/// note:
///
/// To generate a vault approval session ID using your server implementation,
/// <a href="https://developer.paypal.com/limited-release/vault-payment-methods/vault-api">see our documentation on reference transactions</a>
/// \param vaultApprovalSessionID Vault approval session ID
///
- (void)setWithVaultApprovalSessionID:(NSString * _Nonnull)vaultApprovalSessionID;
/// In case your request to create order fails, call this function instead of <code>set(orderId:)</code> in order to close the Paysheet.
- (void)cancel;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


SWIFT_CLASS("_TtC14PayPalCheckout14CryptoRateView")
@interface CryptoRateView : UIView
- (nonnull instancetype)initWithFrame:(CGRect)frame SWIFT_UNAVAILABLE;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)aDecoder SWIFT_UNAVAILABLE;
@end

/// An enum of the possible values to be passed as the curency code.
/// <a href="https://developer.paypal.com/docs/api/orders/v2/#definition-currency_code">Currency code enum documentation guide</a>
typedef SWIFT_ENUM_NAMED(NSInteger, PPCCurrencyCode, "CurrencyCode", open) {
  PPCCurrencyCodeAud = 0,
  PPCCurrencyCodeBrl = 1,
  PPCCurrencyCodeCad = 2,
  PPCCurrencyCodeCny = 3,
  PPCCurrencyCodeCzk = 4,
  PPCCurrencyCodeDkk = 5,
  PPCCurrencyCodeEur = 6,
  PPCCurrencyCodeHkd = 7,
  PPCCurrencyCodeHuf = 8,
  PPCCurrencyCodeInr = 9,
  PPCCurrencyCodeIls = 10,
  PPCCurrencyCodeJpy = 11,
  PPCCurrencyCodeMyr = 12,
  PPCCurrencyCodeMxn = 13,
  PPCCurrencyCodeTwd = 14,
  PPCCurrencyCodeNzd = 15,
  PPCCurrencyCodeNok = 16,
  PPCCurrencyCodePhp = 17,
  PPCCurrencyCodePln = 18,
  PPCCurrencyCodeGbp = 19,
  PPCCurrencyCodeRub = 20,
  PPCCurrencyCodeSgd = 21,
  PPCCurrencyCodeSek = 22,
  PPCCurrencyCodeChf = 23,
  PPCCurrencyCodeThb = 24,
  PPCCurrencyCodeUsd = 25,
};


SWIFT_CLASS("_TtC14PayPalCheckout12DeliveryView")
@interface DeliveryView : UIView
- (nonnull instancetype)initWithFrame:(CGRect)frame SWIFT_UNAVAILABLE;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)aDecoder SWIFT_UNAVAILABLE;
@end


/// Used to determine which endpoints to target for interactions with the PayPal API.
typedef SWIFT_ENUM_NAMED(NSInteger, PPCEnvironment, "Environment", open) {
/// The live environent for use in production
  PPCEnvironmentLive = 0,
/// The environment used for development and testing
  PPCEnvironmentSandbox = 1,
/// Environment for internal PayPal use. Inaccessible for third party.
  PPCEnvironmentStage = 2,
};


/// A config that toggles shims in the code for development purposes.
SWIFT_CLASS("_TtC14PayPalCheckout17EnvironmentConfig")
@interface EnvironmentConfig : NSObject <NSCopying>
/// Toggle  eligibility check for stage or sandbox
/// The default true setting will check for eligibility while false will force
/// <code>State.isNativeEligible = true</code> and skip the actual network call
@property (nonatomic) BOOL checksEligibility;
- (id _Nonnull)copyWithZone:(struct _NSZone * _Nullable)zone SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end


/// Encapsulates metadata after <code>CheckoutConfig.onError</code> is called.
/// This meta information can be utilized to debug our checkout sessions.
SWIFT_CLASS_NAMED("ErrorInfo")
@interface PPCErrorInfo : NSObject
/// The actual error.
@property (nonatomic, readonly) NSError * _Nonnull error;
/// The error reason.
@property (nonatomic, readonly, copy) NSString * _Nonnull reason;
/// Container for identifiers associated with PayPal domain specific events
@property (nonatomic, readonly, strong) PPCCorrelationIDs * _Nonnull correlationIDs;
/// Pay token/EC-Token/OrderID
@property (nonatomic, readonly, copy) NSString * _Nonnull payToken;
/// SDK version.
@property (nonatomic, readonly, copy) NSString * _Nonnull nativeSdkVersion;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


/// This class should contain all the extended featurs privy to first party
/// or implicity trusted host applications. Those not explicity validated to
/// be on the whitelist for the PayPal iOS Checkout SDK will find that all
/// extended features in this class are ignored.
SWIFT_CLASS("_TtC14PayPalCheckout22ExtendedCheckoutConfig")
@interface ExtendedCheckoutConfig : PPCheckoutConfig
/// A  session ID generated from the Smart Payment
/// Button will be required to authenticate the Firebase App.
/// The sessionUID is retrieved from the merchant and
/// then used with PayPal’s GraphQL to generate a sessionToken.
@property (nonatomic, copy) NSString * _Nullable sessionUID;
/// The button session id associated with the merchant from SPB (web to app).
@property (nonatomic, copy) NSString * _Nullable buttonSessionID;
/// The stickiness id associated passed from SPB
@property (nonatomic, copy) NSString * _Nullable stickinessID;
@property (nonatomic, copy) NSString * _Nullable pageUrl;
/// Merchant’s client ID
@property (nonatomic, copy) NSString * _Nullable facilitatorClientID;
/// Merchant’s domain
@property (nonatomic, copy) NSString * _Nullable domain;
/// Allows merchants to force an experience on, for example Venmo (passed from SPB)
@property (nonatomic, copy) NSArray<NSString *> * _Nonnull enableFunding;
/// Information about the channel used to start the checkout flow (native, mobile web, desktop web, etc)
@property (nonatomic) enum PPCChannel channel;
/// The app guid is passed from consumer app, stored in Keychain. It is utilized
/// as a way to tie together events from different components when triaging issues
/// on the server-side.
@property (nonatomic, copy) NSString * _Nullable appGuid;
/// The device id is passed from the consumer app, stored in Keychain. It is utilized
/// as a way to tie together events from different components when triaging issues
/// on the server side.
@property (nonatomic, copy) NSString * _Nullable deviceId;
/// When transaction requires a shipping address and a user does not have one
/// SDK cannot proceed and falls back to web. Setting this property to <code>true</code> allows SDK to proceed
/// with responsibility to collect a shipping address and provide it to SDK moving to the host app.
@property (nonatomic) BOOL skipsShippingAddressContingency;
/// Indicates whether Billing Agreements are supported by a host or not.
/// If not, the checkout flow will fallback to web if this is supported (see <code>supportsWebFallbacks</code>).
@property (nonatomic) BOOL supportsBillingAgreements;
/// Indicates whether or not web fallbacks are supported
@property (nonatomic) BOOL supportsWebFallbacks;
/// Determines if SDK should skip updating any functionality/process
/// that depends on a returned experiment and treatment value
/// and defaults the functionality/process to its control state
@property (nonatomic, copy) NSArray<NSString *> * _Nullable elmoExperimentsToSkip;
/// Used to determine whether we’re using Firebase in the current lifecycle
@property (nonatomic, readonly) BOOL usesFirebase;
/// Called right after a user clicks to Add Card natively. We need to
/// upgrade the auth state of the user so that we can perform the
/// Add Card action server side.
@property (nonatomic, copy) void (^ _Nullable onAddCardStepUp)(void (^ _Nonnull)(NSString * _Nullable, NSError * _Nullable));
- (nonnull instancetype)initWithClientID:(NSString * _Nonnull)clientID createOrder:(void (^ _Nullable)(PPCCreateOrderAction * _Nonnull))createOrder onApprove:(void (^ _Nullable)(PPCApproval * _Nonnull))onApprove onShippingChange:(void (^ _Nullable)(PPCShippingChange * _Nonnull, PPCShippingChangeAction * _Nonnull))onShippingChange onCancel:(void (^ _Nullable)(void))onCancel onError:(void (^ _Nullable)(PPCErrorInfo * _Nonnull))onError environment:(enum PPCEnvironment)environment SWIFT_UNAVAILABLE;
@end



SWIFT_CLASS("_TtC14PayPalCheckout8Legalese")
@interface Legalese : UIView
- (nonnull instancetype)initWithFrame:(CGRect)frame OBJC_DESIGNATED_INITIALIZER;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)coder OBJC_DESIGNATED_INITIALIZER;
@end


SWIFT_CLASS("_TtC14PayPalCheckout21LineItemContainerView")
@interface LineItemContainerView : UIView
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)aDecoder SWIFT_UNAVAILABLE;
- (nonnull instancetype)initWithFrame:(CGRect)frame SWIFT_UNAVAILABLE;
@end


SWIFT_CLASS("_TtC14PayPalCheckout13LogoImageView")
@interface LogoImageView : UIImageView
- (nonnull instancetype)initWithFrame:(CGRect)frame OBJC_DESIGNATED_INITIALIZER;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)coder OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)initWithImage:(UIImage * _Nullable)image OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)initWithImage:(UIImage * _Nullable)image highlightedImage:(UIImage * _Nullable)highlightedImage OBJC_DESIGNATED_INITIALIZER;
@end







/// Data vended in response to a successful OrderAction for capturing/authorizing funds
SWIFT_CLASS_NAMED("OrderActionData")
@interface PPCOrderActionData : NSObject
/// Identifier of the response
@property (nonatomic, readonly, copy) NSString * _Nonnull id;
/// Status of the response
@property (nonatomic, readonly, copy) NSString * _Nonnull status;
/// Full JSON response to the order action request
@property (nonatomic, copy) NSDictionary<NSString *, id> * _Nonnull orderData;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


/// Describes an address.
/// Should be used in the creation of the folowing objects
/// <ul>
///   <li>
///     <a href="https://developer.paypal.com/docs/api/orders/v2/#definition-shipping_detail.address_portable">PurchaseUnit.shipping.address</a>
///   </li>
///   <li>
///     <a href="https://developer.paypal.com/docs/api/orders/v2/#definition-payer.address_portable">Payer.address</a>
///   </li>
/// </ul>
SWIFT_CLASS_NAMED("OrderAddress")
@interface PPCOrderAddress : NSObject
/// The first line of the address. For example, number or street. For example, 173 Drury Lane.
/// Required for data entry and compliance and risk checks. Must contain the full address. Maximum length: 300.
@property (nonatomic, readonly, copy) NSString * _Nullable addressLine1;
/// The second line of the address. For example, suite or apartment number.
/// Maximum length: 300.
@property (nonatomic, readonly, copy) NSString * _Nullable addressLine2;
/// The highest level sub-division in a country, which is usually a province, state, or ISO-3166-2 subdivision.
/// Format for postal delivery. For example, CA and not California.
/// Value, by country, is:
/// <ul>
///   <li>
///     UK: A county.
///   </li>
///   <li>
///     US: A state.
///   </li>
///   <li>
///     Canada: A province.
///   </li>
///   <li>
///     Japan: A prefecture.
///   </li>
///   <li>
///     Switzerland: A kanton.
///   </li>
/// </ul>
/// Maximum length: 300.
@property (nonatomic, readonly, copy) NSString * _Nullable adminArea1;
/// A city, town, or village. Smaller than admin_area_level_1.
/// <ul>
///   <li>
///     Maximum length: 120.
///   </li>
/// </ul>
@property (nonatomic, readonly, copy) NSString * _Nullable adminArea2;
/// The postal code, which is the zip code or equivalent. Typically required for countries with a postal code or an equivalent.
/// <ul>
///   <li>
///     Maximum length: 60.
///   </li>
/// </ul>
@property (nonatomic, readonly, copy) NSString * _Nullable postalCode;
/// The <a href="https://developer.paypal.com/docs/api/reference/country-codes/">two-character ISO 3166-1 code</a> that identifies the country or region.
@property (nonatomic, readonly, copy) NSString * _Nonnull countryCode;
- (nonnull instancetype)initWithCountryCode:(NSString * _Nonnull)countryCode addressLine1:(NSString * _Nullable)addressLine1 addressLine2:(NSString * _Nullable)addressLine2 adminArea1:(NSString * _Nullable)adminArea1 adminArea2:(NSString * _Nullable)adminArea2 postalCode:(NSString * _Nullable)postalCode OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

enum PPCOrderApplicationContextShippingPreference : NSInteger;
enum PPCOrderApplicationContextUserAction : NSInteger;
@class PPCOrderApplicationContextPaymentMethod;
@class PPCOrderApplicationContextStoredPaymentSource;

/// A class that represents the possible values to be passed as part of the application context object.
/// <a href="https://developer.paypal.com/docs/api/orders/v2/#definition-order_application_context">OrderApplicationContext object documentation guide</a>
SWIFT_CLASS_NAMED("OrderApplicationContext")
@interface PPCOrderApplicationContext : NSObject
/// The label that overrides the business name in the PayPal account on the PayPal site. Maximum length: 127.
@property (nonatomic, readonly, copy) NSString * _Nullable brandName;
/// The BCP 47-formatted locale of pages that the PayPal payment experience shows. PayPal supports a five-character code.
/// For example, da-DK, he-IL, id-ID, ja-JP, no-NO, pt-BR, ru-RU, sv-SE, th-TH, zh-CN, zh-HK, or zh-TW.
/// <ul>
///   <li>
///     Minimum length: 2
///   </li>
///   <li>
///     Maximum length: 10
///   </li>
///   <li>
///     Pattern: ^[a-z]{2}(?:-[A-Z][a-z]{3})?(?:-(?:[A-Z]{2}))?$
///   </li>
/// </ul>
@property (nonatomic, readonly, copy) NSString * _Nullable locale;
/// The shipping preference
/// <ul>
///   <li>
///     Displays the shipping address to the customer.
///   </li>
///   <li>
///     Enables the customer to choose an address on the PayPal site.
///   </li>
///   <li>
///     Restricts the customer from changing the address during the payment-approval process.
///   </li>
/// </ul>
@property (nonatomic, readonly) enum PPCOrderApplicationContextShippingPreference shippingPreference;
/// Configures a Continue or Pay Now checkout flow.
@property (nonatomic, readonly) enum PPCOrderApplicationContextUserAction userAction;
/// The customer and merchant payment preferences.
@property (nonatomic, readonly, strong) PPCOrderApplicationContextPaymentMethod * _Nullable paymentMethod;
/// The URL where the customer is redirected after the customer approves the payment.
@property (nonatomic, readonly, copy) NSString * _Nullable returnUrl;
/// The URL where the customer is redirected after the customer cancels the payment.
@property (nonatomic, readonly, copy) NSString * _Nullable cancelUrl;
/// Provides additional details to process a payment using a <code>payment_source</code>
/// that has been stored or is intended to be stored (also referred to as stored_credential or card-on-file).
@property (nonatomic, readonly, strong) PPCOrderApplicationContextStoredPaymentSource * _Nullable storedPaymentSource;
- (nonnull instancetype)initWithBrandName:(NSString * _Nullable)brandName locale:(NSString * _Nullable)locale shippingPreference:(enum PPCOrderApplicationContextShippingPreference)shippingPreference userAction:(enum PPCOrderApplicationContextUserAction)userAction paymentMethod:(PPCOrderApplicationContextPaymentMethod * _Nullable)paymentMethod returnUrl:(NSString * _Nullable)returnUrl cancelUrl:(NSString * _Nullable)cancelUrl storedPaymentSource:(PPCOrderApplicationContextStoredPaymentSource * _Nullable)storedPaymentSource OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// Shipping preference set by the merchant. Affects the ability of the payer to change their shipping information
/// within the PayPal SDK
typedef SWIFT_ENUM_NAMED(NSInteger, PPCOrderApplicationContextShippingPreference, "ShippingPreference", open) {
  PPCOrderApplicationContextShippingPreferenceNone = 0,
/// Use the customer-provided shipping address on the PayPal site.
  PPCOrderApplicationContextShippingPreferenceGetFromFile = 1,
/// Redact the shipping address from the PayPal site. Recommended for digital goods.
  PPCOrderApplicationContextShippingPreferenceNoShipping = 2,
/// Use the merchant-provided address. The customer cannot change this address on the PayPal site.
  PPCOrderApplicationContextShippingPreferenceSetProvidedAddress = 3,
};

/// Defines whether to present the customer with a Continue or Pay Now checkout flow.
typedef SWIFT_ENUM_NAMED(NSInteger, PPCOrderApplicationContextUserAction, "UserAction", open) {
  PPCOrderApplicationContextUserActionNone = 0,
/// Use this option when the final amount is not known when the checkout flow is initiated and you want
/// to redirect the customer to the merchant page without processing the payment.
  PPCOrderApplicationContextUserActionContinue = 1,
/// Use this option when the final amount is known when the checkout is initiated and you want to process
/// the payment immediately when the customer clicks Pay Now.
  PPCOrderApplicationContextUserActionPayNow = 2,
};

enum PPCOrderApplicationContextPayerSelected : NSInteger;
enum PPCOrderApplicationContextPayeePreferred : NSInteger;
enum PPCOrderApplicationContextStandardEntryClassCode : NSInteger;

/// The customer and merchant payment preferences.
SWIFT_CLASS_NAMED("PaymentMethod")
@interface PPCOrderApplicationContextPaymentMethod : NSObject
/// The customer-selected payment method on the merchant site.
/// <ul>
///   <li>
///     Minimum length: 1
///   </li>
///   <li>
///     Pattern: ^[0-9A-Z_]+$
///   </li>
/// </ul>
@property (nonatomic, readonly) enum PPCOrderApplicationContextPayerSelected payerSelected;
/// The merchant-preferred payment methods.
@property (nonatomic, readonly) enum PPCOrderApplicationContextPayeePreferred payeePreferred;
/// NACHA (the regulatory body governing the ACH network) requires that API callers
/// (merchants, partners) obtain the consumer’s explicit authorization before initiating a transaction. To stay compliant,
/// you’ll need to make sure that you retain a compliant authorization for each transaction that you originate to the ACH Network
/// using this API. ACH transactions are categorized (using SEC codes) by how you capture authorization from the Receiver
/// (the person whose bank account is being debited or credited).
@property (nonatomic, readonly) enum PPCOrderApplicationContextStandardEntryClassCode standardEntryClassCode;
- (nonnull instancetype)initWithPayerSelected:(enum PPCOrderApplicationContextPayerSelected)payerSelected payeePreferred:(enum PPCOrderApplicationContextPayeePreferred)payeePreferred standardEntryClassCode:(enum PPCOrderApplicationContextStandardEntryClassCode)standardEntryClassCode OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// The customer-selected payment method on the merchant site.
/// Possible values are:
/// <ul>
///   <li>
///     PayPal
///   </li>
///   <li>
///     PayPal Credit
///   </li>
/// </ul>
typedef SWIFT_ENUM_NAMED(NSInteger, PPCOrderApplicationContextPayerSelected, "PayerSelected", open) {
  PPCOrderApplicationContextPayerSelectedNone = 0,
  PPCOrderApplicationContextPayerSelectedPaypal = 1,
  PPCOrderApplicationContextPayerSelectedPaypalCredit = 2,
  PPCOrderApplicationContextPayerSelectedPaypalPayLater = 3,
  PPCOrderApplicationContextPayerSelectedFlexPay = 4,
};

/// Describes possible merchant-preferred payment methods.
typedef SWIFT_ENUM_NAMED(NSInteger, PPCOrderApplicationContextPayeePreferred, "PayeePreferred", open) {
  PPCOrderApplicationContextPayeePreferredNone = 0,
/// Accepts any type of payment from the customer.
  PPCOrderApplicationContextPayeePreferredUnrestricted = 1,
/// Accepts only immediate payment from the customer.
/// For example, credit card, PayPal balance, or instant ACH. Ensures that at the time of capture,
/// the payment does not have the <code>pending</code> status.
  PPCOrderApplicationContextPayeePreferredImmediatePaymentRequired = 2,
};

/// Describes the possible entry class codes
typedef SWIFT_ENUM_NAMED(NSInteger, PPCOrderApplicationContextStandardEntryClassCode, "StandardEntryClassCode", open) {
  PPCOrderApplicationContextStandardEntryClassCodeNone = 0,
/// The API caller (merchant/partner) accepts authorization and payment information from a consumer over the telephone.
  PPCOrderApplicationContextStandardEntryClassCodeTel = 1,
/// The API caller (merchant/partner) accepts Debit transactions from a consumer on their website.
  PPCOrderApplicationContextStandardEntryClassCodeWeb = 2,
/// Cash concentration and disbursement for corporate debit transaction. Used to disburse or consolidate funds.
/// Entries are usually Optional high-dollar, low-volume, and time-critical. (e.g. intra-company transfers or invoice
/// payments to suppliers).
  PPCOrderApplicationContextStandardEntryClassCodeCcd = 3,
/// Prearranged payment and deposit entries. Used for debit payments authorized by a consumer account holder,<br/>
/// and usually initiated by a company. These are usually recurring debits (such as insurance premiums).
  PPCOrderApplicationContextStandardEntryClassCodePpd = 4,
};

enum PPCOrderApplicationContextPaymentInitiator : NSInteger;
enum PPCOrderApplicationContextPaymentType : NSInteger;
enum PPCOrderApplicationContextUsage : NSInteger;
@class PPCOrderApplicationContextPreviousNetworkTransactionReference;

/// Provides additional details to process a payment using a <code>payment_source</code>
/// that has been stored or is intended to be stored (also referred to as stored_credential or card-on-file).
SWIFT_CLASS_NAMED("StoredPaymentSource")
@interface PPCOrderApplicationContextStoredPaymentSource : NSObject
/// The person or party who initiated or triggered the payment.
@property (nonatomic, readonly) enum PPCOrderApplicationContextPaymentInitiator paymentInitiator;
/// Indicates the type of the stored payment_source payment.
@property (nonatomic, readonly) enum PPCOrderApplicationContextPaymentType paymentType;
/// Indicates if this is a first or subsequent payment using a stored payment source
/// (also referred to as stored credential or card on file).
@property (nonatomic, readonly) enum PPCOrderApplicationContextUsage usage;
/// Reference values used by the card network to identify a transaction.
@property (nonatomic, readonly, strong) PPCOrderApplicationContextPreviousNetworkTransactionReference * _Nullable previousNetworkTransactionReference;
- (nonnull instancetype)initWithPaymentInitiator:(enum PPCOrderApplicationContextPaymentInitiator)paymentInitiator paymentType:(enum PPCOrderApplicationContextPaymentType)paymentType usage:(enum PPCOrderApplicationContextUsage)usage previousNetworkTransactionReference:(PPCOrderApplicationContextPreviousNetworkTransactionReference * _Nullable)previousNetworkTransactionReference OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// Describes the person or party who initiated or triggered the payment.
typedef SWIFT_ENUM_NAMED(NSInteger, PPCOrderApplicationContextPaymentInitiator, "PaymentInitiator", open) {
/// Payment is initiated with the active engagement of the customer. e.g. a customer checking out on a merchant website.
  PPCOrderApplicationContextPaymentInitiatorCustomer = 0,
/// Payment is initiated by merchant on behalf of the customer without the active engagement of customer.
/// e.g. a merchant charging the monthly payment of a subscription to the customer.
  PPCOrderApplicationContextPaymentInitiatorMerchant = 1,
};

/// Describes the type of payment
typedef SWIFT_ENUM_NAMED(NSInteger, PPCOrderApplicationContextPaymentType, "PaymentType", open) {
/// One Time payment such as online purchase or donation. (e.g. Checkout with one-click).
  PPCOrderApplicationContextPaymentTypeOneTime = 0,
/// Payment which is part of a series of payments with fixed or variable amounts, following a fixed time interval.
/// (e.g. Subscription payments).
  PPCOrderApplicationContextPaymentTypeRecurring = 1,
/// Payment which is part of a series of payments that occur on a non-fixed schedule and/or have variable amounts.
/// (e.g. Account Topup payments).
  PPCOrderApplicationContextPaymentTypeUnscheduled = 2,
};

/// Indicates if this is a first or subsequent payment using a stored payment source
/// (also referred to as stored credential or card on file).
typedef SWIFT_ENUM_NAMED(NSInteger, PPCOrderApplicationContextUsage, "Usage", open) {
  PPCOrderApplicationContextUsageNone = 0,
/// Indicates the Initial/First payment with a payment_source that is intended to be stored upon successful processing of the payment.
  PPCOrderApplicationContextUsageFirst = 1,
/// Indicates a payment using a stored payment_source which has been successfully used previously for a payment.
  PPCOrderApplicationContextUsageSubsequent = 2,
/// Indicates that PayPal will derive the value of <code>FIRST</code> or <code>SUBSEQUENT</code> based on data available to PayPal.
  PPCOrderApplicationContextUsageDerived = 3,
};

enum PPCOrderApplicationContextNetwork : NSInteger;

/// Reference values used by the card network to identify a transaction.
SWIFT_CLASS_NAMED("PreviousNetworkTransactionReference")
@interface PPCOrderApplicationContextPreviousNetworkTransactionReference : NSObject
/// Transaction reference id returned by the scheme. For Visa and Amex, this is the “Tran id” field in response. For MasterCard,
/// this is the “BankNet reference id” field in response. For Discover, this is the “NRID” field in response.
/// <ul>
///   <li>
///     Minimum length: 9
///   </li>
///   <li>
///     Maximum length: 15.
///   </li>
///   <li>
///     Pattern: ^[a-zA-Z0-9]+$
///   </li>
/// </ul>
@property (nonatomic, readonly, copy) NSString * _Nonnull id;
/// The date that the transaction was authorized by the scheme. For MasterCard, this is the “BankNet reference date” field in response.
/// <ul>
///   <li>
///     Minimum length: 4
///   </li>
///   <li>
///     Maximum length: 4
///   </li>
///   <li>
///     Pattern: ^[0-9]+$.
///   </li>
/// </ul>
@property (nonatomic, readonly, copy) NSString * _Nullable date;
/// Name of the card network through which the transaction was routed.
@property (nonatomic, readonly) enum PPCOrderApplicationContextNetwork network;
- (nonnull instancetype)initWithId:(NSString * _Nonnull)id network:(enum PPCOrderApplicationContextNetwork)network date:(NSString * _Nullable)date OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// The possible value of network types
typedef SWIFT_ENUM_NAMED(NSInteger, PPCOrderApplicationContextNetwork, "Network", open) {
  PPCOrderApplicationContextNetworkVisa = 0,
  PPCOrderApplicationContextNetworkMastercard = 1,
  PPCOrderApplicationContextNetworkDiscover = 2,
  PPCOrderApplicationContextNetworkAmex = 3,
  PPCOrderApplicationContextNetworkSolo = 4,
  PPCOrderApplicationContextNetworkJcb = 5,
  PPCOrderApplicationContextNetworkStar = 6,
  PPCOrderApplicationContextNetworkDelta = 7,
  PPCOrderApplicationContextNetworkSwitchCard = 8,
  PPCOrderApplicationContextNetworkMaestro = 9,
  PPCOrderApplicationContextNetworkCbNationale = 10,
  PPCOrderApplicationContextNetworkConfigoga = 11,
  PPCOrderApplicationContextNetworkConfidis = 12,
  PPCOrderApplicationContextNetworkElectron = 13,
  PPCOrderApplicationContextNetworkCetelem = 14,
  PPCOrderApplicationContextNetworkChinaUnionPay = 15,
};

@class PPCOrderPayer;
@class PPCPurchaseUnit;

/// Data vended in response to a successful <code>OrderAction</code> for getting the current details of an existing order
/// The <code>Payer</code> and <code>PurchaseUnits</code> properties contain most of the information related to a specific order.
SWIFT_CLASS_NAMED("OrderDetails")
@interface PPCOrderDetails : PPCOrderActionData
/// An object representing the current Payer of the order
@property (nonatomic, readonly, strong) PPCOrderPayer * _Nullable payer;
/// Array of <code>PurchaseUnit</code> that are part of the order. This also contains other useful details
/// about the order such as payment history containing details about captures.
@property (nonatomic, readonly, copy) NSArray<PPCPurchaseUnit *> * _Nonnull purchaseUnits;
@end

/// An enum of the possible values to be passed as the intent of an order.
/// Possible vales are: <code>authorize</code> and <code>capture</code>
/// <a href="https://developer.paypal.com/docs/api/orders/v2/#orders_create">Intent enum documentation guide</a>
typedef SWIFT_ENUM_NAMED(NSInteger, PPCOrderIntent, "OrderIntent", open) {
  PPCOrderIntentCapture = 0,
  PPCOrderIntentAuthorize = 1,
};

@class PPCOrderPayerName;
@class PPCOrderPayerPhone;
@class PPCOrderPayerTaxInfo;

/// A class that represents the possible values to be passed as part of the payer object.
/// <a href="https://developer.paypal.com/docs/api/orders/v2/#definition-payer">Payer object documentation guide</a>
SWIFT_CLASS_NAMED("OrderPayer")
@interface PPCOrderPayer : NSObject
/// The name of the payer. Supports only the <code>given_name</code> and <code>surname</code> properties.
@property (nonatomic, readonly, strong) PPCOrderPayerName * _Nullable name;
/// The email address of the payer.
@property (nonatomic, readonly, copy) NSString * _Nullable emailAddress;
/// The PayPal-assigned ID for the payer.
@property (nonatomic, readonly, copy) NSString * _Nullable payerId;
/// The phone number of the customer. Available only when you enable the Contact Telephone Number option
/// in the Profile & Settings for themerchant’s PayPal account. The <code>phone.phone_number</code> supports only <code>national_number</code>.
@property (nonatomic, readonly, strong) PPCOrderPayerPhone * _Nullable phone;
/// The birth date of the payer in YYYY-MM-DD format.
@property (nonatomic, readonly, copy) NSString * _Nullable birthDate;
/// The tax information of the payer. Required only for Brazilian payers. Both <code>tax_id</code> and <code>tax_id_type</code> are required.
@property (nonatomic, readonly, strong) PPCOrderPayerTaxInfo * _Nullable taxInfo;
/// The address of the payer. Supports only the <code>address_line_1</code>, <code>address_line_2</code>,
/// <code>admin_area_1</code>, <code>admin_area_2</code>, <code>postal_code</code>, and <code>country_code</code> properties.
/// Also referred to as the billing address of the customer.
@property (nonatomic, readonly, strong) PPCOrderAddress * _Nullable address;
- (nonnull instancetype)initWithName:(PPCOrderPayerName * _Nullable)name emailAddress:(NSString * _Nullable)emailAddress payerId:(NSString * _Nullable)payerId phone:(PPCOrderPayerPhone * _Nullable)phone birthDate:(NSString * _Nullable)birthDate taxInfo:(PPCOrderPayerTaxInfo * _Nullable)taxInfo address:(PPCOrderAddress * _Nullable)address OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


/// The name of the payer. Supports only the <code>given_name</code> and <code>surname</code> properties.
SWIFT_CLASS_NAMED("Name")
@interface PPCOrderPayerName : NSObject
/// When the party is a person, the party’s given, or first, name. Maximum length: 140.
@property (nonatomic, readonly, copy) NSString * _Nullable givenName;
/// When the party is a person, the party’s surname or family name. Also known as the last name.
/// Required when the party is a person. Use also to store multiple surnames including the matronymic, or mother’s, surname.
/// Maximum length: 140.
@property (nonatomic, readonly, copy) NSString * _Nullable surname;
- (nonnull instancetype)initGivenName:(NSString * _Nullable)givenName surname:(NSString * _Nullable)surname OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

enum PPCOrderPayerPhoneType : NSInteger;
@class PPCOrderPayerPhoneNumber;

/// The phone number of the customer. Available only when you enable the Contact Telephone Number option in the
/// Profile & Settings for the merchant’s PayPal account. The <code>phone.phone_number</code> supports only <code>national_number</code>.
SWIFT_CLASS_NAMED("Phone")
@interface PPCOrderPayerPhone : NSObject
/// The phone type.
@property (nonatomic, readonly) enum PPCOrderPayerPhoneType phoneType;
/// The phone number, in its canonical international
/// <a href="https://www.itu.int/rec/T-REC-E.164/en">E.164 numbering plan format.</a>
/// Supports only the national_number property.
@property (nonatomic, readonly, strong) PPCOrderPayerPhoneNumber * _Nonnull phoneNumber;
- (nonnull instancetype)initWithPhoneNumber:(PPCOrderPayerPhoneNumber * _Nonnull)phoneNumber phoneType:(enum PPCOrderPayerPhoneType)phoneType OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// The phone type.
typedef SWIFT_ENUM_NAMED(NSInteger, PPCOrderPayerPhoneType, "PhoneType", open) {
  PPCOrderPayerPhoneTypeNone = 0,
  PPCOrderPayerPhoneTypeFax = 1,
  PPCOrderPayerPhoneTypeHome = 2,
  PPCOrderPayerPhoneTypeMobile = 3,
  PPCOrderPayerPhoneTypeOther = 4,
  PPCOrderPayerPhoneTypePager = 5,
};


/// The phone number, in its canonical international <a href="https://www.itu.int/rec/T-REC-E.164/en">E.164 numbering plan format.</a>
/// Supports only the national_number property.
SWIFT_CLASS_NAMED("PhoneNumber")
@interface PPCOrderPayerPhoneNumber : NSObject
/// The national number, in its canonical international E.164 numbering plan format.
/// The combined length of the country calling code (CC) and the national number must not be greater than 15 digits.
/// The national number consists of a national destination code (NDC) and subscriber number (SN).
/// <ul>
///   <li>
///     Minimum length: 1
///   </li>
///   <li>
///     Maximum length: 14
///   </li>
///   <li>
///     Pattern: ^[0-9]{1,14}?$
///   </li>
/// </ul>
@property (nonatomic, readonly, copy) NSString * _Nonnull nationalNumber;
- (nonnull instancetype)initWithNationalNumber:(NSString * _Nonnull)nationalNumber OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

enum PPCOrderPayerTaxIdType : NSInteger;

/// The tax information of the payer. Required only for Brazilian payer’s. Both <code>tax_id</code> and <code>tax_id_type</code> are required.
SWIFT_CLASS_NAMED("TaxInfo")
@interface PPCOrderPayerTaxInfo : NSObject
/// The customer’s tax ID. Supported for the PayPal payment method only. Typically, the tax ID is 11 characters long
/// for individuals and 14 characters long for businesses.
/// <ul>
///   <li>
///     Maximum length: 14
///   </li>
/// </ul>
@property (nonatomic, readonly, copy) NSString * _Nonnull taxId;
/// The customer’s tax ID type. Supported for the PayPal payment method only.
@property (nonatomic, readonly) enum PPCOrderPayerTaxIdType taxIdType;
- (nonnull instancetype)initWithTaxId:(NSString * _Nonnull)taxId taxIdType:(enum PPCOrderPayerTaxIdType)taxIdType OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// The type of the Tax ID
typedef SWIFT_ENUM_NAMED(NSInteger, PPCOrderPayerTaxIdType, "TaxIdType", open) {
/// BR_CPF. The individual tax ID type.
  PPCOrderPayerTaxIdTypeIndividual = 0,
/// BR_CNPJ. The business tax ID type.
  PPCOrderPayerTaxIdTypeBuisness = 1,
};

enum PPCOrderProcessingInstruction : NSInteger;

/// The order request object is used to format the <code>orderRequest</code> for the <code>CreateOrderAction</code>
/// <a href="https://developer.paypal.com/docs/api/orders/v2/#orders_create">Create order documentation</a>
/// note:
/// This class is for use exclusively with the order v2 API
SWIFT_CLASS_NAMED("OrderRequest")
@interface PPCOrderRequest : NSObject
/// The intent to either capture payment immediately or authorize a payment for an order after order creation.
@property (nonatomic, readonly) enum PPCOrderIntent intent;
/// The customer who approves and pays for the order. The customer is also known as the payer.
@property (nonatomic, readonly, strong) PPCOrderPayer * _Nullable payer;
/// An array of purchase units. Each purchase unit establishes a contract between a payer and the payee.
/// Each purchase unit represents either a full or partial order that the payer intends to purchase from the payee.
@property (nonatomic, readonly, copy) NSArray<PPCPurchaseUnit *> * _Nonnull purchaseUnits;
/// Customize the payer experience during the approval process for the payment with PayPal.
@property (nonatomic, readonly, strong) PPCOrderApplicationContext * _Nullable applicationContext;
- (nonnull instancetype)initWithIntent:(enum PPCOrderIntent)intent purchaseUnits:(NSArray<PPCPurchaseUnit *> * _Nonnull)purchaseUnits processingInstruction:(enum PPCOrderProcessingInstruction)processingInstruction payer:(PPCOrderPayer * _Nullable)payer applicationContext:(PPCOrderApplicationContext * _Nullable)applicationContext OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


/// A successful request returns the HTTP 204 No Content status code with an empty object in the JSON response body.
SWIFT_CLASS_NAMED("PatchActionSuccess")
@interface PPCPatchActionSuccess : NSObject
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

@class PPCPurchaseUnitShippingName;
@class PPCShippingMethod;
@class PPCPurchaseUnitAmount;

/// Represents each operation and their accepted path, as well as the paths accepted value for each type.
/// <a href="https://developer.paypal.com/docs/api/orders/v2#orders_patch">Patch Order Documentation</a>
/// note:
///
/// <ul>
///   <li>
///     To make an update, you may optionally provide a <code>reference_id</code>. If you omit a <code>reference_id</code>,
///     PayPal defaults to a <code>reference_id</code> of <code>default</code>.
///   </li>
/// </ul>
SWIFT_CLASS_NAMED("PatchRequest")
@interface PPCPatchRequest : NSObject
/// Adds a <code>shippingName</code> to the order request.
/// \param shippingName The name of the person to whom to ship the items. Supports only the <code>full_name</code> property.
///
/// \param referenceId The API caller-provided external ID for the purchase unit if more than one purchase unit was provided.
///
- (void)addWithShippingName:(PPCPurchaseUnitShippingName * _Nonnull)shippingName referenceId:(NSString * _Nullable)referenceId;
/// Adds a <code>shippingAddress</code> to the order request.
/// \param shippingAddress The address of the person to whom to ship the items.
///
/// \param referenceId The API caller-provided external ID for the purchase unit if more than one purchase unit was provided.
///
- (void)addWithShippingAddress:(PPCOrderAddress * _Nonnull)shippingAddress referenceId:(NSString * _Nullable)referenceId;
/// Adds <code>shippingOptions</code> to the order request
/// \param shippingOptions A list of shipping options for the order.
///
/// \param referenceId The API caller-provided external ID for the purchase unit if more than one purchase unit was provided.
///
- (void)addWithShippingOptions:(NSArray<PPCShippingMethod *> * _Nonnull)shippingOptions referenceId:(NSString * _Nullable)referenceId;
/// Replaces the <code>shippingName</code> of the order request.
/// \param shippingName The name of the person to whom to ship the items. Supports only the <code>full_name</code> property.
///
/// \param referenceId The API caller-provided external ID for the purchase unit if more than one purchase unit was provided.
///
- (void)replaceWithShippingName:(PPCPurchaseUnitShippingName * _Nonnull)shippingName referenceId:(NSString * _Nullable)referenceId;
/// Replaces the <code>shippingAddress</code> of the order request.
/// \param shippingAddress The address of the person to whom to ship the items.
///
/// \param referenceId The API caller-provided external ID for the purchase unit if more than one purchase unit was provided.
///
- (void)replaceWithShippingAddress:(PPCOrderAddress * _Nonnull)shippingAddress referenceId:(NSString * _Nullable)referenceId;
/// Replaces the <code>shippingOptions</code> of the order request.
/// \param shippingOptions A list of shipping options for the order.
///
/// \param referenceId The API caller-provided external ID for the purchase unit if more than one purchase unit was provided.
///
- (void)replaceWithShippingOptions:(NSArray<PPCShippingMethod *> * _Nonnull)shippingOptions referenceId:(NSString * _Nullable)referenceId;
/// Replaces the <code>amount</code> of the order request.
/// \param amount The total order amount with an optional breakdown that provides details, such as the total item
/// amount, total tax amount, shipping, handling, insurance, and discounts, if any.
///
/// \param referenceId The API caller-provided external ID for the purchase unit if more than one purchase unit was provided.
///
- (void)replaceWithAmount:(PPCPurchaseUnitAmount * _Nonnull)amount referenceId:(NSString * _Nullable)referenceId;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

enum PPCPayPalPayLaterButtonColor : NSInteger;
@class PPCPaymentButtonAttributes;

/// Configuration for Pay Later Smart Payment Button.
/// \param color Defines the colors available for PayPal buttons, see <code>PayPalButtonColor</code>.
///
/// \param attributes Defines different attributes to configure shape and size of Pay Later button, see <code>ButtonAttributes</code>.
///
SWIFT_CLASS_NAMED("PayLaterButtonUIConfiguration")
@interface PPCPayLaterButtonUIConfiguration : NSObject
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)initWithColor:(enum PPCPayPalPayLaterButtonColor)color attributes:(PPCPaymentButtonAttributes * _Nonnull)attributes OBJC_DESIGNATED_INITIALIZER;
@end

enum PPCPaymentButtonFundingSource : NSInteger;
enum PPCPaymentButtonColor : NSInteger;
enum PPCPaymentButtonEdges : NSInteger;
enum PPCPaymentButtonSize : NSInteger;

/// The <code>PaymentButton</code> is utilized to provide a seamless integration for a checkout
/// experience similar to how the web handles PayPal checkout experiences.
SWIFT_CLASS_NAMED("PaymentButton") SWIFT_DEPRECATED_MSG("Use PaymentButtonContainer() instead.")
@interface PPCPaymentButton : UIButton
@property (nonatomic, getter=isHighlighted) BOOL highlighted;
- (void)checkoutFinished;
/// The type of the button’s funding source (e.g. PayPal, Pay Later, Credit)
@property (nonatomic, readonly) enum PPCPaymentButtonFundingSource fundingSource;
/// The color of the button
@property (nonatomic) enum PPCPaymentButtonColor color;
/// The corners of the button and how they should be shaped.
@property (nonatomic) enum PPCPaymentButtonEdges edges;
/// The size enum determines how the button will be shown.
@property (nonatomic) enum PPCPaymentButtonSize size;
@property (nonatomic, getter=isEnabled) BOOL enabled;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)coder SWIFT_UNAVAILABLE;
- (void)layoutSubviews;
- (nonnull instancetype)initWithFrame:(CGRect)frame SWIFT_UNAVAILABLE;
@end

enum PPCPayPalButtonColor : NSInteger;
enum PPCPayPalButtonLabel : NSInteger;

/// PayPalButton provides a PayPal button with the ability to modify color, edges, size, insets and label.
/// Tapping on PayPalButton will start checkout with Native Checkout SDK Paysheet.
SWIFT_CLASS_NAMED("PayPalButton") SWIFT_DEPRECATED_MSG("Use PaymentButtonContainer() instead.")
@interface PPCPayPalButton : PPCPaymentButton
/// Initialize a PayPalButton
/// \param insets Edge insets of the button, defining the spacing of the button’s edges relative to its content.
///
/// \param color Color of the button. Default to gold if not provided.
///
/// \param edges Edges of the button. Default to softEdges if not provided.
///
/// \param size Size of the button. Default to collapsed if not provided.
///
/// \param label Label displayed next to the button’s logo. Default to no label.
///
- (nonnull instancetype)initWithInsets:(NSDirectionalEdgeInsets)insets color:(enum PPCPayPalButtonColor)color edges:(enum PPCPaymentButtonEdges)edges size:(enum PPCPaymentButtonSize)size label:(enum PPCPayPalButtonLabel)label isEnabled:(BOOL)isEnabled SWIFT_DEPRECATED_MSG("Use PaymentButtonContainer() instead.");
/// Initialize a PayPalButton. The insets of the button will be set appropriately depending on the button’s size.
/// \param color Color of the button. Default to gold if not provided.
///
/// \param edges Edges of the button. Default to softEdges if not provided.
///
/// \param size Size of the button. Default to collapsed if not provided.
///
/// \param label Label displayed next to the button’s logo. Default to no label.
///
- (nonnull instancetype)initWithColor:(enum PPCPayPalButtonColor)color edges:(enum PPCPaymentButtonEdges)edges size:(enum PPCPaymentButtonSize)size label:(enum PPCPayPalButtonLabel)label isEnabled:(BOOL)isEnabled SWIFT_DEPRECATED_MSG("Use PaymentButtonContainer() instead.");
@end

/// Available colors for PayPalButton.
typedef SWIFT_ENUM_NAMED(NSInteger, PPCPayPalButtonColor, "Color", open) {
  PPCPayPalButtonColorGold = 0,
  PPCPayPalButtonColorWhite = 1,
  PPCPayPalButtonColorBlack = 2,
  PPCPayPalButtonColorSilver = 3,
  PPCPayPalButtonColorBlue = 4,
};

/// Available labels for PayPalButton.
typedef SWIFT_ENUM_NAMED(NSInteger, PPCPayPalButtonLabel, "Label", open) {
/// Display no label
  PPCPayPalButtonLabelNone = -1,
/// Display “Checkout” on the right side of the button’s logo
  PPCPayPalButtonLabelCheckout = 0,
/// Display “Buy now” on the right side of the button’s logo
  PPCPayPalButtonLabelBuyNow = 1,
/// Display “Pay with” on the left side of the button’s logo
  PPCPayPalButtonLabelPayWith = 2,
};


/// Configuration for PayPal Smart Payment Button.
/// \param color Defines the colors available for PayPal buttons, see <code>PayPalButtonColor</code>.
///
/// \param label Defines the labels available for payment buttons. If no label is provided then it will
/// default to <code>PAYPAL</code>, which will default to no label and only displaying the PayPal wordmark. For
/// other labels they will have the label value itself along with a position either at the start or
/// the end of the button, see <code>PayPalButtonLabel</code>.
///
/// \param attributes Defines different attributes to configure shape and size of PayPal button, see <code>ButtonAttributes</code>.
///
SWIFT_CLASS_NAMED("PayPalButtonUIConfiguration")
@interface PPCPayPalButtonUIConfiguration : NSObject
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)initWithColor:(enum PPCPayPalButtonColor)color label:(enum PPCPayPalButtonLabel)label attributes:(PPCPaymentButtonAttributes * _Nonnull)attributes OBJC_DESIGNATED_INITIALIZER;
@end

enum PPCPayPalCreditButtonColor : NSInteger;

/// PayPalCreditButton provides a PayPal Credit button with the ability to modify color, edges, size and insets.
/// Tapping on PayPalCreditButton will bring users to checkout with PayPalCredit on web.
SWIFT_CLASS_NAMED("PayPalCreditButton") SWIFT_DEPRECATED_MSG("Use PaymentButtonContainer() instead.")
@interface PPCPayPalCreditButton : PPCPaymentButton
/// Initialize a PayPalCreditButton
/// \param insets Edge insets of the button, defining the spacing of the button’s edges relative to its content.
///
/// \param color Color of the button. Default to dark blue if not provided.
///
/// \param edges Edges of the button. Default to softEdges if not provided.
///
/// \param size Size of the button. Default to collapsed if not provided.
///
- (nonnull instancetype)initWithInsets:(NSDirectionalEdgeInsets)insets color:(enum PPCPayPalCreditButtonColor)color edges:(enum PPCPaymentButtonEdges)edges size:(enum PPCPaymentButtonSize)size isEnabled:(BOOL)isEnabled SWIFT_DEPRECATED_MSG("Use PaymentButtonContainer() instead.");
/// Initialize a PayPalCreditButton. The insets of the button will be set appropriately depending on the button’s size.
/// \param color Color of the button. Default to dark blue if not provided.
///
/// \param edges Edges of the button. Default to softEdges if not provided.
///
/// \param size Size of the button. Default to collapsed if not provided.
///
- (nonnull instancetype)initWithColor:(enum PPCPayPalCreditButtonColor)color edges:(enum PPCPaymentButtonEdges)edges size:(enum PPCPaymentButtonSize)size isEnabled:(BOOL)isEnabled SWIFT_DEPRECATED_MSG("Use PaymentButtonContainer() instead.");
@end

/// Available colors for PayPalCreditButton.
typedef SWIFT_ENUM_NAMED(NSInteger, PPCPayPalCreditButtonColor, "Color", open) {
  PPCPayPalCreditButtonColorWhite = 1,
  PPCPayPalCreditButtonColorBlack = 2,
  PPCPayPalCreditButtonColorDarkBlue = 5,
};


/// Configuration for PayPal Credit Smart Payment Button.
/// \param color Defines the colors available for PayPal Credit button, see <code>PayPalCreditButtonColor</code>.
///
/// \param attributes Defines different attributes to configure shape and size of PayPal Credit button, see <code>ButtonAttributes</code>.
///
SWIFT_CLASS_NAMED("PayPalCreditButtonUIConfiguration")
@interface PPCPayPalCreditButtonUIConfiguration : NSObject
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)initWithColor:(enum PPCPayPalCreditButtonColor)color attributes:(PPCPaymentButtonAttributes * _Nonnull)attributes OBJC_DESIGNATED_INITIALIZER;
@end


/// PayPalPayLaterButton provides a Pay in 4 with PayPal button with the ability to modify color, edges, size and insets.
/// Tapping on PayPalPayLaterButton will bring users to checkout with Pay in 4 on web, where users can apply for and pay with Pay in 4.
SWIFT_CLASS_NAMED("PayPalPayLaterButton") SWIFT_DEPRECATED_MSG("Use PaymentButtonContainer() instead.")
@interface PPCPayPalPayLaterButton : PPCPaymentButton
/// Initialize a PayPalPayLaterButton
/// \param insets Edge insets of the button, defining the spacing of the button’s edges relative to its content.
///
/// \param color Color of the button. Default to gold if not provided.
///
/// \param edges Edges of the button. Default to softEdges if not provided.
///
/// \param size Size of the button. Default to collapsed if not provided.
///
- (nonnull instancetype)initWithInsets:(NSDirectionalEdgeInsets)insets color:(enum PPCPayPalPayLaterButtonColor)color edges:(enum PPCPaymentButtonEdges)edges size:(enum PPCPaymentButtonSize)size isEnabled:(BOOL)isEnabled SWIFT_DEPRECATED_MSG("Use PaymentButtonContainer() instead.");
/// Initialize a PayPalPayLaterButton. The insets of the button will be set appropriately depending on the button’s size.
/// \param color Color of the button. Default to gold if not provided.
///
/// \param edges Edges of the button. Default to softEdges if not provided.
///
/// \param size Size of the button. Default to collapsed if not provided.
///
- (nonnull instancetype)initWithColor:(enum PPCPayPalPayLaterButtonColor)color edges:(enum PPCPaymentButtonEdges)edges size:(enum PPCPaymentButtonSize)size isEnabled:(BOOL)isEnabled SWIFT_DEPRECATED_MSG("Use PaymentButtonContainer() instead.");
@end

/// Available colors for PayPalPayLaterButton.
typedef SWIFT_ENUM_NAMED(NSInteger, PPCPayPalPayLaterButtonColor, "Color", open) {
  PPCPayPalPayLaterButtonColorGold = 0,
  PPCPayPalPayLaterButtonColorWhite = 1,
  PPCPayPalPayLaterButtonColorBlack = 2,
  PPCPayPalPayLaterButtonColorSilver = 3,
  PPCPayPalPayLaterButtonColorBlue = 4,
};



/// These are different attributes to configure the native Smart Payment Button style.
/// \param edges Defines the edge available for payment buttons. If no edge is provided then the default
/// button style will be retrieved from the applications root style, see <code>PaymentButtonSize</code>.
///
/// \param size Defines the sizes available for payment buttons. If no size is provided then it will
/// default to medium. Button size is used for setting properties like minimum width and height to
/// allow for the use of wrap_content where necessary along with modifying the size of the wordmark
/// and adjusting padding within the button, see <code>PaymentButtonSize</code>.
///
/// \param isEnabled Is a flag set by the merchant to control whether to show or hide the native Smart Payment Button.
/// if native Smart Payment Button is ineligible we will ignore this flag and we will not show the button.
///
SWIFT_CLASS_NAMED("PaymentButtonAttributes")
@interface PPCPaymentButtonAttributes : NSObject
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)initWithEdges:(enum PPCPaymentButtonEdges)edges size:(enum PPCPaymentButtonSize)size isEnabled:(BOOL)isEnabled OBJC_DESIGNATED_INITIALIZER;
@end

/// The Smart Payment Button type, this will adjust our images, colors, sizes, etc.
typedef SWIFT_ENUM_NAMED(NSInteger, PPCPaymentButtonColor, "PaymentButtonColor", open) {
/// The gold background and blue wordmark, monogram, and black text.
  PPCPaymentButtonColorGold = 0,
/// The white background and blue wordmark, monogram, and black text.
  PPCPaymentButtonColorWhite = 1,
/// The black background and monochrome wordmark, monogram, and white text.
  PPCPaymentButtonColorBlack = 2,
/// The silver background and blue wordmark, monogram, and black text.
  PPCPaymentButtonColorSilver = 3,
/// The blue background and white wordmark, blue monogram, and white text.
  PPCPaymentButtonColorBlue = 4,
/// The dark blue background with PayPal Credit wordmark and monogram.
  PPCPaymentButtonColorDarkBlue = 5,
};

@protocol PPCPaymentButtonContainerDelegate;
enum PPCPaymentButtonEligibilityStatus : NSInteger;

/// A container UI element that groups all the PayPal buttons (PayPal, PayLater, Credit).
/// PaymentButtonContainer provides PayPal buttons with the ability to
/// modify the PayPalButtonUI, PayPalCreditButtonUI, and PayLaterButtonUI, their attributes,
/// and implement the PaymentButtonContainerDelegate
SWIFT_CLASS_NAMED("PaymentButtonContainer")
@interface PPCPaymentButtonContainer : UIView
/// Returns a container that includes a single PayPal button only.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) PPCPaymentButtonContainer * _Nonnull withPayPalButtonOnly;)
+ (PPCPaymentButtonContainer * _Nonnull)withPayPalButtonOnly SWIFT_WARN_UNUSED_RESULT;
/// A closure provided to create an order based on an action item.
@property (nonatomic, copy) void (^ _Nullable createOrder)(PPCCreateOrderAction * _Nonnull);
/// A closure that gets executed when Checkout was approved.
@property (nonatomic, copy) void (^ _Nullable onApproval)(PPCApproval * _Nonnull);
/// A closure that gets executed when Checkout was cancelled.
@property (nonatomic, copy) void (^ _Nullable onCancel)(void);
/// A closure that gets executed when Checkout fails.
@property (nonatomic, copy) void (^ _Nullable onError)(PPCErrorInfo * _Nonnull);
/// A closure that gets executed when shipping was changed.
@property (nonatomic, copy) void (^ _Nullable onShippingChange)(PPCShippingChange * _Nonnull, PPCShippingChangeAction * _Nonnull);
/// Initializer to configure the container button
/// \param payPalButtonUI Setup ui of PayPal button
///
/// \param payPalCreditButtonUI Setup ui of PayPal Credit button
///
/// \param payLaterButtonUI Setup ui of Pay Later button
///
/// \param delegate provide some lifecycles methods to be called.
///
- (nonnull instancetype)initWithPayPalButtonUIConfiguration:(PPCPayPalButtonUIConfiguration * _Nonnull)payPalButtonUIConfiguration payPalCreditButtonUIConfiguration:(PPCPayPalCreditButtonUIConfiguration * _Nonnull)payPalCreditButtonUIConfiguration payLaterButtonUIConfiguration:(PPCPayLaterButtonUIConfiguration * _Nonnull)payLaterButtonUIConfiguration delegate:(id <PPCPaymentButtonContainerDelegate> _Nullable)delegate OBJC_DESIGNATED_INITIALIZER;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)coder SWIFT_UNAVAILABLE;
/// Configures the callback closures.
/// \param createOrder Callback to either supply an order token or order details to the Checkout SDK.
///
/// \param onApproval This will be called when the transaction has been approved.
///
/// \param onCancel This will be called when transaction has been cancelled.
///
/// \param onError This will be called when an error cannot be recovered from, and the transaction has been cancelled.
///
/// \param onShippingChange This will be called when the user selects a new shipping address or shipping method.
///
- (void)setupWithCreateOrder:(void (^ _Nullable)(PPCCreateOrderAction * _Nonnull))createOrder onApproval:(void (^ _Nullable)(PPCApproval * _Nonnull))onApproval onCancel:(void (^ _Nullable)(void))onCancel onError:(void (^ _Nullable)(PPCErrorInfo * _Nonnull))onError onShippingChange:(void (^ _Nullable)(PPCShippingChange * _Nonnull, PPCShippingChangeAction * _Nonnull))onShippingChange;
/// Update payPalButtonUI the attributes programmatically and override the values.
/// \param configuration Instance to update the payPalButtonUI
///
- (void)configurePayPalButtonWith:(PPCPayPalButtonUIConfiguration * _Nonnull)configuration;
/// Update payPalCreditButtonUI the attributes programmatically and override the values.
/// \param configuration Instance to update the payPalCreditButtonUI
///
- (void)configurePayPalCreditButtonWith:(PPCPayPalCreditButtonUIConfiguration * _Nonnull)configuration;
/// Update payLaterButtonUI the attributes programmatically and override the values.
/// \param configuration Instance to update the payLaterButtonUI
///
- (void)configurePayLaterButtonWith:(PPCPayLaterButtonUIConfiguration * _Nonnull)configuration;
- (void)onButtonStart:(PPCPaymentButton * _Nonnull)button;
- (void)onButtonFinish:(PPCPaymentButton * _Nonnull)button;
- (void)button:(PPCPaymentButton * _Nonnull)button changedEligibilityStatus:(enum PPCPaymentButtonEligibilityStatus)status;
- (nonnull instancetype)initWithFrame:(CGRect)frame SWIFT_UNAVAILABLE;
@end

@class PPCPaymentFundingEligibilityState;

/// PaymentButtonContainerDelegate for managing native Smart Payment Button container eligibility and ui status
SWIFT_PROTOCOL_NAMED("PaymentButtonContainerDelegate")
@protocol PPCPaymentButtonContainerDelegate
/// This function will be invoked as soon as the eligibility call is triggered and PaymentButtonContainer view starts loading.
- (void)onLoading;
/// This function will be invoked as soon as the eligibility call is triggered and PaymentButtonContainer view is finished.
/// \param fundingEligibilityState Contains information about each one of the native smart payments button
/// [PAYPAL], [PAYPAL_CREDIT] or [PAY_LATER] and whether the button is eligible or not
/// indication for which button is eligible.
///
- (void)onFinishWithFundingEligibilityState:(PPCPaymentFundingEligibilityState * _Nonnull)fundingEligibilityState;
@end

/// Edges for the Smart Payment Button, these affect the corner radius.
typedef SWIFT_ENUM_NAMED(NSInteger, PPCPaymentButtonEdges, "PaymentButtonEdges", open) {
/// Hard edges on button with 0 corner radius.
  PPCPaymentButtonEdgesHardEdges = 0,
/// Soft edges with a corner radius of 4 pts.
  PPCPaymentButtonEdgesSoftEdges = 1,
/// Pill shaped corner radius.
  PPCPaymentButtonEdgesRounded = 2,
};

/// Status of PaymentButton’s eligibility
typedef SWIFT_ENUM_NAMED(NSInteger, PPCPaymentButtonEligibilityStatus, "PaymentButtonEligibilityStatus", open) {
/// Button’s eligibility check is in progress
  PPCPaymentButtonEligibilityStatusLoading = 0,
/// Button’s eligibility check is finished and button is eligible
  PPCPaymentButtonEligibilityStatusEligible = 1,
/// Button’s eligibility check is finished and button is not eligible
  PPCPaymentButtonEligibilityStatusIneligible = 2,
/// Button’s eligibility check failed
  PPCPaymentButtonEligibilityStatusError = 3,
};

/// The funding source to be used when checkout with PaymentButton
typedef SWIFT_ENUM_NAMED(NSInteger, PPCPaymentButtonFundingSource, "PaymentButtonFundingSource", open) {
  PPCPaymentButtonFundingSourcePayPal = 0,
  PPCPaymentButtonFundingSourcePayLater = 1,
  PPCPaymentButtonFundingSourceCredit = 2,
};

/// The label displayed next to PaymentButton’s logo.
typedef SWIFT_ENUM_NAMED(NSInteger, PPCPaymentButtonLabel, "PaymentButtonLabel", open) {
/// Add “Checkout” to the right of button’s logo
  PPCPaymentButtonLabelCheckout = 0,
/// Add “Buy Now” to the right of button’s logo
  PPCPaymentButtonLabelBuyNow = 1,
/// Add “Pay with” to the left of button’s logo
  PPCPaymentButtonLabelPayWith = 2,
/// Add “Pay later” to the right of button’s logo, only used for PayPalPayLaterButton
  PPCPaymentButtonLabelPayLater = 3,
};

/// The size category which determines how the button is shown.
typedef SWIFT_ENUM_NAMED(NSInteger, PPCPaymentButtonSize, "PaymentButtonSize", open) {
/// Circle shaped button similar to a floating action button will show the monogram, if <code>.venmo</code> then will show <code>Venmo</code> logo.
  PPCPaymentButtonSizeMini = 0,
/// Collapsed will only show the wordmark.
  PPCPaymentButtonSizeCollapsed = 1,
/// Expanded shows the wordmark along with the suffix.
  PPCPaymentButtonSizeExpanded = 2,
/// Full will show the wordmark along with the prefix and suffix.
  PPCPaymentButtonSizeFull = 3,
};


/// PaymentFundingEligibilityState is a model to provide the eligibility response for each Funding
/// Each funding will have the reasons for eligibility/ineligibility
SWIFT_CLASS_NAMED("PaymentFundingEligibilityState")
@interface PPCPaymentFundingEligibilityState : NSObject
/// If the response has failed or received any kind of error.
@property (nonatomic, readonly) NSError * _Nullable error;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// An enum of the possible values to be passed as the instruction to process an order.
/// Possible vales are: <code>ORDER_SAVED_EXPLICITLY</code>, <code>ORDER_SAVED_ON_BUYER_APPROVAL</code>, <code>ORDER_COMPLETE_ON_PAYMENT_APPROVAL</code>, <code>NO_INSTRUCTION</code>
/// <a href="https://developer.paypal.com/docs/limited-release/orders/v2/api/#orders_create">Processing instruction enum documentation guide</a>
typedef SWIFT_ENUM_NAMED(NSInteger, PPCOrderProcessingInstruction, "ProcessingInstruction", open) {
  PPCOrderProcessingInstructionNone = 0,
/// The API caller saves the order for future payment processing by making an explicit v2/checkout/orders/id/save call after the payer approves the order.
  PPCOrderProcessingInstructionOrderSavedExplicitly = 1,
/// PayPal implicitly saves the order on behalf of the API caller after the payer approves the order. Note that this option is not currently supported.
  PPCOrderProcessingInstructionOrderSavedOnBuyerApproval = 2,
/// API Caller expects the Order to be auto completed (i.e. for PayPal to authorize or capture depending on the intent) on completion of payer approval.
/// This option is not relevant for payment_source that typically do not require a payer approval or interaction. This option is currently only available
/// for the following payment_source: Alipay, Bancontact, BLIK, eps, giropay, Multibanco, MyBank, P24, PayU, POLi, Sofort, Trustly, TrustPay,
/// Verkkopankki, WeChat Pay
  PPCOrderProcessingInstructionOrderCompleteOnPaymentApproval = 3,
/// The API caller intends to authorize v2/checkout/orders/id/authorize or capture v2/checkout/orders/id/capture after the payer approves the order.
  PPCOrderProcessingInstructionNoInstruction = 4,
};


SWIFT_CLASS("_TtC14PayPalCheckout18ProfileImageBubble")
@interface ProfileImageBubble : UIImageView
- (nonnull instancetype)initWithFrame:(CGRect)frame SWIFT_UNAVAILABLE;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)aDecoder SWIFT_UNAVAILABLE;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
- (void)traitCollectionDidChange:(UITraitCollection * _Nullable)previousTraitCollection;
- (nonnull instancetype)initWithImage:(UIImage * _Nullable)image SWIFT_UNAVAILABLE;
- (nonnull instancetype)initWithImage:(UIImage * _Nullable)image highlightedImage:(UIImage * _Nullable)highlightedImage SWIFT_UNAVAILABLE;
@end

@class PPCPurchaseUnitPayee;
@class PPCPurchaseUnitPaymentInstruction;
@class PPCPurchaseUnitItem;
@class PPCPurchaseUnitShipping;

/// A class that represents the possible values to be passed as part of the purchase unit object.
/// <a href="https://developer.paypal.com/docs/api/orders/v2/#definition-purchase_unit_request">Purchase units request documentation guide</a>
SWIFT_CLASS_NAMED("PurchaseUnit")
@interface PPCPurchaseUnit : NSObject
/// The API caller-provided external ID for the purchase unit.
/// If you omit this value and the order contains only one purchase unit, PayPal sets this value to <code>default</code>. Maximum length: 256.
@property (nonatomic, readonly, copy) NSString * _Nullable referenceId;
/// The total order amount with an optional breakdown that provides details,
/// such as the total item amount, total tax amount, shipping, handling, insurance, and discounts, if any.
/// If you specify amount.breakdown, the amount equals item_total plus tax_total plus shipping plus handling plus
/// insurance minus shipping_discount minus discount. The amount must be a positive number.
@property (nonatomic, readonly, strong) PPCPurchaseUnitAmount * _Nonnull amount;
/// The merchant who receives payment for this transaction.
@property (nonatomic, readonly, strong) PPCPurchaseUnitPayee * _Nullable payee;
/// Any additional payment instructions for PayPal Commerce Platform customers.
/// Enables features for the PayPal Commerce Platform, such as delayed disbursement and collection of a platform fee.
/// Applies during order creation for captured payments or during capture of authorized payments.
@property (nonatomic, readonly, strong) PPCPurchaseUnitPaymentInstruction * _Nullable paymentInstruction;
/// The purchase description. Maximum length: 127.
@property (nonatomic, readonly, copy) NSString * _Nullable purchaseUnitDescription;
/// The API caller-provided external ID. Used to reconcile client transactions with PayPal transactions.
/// Appears in transaction and settlement reports but is not visible to the payer. Maximum length: 127.
@property (nonatomic, readonly, copy) NSString * _Nullable customId;
/// The API caller-provided external invoice number for this order.
/// Appears in both the payer’s transaction history and the emails that the payer receives. Maximum length: 127.
@property (nonatomic, readonly, copy) NSString * _Nullable invoiceId;
/// The soft descriptor is the dynamic text used to construct the
/// statement descriptor that appears on a payer’s card statement. Maximum length: 22.
/// Full requirements can be found in the API documentation for <a href="https://developer.paypal.com/docs/api/orders/v2/#definition-purchase_unit_request">purchase
/// unit</a>
@property (nonatomic, readonly, copy) NSString * _Nullable softDescriptor;
/// An array of items that the customer purchases from the merchant.
@property (nonatomic, readonly, copy) NSArray<PPCPurchaseUnitItem *> * _Nullable items;
/// The name and address of the person to whom to ship the items.
@property (nonatomic, readonly, strong) PPCPurchaseUnitShipping * _Nullable shipping;
- (nonnull instancetype)initWithAmount:(PPCPurchaseUnitAmount * _Nonnull)amount referenceId:(NSString * _Nullable)referenceId payee:(PPCPurchaseUnitPayee * _Nullable)payee paymentInstruction:(PPCPurchaseUnitPaymentInstruction * _Nullable)paymentInstruction purchaseUnitDescription:(NSString * _Nullable)purchaseUnitDescription customId:(NSString * _Nullable)customId invoiceId:(NSString * _Nullable)invoiceId softDescriptor:(NSString * _Nullable)softDescriptor items:(NSArray<PPCPurchaseUnitItem *> * _Nullable)items shipping:(PPCPurchaseUnitShipping * _Nullable)shipping OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@class PPCPurchaseUnitBreakdown;

/// The total order amount with an optional breakdown that provides details,
/// such as the total item amount, total tax amount, shipping, handling, insurance, and discounts, if any.
/// If you specify amount.breakdown, the amount equals item_total plus tax_total plus shipping plus handling plus
/// insurance minus shipping_discount minus discount. The amount must be a positive number.
SWIFT_CLASS_NAMED("Amount")
@interface PPCPurchaseUnitAmount : NSObject
/// The <a href="https://developer.paypal.com/docs/api/reference/currency-codes/">three-character ISO-4217 currency code</a>
/// that identifies the currency.
@property (nonatomic, readonly) enum PPCCurrencyCode currencyCode;
/// The value, which might be:
/// An integer for currencies like JPY that are not typically fractional.
/// A decimal fraction for currencies like TND that are subdivided into thousandths.
/// <ul>
///   <li>
///     Maximum length: 32.
///   </li>
///   <li>
///     Pattern: ^((-?[0-9]+)|(-?([0-9]+)?[.][0-9]+))$
///   </li>
/// </ul>
@property (nonatomic, readonly, copy) NSString * _Nonnull value;
/// The breakdown of the amount. Breakdown provides details such as total item amount,
/// total tax amount, shipping, handling, insurance, and discounts, if any.
@property (nonatomic, readonly, strong) PPCPurchaseUnitBreakdown * _Nullable breakdown;
- (nonnull instancetype)initWithCurrencyCode:(enum PPCCurrencyCode)currencyCode value:(NSString * _Nonnull)value breakdown:(PPCPurchaseUnitBreakdown * _Nullable)breakdown OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@class PPCUnitAmount;

/// The breakdown of the amount. Breakdown provides details such as total item amount,
/// total tax amount, shipping, handling, insurance, and discounts, if any.
SWIFT_CLASS_NAMED("Breakdown")
@interface PPCPurchaseUnitBreakdown : NSObject
/// The subtotal for all items. Required if the request includes <code>purchase_units[].items[].unit_amount</code>.
/// Must equal the sum of (<code>items[].unit_amount * items[].quantity</code>) for all items.
/// Can not be a negative number.
@property (nonatomic, readonly, strong) PPCUnitAmount * _Nullable itemTotal;
/// The shipping fee for all items within a given <code>PurchaseUnit</code>.
/// Can not be a negative number.
@property (nonatomic, readonly, strong) PPCUnitAmount * _Nullable shipping;
/// The handling fee for all items within a given <code>PurchaseUnit</code>.
/// Can not be a negative number.
@property (nonatomic, readonly, strong) PPCUnitAmount * _Nullable handling;
/// The total tax for all items. Required if the request includes <code>purchase_units.items.tax</code>.
/// Must equal the sum of (<code>items[].tax * items[].quantity</code>) for all items.
/// Can not be a negative number.
@property (nonatomic, readonly, strong) PPCUnitAmount * _Nullable taxTotal;
/// The insurance fee for all items within a given <code>PurchaseUnit</code>.
/// Can not be a negative number.
@property (nonatomic, readonly, strong) PPCUnitAmount * _Nullable insurance;
/// The shipping discount for all items within a given <code>PurchaseUnit</code>.
/// Can not be a negative number.
@property (nonatomic, readonly, strong) PPCUnitAmount * _Nullable shippingDiscount;
/// The discount for all items within a given <code>PurchaseUnit</code>.
/// Can not be a negative number.
@property (nonatomic, readonly, strong) PPCUnitAmount * _Nullable discount;
- (nonnull instancetype)initWithItemTotal:(PPCUnitAmount * _Nullable)itemTotal shipping:(PPCUnitAmount * _Nullable)shipping handling:(PPCUnitAmount * _Nullable)handling taxTotal:(PPCUnitAmount * _Nullable)taxTotal insurance:(PPCUnitAmount * _Nullable)insurance shippingDiscount:(PPCUnitAmount * _Nullable)shippingDiscount discount:(PPCUnitAmount * _Nullable)discount OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


/// The merchant who receives payment for this transaction.
SWIFT_CLASS_NAMED("Payee")
@interface PPCPurchaseUnitPayee : NSObject
/// The email address of merchant
@property (nonatomic, readonly, copy) NSString * _Nullable emailAddress;
/// The encrypted PayPal account ID of the merchant.
@property (nonatomic, readonly, copy) NSString * _Nullable merchantId;
- (nonnull instancetype)initWithEmailAddress:(NSString * _Nullable)emailAddress merchantId:(NSString * _Nullable)merchantId OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@class PPCPurchaseUnitPlatformFees;
enum PPCPurchaseUnitDisbursementMode : NSInteger;

/// Any additional payment instructions for PayPal Commerce Platform customers.
/// Enables features for the PayPal Commerce Platform, such as delayed disbursement and collection of a platform fee.
/// Applies during order creation for captured payments or during capture of authorized payments.
SWIFT_CLASS_NAMED("PaymentInstruction")
@interface PPCPurchaseUnitPaymentInstruction : NSObject
/// An array of various fees, commissions, tips, or donations.
@property (nonatomic, readonly, copy) NSArray<PPCPurchaseUnitPlatformFees *> * _Nullable platformFees;
/// The funds that are held on behalf of the merchant.
@property (nonatomic, readonly) enum PPCPurchaseUnitDisbursementMode disbursementMode;
- (nonnull instancetype)initWithPlatformFees:(NSArray<PPCPurchaseUnitPlatformFees *> * _Nullable)platformFees disbursementMode:(enum PPCPurchaseUnitDisbursementMode)disbursementMode OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


/// An array of various fees, commissions, tips, or donations.
SWIFT_CLASS_NAMED("PlatformFees")
@interface PPCPurchaseUnitPlatformFees : NSObject
/// The fee for this transaction
@property (nonatomic, readonly, strong) PPCPurchaseUnitAmount * _Nonnull amount;
/// The recipient of the fee for this transaction. If you omit this value, the default is the API caller.
@property (nonatomic, readonly, strong) PPCPurchaseUnitPayee * _Nullable payee;
- (nonnull instancetype)initWithAmount:(PPCPurchaseUnitAmount * _Nonnull)amount payee:(PPCPurchaseUnitPayee * _Nullable)payee OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// The funds that are held on behalf of the merchant.
typedef SWIFT_ENUM_NAMED(NSInteger, PPCPurchaseUnitDisbursementMode, "DisbursementMode", open) {
  PPCPurchaseUnitDisbursementModeNone = 0,
/// The funds are released to the merchant immediately.
  PPCPurchaseUnitDisbursementModeInstant = 1,
/// The funds are held for a finite number of days. The actual duration depends
/// on the region and type of integration. You can release the funds through a referenced
/// payout. Otherwise, the funds disbursed automatically after the specified duration.
  PPCPurchaseUnitDisbursementModeDelayed = 2,
};

@class PPCPurchaseUnitTax;
enum PPCPurchaseUnitCategory : NSInteger;

/// An array of items that the customer purchases from the merchant.
SWIFT_CLASS_NAMED("Item")
@interface PPCPurchaseUnitItem : NSObject
/// The item name or title. Minumum length: 1. Maximum length: 127
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
/// The item price or rate per unit. If you specify <code>unitAmount</code>, <code>purchase_units[].amount.breakdown.item_total</code>
/// is required. Must equal <code>unitAmount * quantity</code> for all items.
/// <code>unitAmount.value</code> can not be a negative number.
@property (nonatomic, readonly, strong) PPCUnitAmount * _Nonnull unitAmount;
/// The item tax for each unit. If tax is specified, <code>purchase_units[].amount.breakdown.tax_total</code> is required.
/// Must equal <code>tax * quantity</code> for all items. <code>tax.value</code> can not be a negative number.
@property (nonatomic, readonly, strong) PPCPurchaseUnitTax * _Nullable tax;
/// The item quantity. Must be a whole number. Maximum length: 10. Pattern: ^[1-9][0-9]{0,9}$.
@property (nonatomic, readonly, copy) NSString * _Nonnull quantity;
/// The detailed item description. Maximum length: 127.
@property (nonatomic, readonly, copy) NSString * _Nullable itemDescription;
/// The stock keeping unit (SKU) for the item. Maximum length: 127.
@property (nonatomic, readonly, copy) NSString * _Nullable sku;
/// The item category type.
@property (nonatomic, readonly) enum PPCPurchaseUnitCategory category;
- (nonnull instancetype)initWithName:(NSString * _Nonnull)name unitAmount:(PPCUnitAmount * _Nonnull)unitAmount quantity:(NSString * _Nonnull)quantity tax:(PPCPurchaseUnitTax * _Nullable)tax itemDescription:(NSString * _Nullable)itemDescription sku:(NSString * _Nullable)sku category:(enum PPCPurchaseUnitCategory)category OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


/// The item tax for each unit. If tax is specified, <code>purchase_units[].amount.breakdown.tax_total</code> is required.
/// Must equal <code>tax * quantity</code> for all items. <code>tax.value</code> can not be a negative number.
SWIFT_CLASS_NAMED("Tax")
@interface PPCPurchaseUnitTax : NSObject
/// The currency code that identifies the currency.
@property (nonatomic, readonly) enum PPCCurrencyCode currencyCode;
/// The value, which might be:
/// An integer for currencies like JPY that are not typically fractional.
/// A decimal fraction for currencies like TND that are subdivided into thousandths.
/// <ul>
///   <li>
///     Maximum length: 32.
///   </li>
///   <li>
///     Pattern: ^((-?[0-9]+)|(-?([0-9]+)?[.][0-9]+))$
///   </li>
/// </ul>
@property (nonatomic, readonly, copy) NSString * _Nonnull value;
- (nonnull instancetype)initWithCurrencyCode:(enum PPCCurrencyCode)currencyCode value:(NSString * _Nonnull)value OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// The item category type.
typedef SWIFT_ENUM_NAMED(NSInteger, PPCPurchaseUnitCategory, "Category", open) {
  PPCPurchaseUnitCategoryNone = 0,
/// Goods that are stored, delivered, and used in their electronic format.
/// This value is not currently supported for API callers that leverage the <a href="https://www.paypal.com/us/webapps/mpp/commerce-platform">PayPal for Commerce
/// Platform</a> product.
  PPCPurchaseUnitCategoryDigitalGoods = 1,
/// A tangible item that can be shipped with proof of delivery.
  PPCPurchaseUnitCategoryPhysicalGoods = 2,
};


/// The name and address of the person to whom to ship the items.
SWIFT_CLASS_NAMED("Shipping")
@interface PPCPurchaseUnitShipping : NSObject
/// The name of the person to whom to ship the items. Supports only the <code>full_name</code> property.
@property (nonatomic, readonly, strong) PPCPurchaseUnitShippingName * _Nullable shippingName;
/// The address of the person to whom to ship the items.
/// Supports only the <code>address_line_1</code>, <code>address_line_2</code>, <code>admin_area_1</code>, <code>admin_area_2</code>,
/// <code>postal_code</code>, and <code>country_code</code> properties.
@property (nonatomic, readonly, strong) PPCOrderAddress * _Nullable address;
/// All available shipping options for an order
@property (nonatomic, readonly, copy) NSArray<PPCShippingMethod *> * _Nullable options;
- (nonnull instancetype)initWithShippingName:(PPCPurchaseUnitShippingName * _Nullable)shippingName address:(PPCOrderAddress * _Nullable)address options:(NSArray<PPCShippingMethod *> * _Nullable)options OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


/// The name of the person to whom to ship the items. Supports only the <code>full_name</code> property.
SWIFT_CLASS_NAMED("ShippingName")
@interface PPCPurchaseUnitShippingName : NSObject
/// When the party is a person, the party’s full name.
/// Maximum length: 300.
@property (nonatomic, readonly, copy) NSString * _Nullable fullName;
- (nonnull instancetype)initWithFullName:(NSString * _Nullable)fullName OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


SWIFT_CLASS("_TtC14PayPalCheckout14RateChangeView")
@interface RateChangeView : UIView
- (nonnull instancetype)initWithFrame:(CGRect)frame SWIFT_UNAVAILABLE;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)aDecoder SWIFT_UNAVAILABLE;
@end


/// Unique identifiers for an SDK session/checkout session
SWIFT_CLASS_NAMED("SessionIdentifiers")
@interface PPCSessionIDs : NSObject
/// A unique identifier for a session of the SDK
@property (nonatomic, copy) NSString * _Nullable sdkSessionID;
/// A unique identifier for a single checkout session
@property (nonatomic, copy) NSString * _Nullable orderSessionID;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

enum PPCShippingChangeType : NSInteger;
@class PPCShippingChangeAddress;

SWIFT_CLASS_NAMED("ShippingChange")
@interface PPCShippingChange : NSObject
/// An enum indicating whether the buyer has selected a new shipping address or shipping method
@property (nonatomic, readonly) enum PPCShippingChangeType type;
/// The current selected shipping address
@property (nonatomic, readonly, strong) PPCShippingChangeAddress * _Nonnull selectedShippingAddress;
/// The list of available shipping methods
@property (nonatomic, readonly, copy) NSArray<PPCShippingMethod *> * _Nonnull shippingMethods;
/// The current selected shipping method
@property (nonatomic, readonly, strong) PPCShippingMethod * _Nullable selectedShippingMethod;
@property (nonatomic, readonly, copy) NSString * _Nonnull payToken;
@property (nonatomic, readonly, copy) NSString * _Nullable paymentID;
@property (nonatomic, readonly, copy) NSString * _Nullable billingToken;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


SWIFT_CLASS_NAMED("ShippingChangeAction")
@interface PPCShippingChangeAction : NSObject
/// Makes a request to the PayPal API to update an order.
/// note:
///
/// <ul>
///   <li>
///     Only compatible with orders generated by the PayPal <code>v2</code> API that are one time payment transactions.
///   </li>
///   <li>
///     Can only be applied to orders with the <code>CREATED</code> or <code>APPROVED</code> status.
///     You cannot update an order with the <code>COMPLETED</code> status.
///   </li>
///   <li>
///     You will need to handle any errors vended on the order request as part of the patch function.
///   </li>
///   <li>
///     You do not need to invoke <code>approve()</code> or <code>rejected()</code> when patching an order.
///     These actions will be updated based on the result of the patch request by the SDK.
///   </li>
/// </ul>
/// \param request The request to update the order with.
/// <ul>
///   <li>
///     Currently supports the following:
///     <ul>
///       <li>
///         <code>shippingName</code> - add, replace
///       </li>
///       <li>
///         <code>shippingAddress</code> - add, replace
///       </li>
///       <li>
///         <code>shippingOptions</code> - add, replace
///       </li>
///       <li>
///         <code>amount</code> - replace
///       </li>
///     </ul>
///   </li>
/// </ul>
///
/// \param onComplete Closure invoked when the patch request has resolved.
/// Asynchronously vends either a <code>PatchActionSuccess</code> or an <code>Error</code> object.
///
- (void)patchWithRequest:(PPCPatchRequest * _Nonnull)request onComplete:(void (^ _Nonnull)(PPCPatchActionSuccess * _Nullable, NSError * _Nullable))onComplete;
/// This should only be used if not using the ‘patch’ function to update your order.
/// If you are using the <code>reject</code> action you will need to resolve to <code>approve</code>
/// in cases where you want to remove the error message.
/// This will be set automatically if using the patch order request.
- (void)approve;
/// Makes a request to the SDK to refresh the UI with an error message.
/// This should be used in cases where you want to display an error message
/// under the shipping address and redirect the user to select another address
/// before continuing the checkout flow. This will be set automatically if using
/// the patch order request.
- (void)reject;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


SWIFT_CLASS_NAMED("ShippingChangeAddress")
@interface PPCShippingChangeAddress : NSObject
/// The ID of the shipping address
@property (nonatomic, readonly, copy) NSString * _Nullable addressID;
/// The highest level sub-division in a country, which is usually a province, state, or ISO-3166-2 subdivision.
/// Format for postal delivery. For example, <code>CA</code> and not <code>California</code>. Value, by country, is:
/// <ul>
///   <li>
///     UK: A county.
///   </li>
///   <li>
///     US: A state.
///   </li>
///   <li>
///     Canada: A province.
///   </li>
///   <li>
///     Japan: A prefecture.
///   </li>
///   <li>
///     Switzerland: A kanton.
///   </li>
/// </ul>
@property (nonatomic, readonly, copy) NSString * _Nullable adminArea1;
/// The city, town, or village. Smaller than <code>adminArea1</code>.
@property (nonatomic, readonly, copy) NSString * _Nullable adminArea2;
/// The postal code, which is the zip code or equivalent. Typically required for countries with a postal code or an equivalent.
@property (nonatomic, readonly, copy) NSString * _Nullable postalCode;
/// The two-character ISO 3166-1 code that identifies the country or region.
/// For more information, refer to: https://developer.paypal.com/api/rest/reference/country-codes/
@property (nonatomic, readonly, copy) NSString * _Nullable countryCode;
@property (nonatomic, readonly, copy) NSString * _Nullable city SWIFT_DEPRECATED_MSG("", "adminArea2");
@property (nonatomic, readonly, copy) NSString * _Nullable state SWIFT_DEPRECATED_MSG("", "adminArea1");
@property (nonatomic, readonly, copy) NSString * _Nullable country SWIFT_DEPRECATED_MSG("", "countryCode");
- (nonnull instancetype)initWithAddressID:(NSString * _Nullable)addressID adminArea1:(NSString * _Nullable)adminArea1 adminArea2:(NSString * _Nullable)adminArea2 postalCode:(NSString * _Nullable)postalCode countryCode:(NSString * _Nullable)countryCode OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)initWithAddressID:(NSString * _Nullable)addressID fullName:(NSString * _Nullable)fullName city:(NSString * _Nullable)city state:(NSString * _Nullable)state postalCode:(NSString * _Nullable)postalCode country:(NSString * _Nullable)country OBJC_DESIGNATED_INITIALIZER SWIFT_DEPRECATED_MSG("", "initWithAddressID:adminArea1:adminArea2:postalCode:countryCode:");
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// This class is responsible for letting our SDK know about the state of shipping changes.
typedef SWIFT_ENUM_NAMED(NSInteger, PPCShippingChangeState, "ShippingChangeState", open) {
/// The shipping callback is currently processing the change.
  PPCShippingChangeStateProcessing = 0,
/// The shipping change was approved.
  PPCShippingChangeStateApproved = 1,
/// The shipping change had an error.
  PPCShippingChangeStateError = 2,
/// The shipping callback has not been called
/// note:
/// This is the default case before the state is set in the callback.
  PPCShippingChangeStateUndetermined = 3,
};

/// The type of shipping change.
typedef SWIFT_ENUM_NAMED(NSInteger, PPCShippingChangeType, "ShippingChangeType", open) {
/// The buyer has selected a new shipping address
  PPCShippingChangeTypeShippingAddress = 0,
/// The buyer has selected a new shipping method
  PPCShippingChangeTypeShippingMethod = 1,
};

enum PPCShippingType : NSInteger;

/// Shipping option for an order used when creating an order with Orders API.
/// If you want to show your shipping options in our Paysheet,
/// you should provide <code>purchaseUnits[].shipping.options</code>,
/// otherwise, our Paysheet won’t display any shipping options.
SWIFT_CLASS_NAMED("ShippingMethod")
@interface PPCShippingMethod : NSObject
/// A unique ID that identifies a payer-selected shipping option.
@property (nonatomic, readonly, copy) NSString * _Nonnull id;
/// A description that the payer sees, which helps them choose an appropriate shipping option.
/// For example, Free Shipping, USPS Priority Shipping, Expédition prioritaire USPS, or USPS yōuxiān fā huò.
/// Localize this description to the payer’s locale.
@property (nonatomic, readonly, copy) NSString * _Nonnull label;
/// If true it represents the shipping option that the merchant expects to be selected for the buyer
/// when they view the shipping options within the PayPal Checkout experience.
/// The selected shipping option must match the shipping cost in the order breakdown.
/// Only one shipping option per purchase unit can be selected.
@property (nonatomic, readonly) BOOL selected;
/// The method by which the payer wants to get their items.
@property (nonatomic, readonly) enum PPCShippingType type;
/// The shipping cost for the selected option.
@property (nonatomic, readonly, strong) PPCUnitAmount * _Nullable amount;
- (nonnull instancetype)initWithId:(NSString * _Nonnull)id label:(NSString * _Nonnull)label selected:(BOOL)selected type:(enum PPCShippingType)type amount:(PPCUnitAmount * _Nullable)amount OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// The method by which the payer wants to get their items.
typedef SWIFT_ENUM_NAMED(NSInteger, PPCShippingType, "ShippingType", open) {
/// The payer intends to receive the items at a specified address.
  PPCShippingTypeShipping = 0,
/// The payer intends to pick up the items at a specified address. For example, a store address.
  PPCShippingTypePickup = 1,
  PPCShippingTypeNone = 2,
};


SWIFT_CLASS("_TtC14PayPalCheckout12ShippingView")
@interface ShippingView : UIView
- (nonnull instancetype)initWithFrame:(CGRect)frame SWIFT_UNAVAILABLE;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)aDecoder SWIFT_UNAVAILABLE;
@end

@class UICollectionViewLayout;

SWIFT_CLASS("_TtC14PayPalCheckout15SuggestionsView")
@interface SuggestionsView : UIView <UICollectionViewDelegateFlowLayout>
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)coder SWIFT_UNAVAILABLE;
- (void)layoutSubviews;
- (CGSize)collectionView:(UICollectionView * _Nonnull)collectionView layout:(UICollectionViewLayout * _Nonnull)collectionViewLayout sizeForItemAtIndexPath:(NSIndexPath * _Nonnull)indexPath SWIFT_WARN_UNUSED_RESULT;
- (CGSize)collectionView:(UICollectionView * _Nonnull)collectionView layout:(UICollectionViewLayout * _Nonnull)collectionViewLayout referenceSizeForFooterInSection:(NSInteger)section SWIFT_WARN_UNUSED_RESULT;
- (void)collectionView:(UICollectionView * _Nonnull)collectionView didSelectItemAtIndexPath:(NSIndexPath * _Nonnull)indexPath;
- (nonnull instancetype)initWithFrame:(CGRect)frame SWIFT_UNAVAILABLE;
@end


SWIFT_CLASS("_TtC14PayPalCheckout15TransitionLabel")
@interface TransitionLabel : UILabel
- (nonnull instancetype)initWithFrame:(CGRect)frame OBJC_DESIGNATED_INITIALIZER;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)coder OBJC_DESIGNATED_INITIALIZER SWIFT_UNAVAILABLE;
@end




























SWIFT_CLASS("_TtC14PayPalCheckout22UnconstrainedTextLabel")
@interface UnconstrainedTextLabel : UILabel
- (nonnull instancetype)initWithFrame:(CGRect)frame OBJC_DESIGNATED_INITIALIZER;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)coder OBJC_DESIGNATED_INITIALIZER;
@end


/// UnitAmount should be used for the following objects:
/// <ul>
///   <li>
///     all breakdown.amount objects - https://developer.paypal.com/docs/api/orders/v2#definition-amount_breakdown
///   </li>
///   <li>
///     item.unitAmount - https://developer.paypal.com/docs/api/orders/v2#definition-item
///   </li>
///   <li>
///     shipping.options.amount - https://developer.paypal.com/docs/api/orders/v2/#definition-shipping_detail
///   </li>
/// </ul>
SWIFT_CLASS_NAMED("UnitAmount")
@interface PPCUnitAmount : NSObject
/// The value, which might be:
/// An integer for currencies like JPY that are not typically fractional.
/// A decimal fraction for currencies like TND that are subdivided into thousandths.
/// <ul>
///   <li>
///     Maximum length: 32.
///   </li>
///   <li>
///     Pattern: ^((-?[0-9]+)|(-?([0-9]+)?[.][0-9]+))$
///   </li>
/// </ul>
@property (nonatomic, readonly, copy) NSString * _Nullable value;
/// Currency code in text format (example: “USD”)
@property (nonatomic, readonly, copy) NSString * _Nullable currencyCodeString;
/// Formatted currency symbol and value (example: “$0.01”)
@property (nonatomic, readonly, copy) NSString * _Nullable currencyFormat;
/// \param currencyCode The currency code that identifies the currency
///
/// \param value The value
///
- (nonnull instancetype)initWithCurrencyCode:(enum PPCCurrencyCode)currencyCode value:(NSString * _Nonnull)value OBJC_DESIGNATED_INITIALIZER;
- (BOOL)isEqual:(id _Nullable)object SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

typedef SWIFT_ENUM_NAMED(NSInteger, PPCUserAction, "UserAction", open) {
/// Does not correspond with any user action value. Necessary for Objective-C exposure.
  PPCUserActionDefault = 0,
/// Corresponds with a <code>continue</code> button
  PPCUserActionContinue = 1,
/// Corresponds with a <code>Pay Now</code> button.
/// Also associated with the query parameter value of <code>userAction=commit</code>
  PPCUserActionPayNow = 2,
};



/// Data describing an approved vault flow
SWIFT_CLASS_NAMED("VaultData")
@interface PPCVaultData : NSObject
/// Unique identifier representing a vault approval session.
@property (nonatomic, readonly, copy) NSString * _Nonnull approvalSessionID;
/// The temporary PayPal-generated ID of an approval token. This token will have a lifespan of 3 hours.
/// Once approved, use the <a href="https://developer.paypal.com/api/limited-release/payment-tokens/v2/#approval-tokens_confirm-payment-token">/confirm-payment-token API</a>
/// with this token to create a Payment Token that can be used for payments.
@property (nonatomic, readonly, copy) NSString * _Nonnull approvalTokenID;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

#endif
#if defined(__cplusplus)
#endif
#if __has_attribute(external_source_symbol)
# pragma clang attribute pop
#endif
#pragma clang diagnostic pop
#endif

#elif defined(__x86_64__) && __x86_64__
// Generated by Apple Swift version 5.7.1 (swiftlang-5.7.1.135.3 clang-1400.0.29.51)
#ifndef PAYPALCHECKOUT_SWIFT_H
#define PAYPALCHECKOUT_SWIFT_H
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wgcc-compat"

#if !defined(__has_include)
# define __has_include(x) 0
#endif
#if !defined(__has_attribute)
# define __has_attribute(x) 0
#endif
#if !defined(__has_feature)
# define __has_feature(x) 0
#endif
#if !defined(__has_warning)
# define __has_warning(x) 0
#endif

#if __has_include(<swift/objc-prologue.h>)
# include <swift/objc-prologue.h>
#endif

#pragma clang diagnostic ignored "-Wduplicate-method-match"
#pragma clang diagnostic ignored "-Wauto-import"
#if defined(__OBJC__)
#include <Foundation/Foundation.h>
#endif
#if defined(__cplusplus)
#include <cstdint>
#include <cstddef>
#include <cstdbool>
#else
#include <stdint.h>
#include <stddef.h>
#include <stdbool.h>
#endif

#if !defined(SWIFT_TYPEDEFS)
# define SWIFT_TYPEDEFS 1
# if __has_include(<uchar.h>)
#  include <uchar.h>
# elif !defined(__cplusplus)
typedef uint_least16_t char16_t;
typedef uint_least32_t char32_t;
# endif
typedef float swift_float2  __attribute__((__ext_vector_type__(2)));
typedef float swift_float3  __attribute__((__ext_vector_type__(3)));
typedef float swift_float4  __attribute__((__ext_vector_type__(4)));
typedef double swift_double2  __attribute__((__ext_vector_type__(2)));
typedef double swift_double3  __attribute__((__ext_vector_type__(3)));
typedef double swift_double4  __attribute__((__ext_vector_type__(4)));
typedef int swift_int2  __attribute__((__ext_vector_type__(2)));
typedef int swift_int3  __attribute__((__ext_vector_type__(3)));
typedef int swift_int4  __attribute__((__ext_vector_type__(4)));
typedef unsigned int swift_uint2  __attribute__((__ext_vector_type__(2)));
typedef unsigned int swift_uint3  __attribute__((__ext_vector_type__(3)));
typedef unsigned int swift_uint4  __attribute__((__ext_vector_type__(4)));
#endif

#if !defined(SWIFT_PASTE)
# define SWIFT_PASTE_HELPER(x, y) x##y
# define SWIFT_PASTE(x, y) SWIFT_PASTE_HELPER(x, y)
#endif
#if !defined(SWIFT_METATYPE)
# define SWIFT_METATYPE(X) Class
#endif
#if !defined(SWIFT_CLASS_PROPERTY)
# if __has_feature(objc_class_property)
#  define SWIFT_CLASS_PROPERTY(...) __VA_ARGS__
# else
#  define SWIFT_CLASS_PROPERTY(...)
# endif
#endif

#if __has_attribute(objc_runtime_name)
# define SWIFT_RUNTIME_NAME(X) __attribute__((objc_runtime_name(X)))
#else
# define SWIFT_RUNTIME_NAME(X)
#endif
#if __has_attribute(swift_name)
# define SWIFT_COMPILE_NAME(X) __attribute__((swift_name(X)))
#else
# define SWIFT_COMPILE_NAME(X)
#endif
#if __has_attribute(objc_method_family)
# define SWIFT_METHOD_FAMILY(X) __attribute__((objc_method_family(X)))
#else
# define SWIFT_METHOD_FAMILY(X)
#endif
#if __has_attribute(noescape)
# define SWIFT_NOESCAPE __attribute__((noescape))
#else
# define SWIFT_NOESCAPE
#endif
#if __has_attribute(ns_consumed)
# define SWIFT_RELEASES_ARGUMENT __attribute__((ns_consumed))
#else
# define SWIFT_RELEASES_ARGUMENT
#endif
#if __has_attribute(warn_unused_result)
# define SWIFT_WARN_UNUSED_RESULT __attribute__((warn_unused_result))
#else
# define SWIFT_WARN_UNUSED_RESULT
#endif
#if __has_attribute(noreturn)
# define SWIFT_NORETURN __attribute__((noreturn))
#else
# define SWIFT_NORETURN
#endif
#if !defined(SWIFT_CLASS_EXTRA)
# define SWIFT_CLASS_EXTRA
#endif
#if !defined(SWIFT_PROTOCOL_EXTRA)
# define SWIFT_PROTOCOL_EXTRA
#endif
#if !defined(SWIFT_ENUM_EXTRA)
# define SWIFT_ENUM_EXTRA
#endif
#if !defined(SWIFT_CLASS)
# if __has_attribute(objc_subclassing_restricted)
#  define SWIFT_CLASS(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) __attribute__((objc_subclassing_restricted)) SWIFT_CLASS_EXTRA
#  define SWIFT_CLASS_NAMED(SWIFT_NAME) __attribute__((objc_subclassing_restricted)) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
# else
#  define SWIFT_CLASS(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
#  define SWIFT_CLASS_NAMED(SWIFT_NAME) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
# endif
#endif
#if !defined(SWIFT_RESILIENT_CLASS)
# if __has_attribute(objc_class_stub)
#  define SWIFT_RESILIENT_CLASS(SWIFT_NAME) SWIFT_CLASS(SWIFT_NAME) __attribute__((objc_class_stub))
#  define SWIFT_RESILIENT_CLASS_NAMED(SWIFT_NAME) __attribute__((objc_class_stub)) SWIFT_CLASS_NAMED(SWIFT_NAME)
# else
#  define SWIFT_RESILIENT_CLASS(SWIFT_NAME) SWIFT_CLASS(SWIFT_NAME)
#  define SWIFT_RESILIENT_CLASS_NAMED(SWIFT_NAME) SWIFT_CLASS_NAMED(SWIFT_NAME)
# endif
#endif

#if !defined(SWIFT_PROTOCOL)
# define SWIFT_PROTOCOL(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) SWIFT_PROTOCOL_EXTRA
# define SWIFT_PROTOCOL_NAMED(SWIFT_NAME) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_PROTOCOL_EXTRA
#endif

#if !defined(SWIFT_EXTENSION)
# define SWIFT_EXTENSION(M) SWIFT_PASTE(M##_Swift_, __LINE__)
#endif

#if !defined(OBJC_DESIGNATED_INITIALIZER)
# if __has_attribute(objc_designated_initializer)
#  define OBJC_DESIGNATED_INITIALIZER __attribute__((objc_designated_initializer))
# else
#  define OBJC_DESIGNATED_INITIALIZER
# endif
#endif
#if !defined(SWIFT_ENUM_ATTR)
# if defined(__has_attribute) && __has_attribute(enum_extensibility)
#  define SWIFT_ENUM_ATTR(_extensibility) __attribute__((enum_extensibility(_extensibility)))
# else
#  define SWIFT_ENUM_ATTR(_extensibility)
# endif
#endif
#if !defined(SWIFT_ENUM)
# define SWIFT_ENUM(_type, _name, _extensibility) enum _name : _type _name; enum SWIFT_ENUM_ATTR(_extensibility) SWIFT_ENUM_EXTRA _name : _type
# if __has_feature(generalized_swift_name)
#  define SWIFT_ENUM_NAMED(_type, _name, SWIFT_NAME, _extensibility) enum _name : _type _name SWIFT_COMPILE_NAME(SWIFT_NAME); enum SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_ENUM_ATTR(_extensibility) SWIFT_ENUM_EXTRA _name : _type
# else
#  define SWIFT_ENUM_NAMED(_type, _name, SWIFT_NAME, _extensibility) SWIFT_ENUM(_type, _name, _extensibility)
# endif
#endif
#if !defined(SWIFT_UNAVAILABLE)
# define SWIFT_UNAVAILABLE __attribute__((unavailable))
#endif
#if !defined(SWIFT_UNAVAILABLE_MSG)
# define SWIFT_UNAVAILABLE_MSG(msg) __attribute__((unavailable(msg)))
#endif
#if !defined(SWIFT_AVAILABILITY)
# define SWIFT_AVAILABILITY(plat, ...) __attribute__((availability(plat, __VA_ARGS__)))
#endif
#if !defined(SWIFT_WEAK_IMPORT)
# define SWIFT_WEAK_IMPORT __attribute__((weak_import))
#endif
#if !defined(SWIFT_DEPRECATED)
# define SWIFT_DEPRECATED __attribute__((deprecated))
#endif
#if !defined(SWIFT_DEPRECATED_MSG)
# define SWIFT_DEPRECATED_MSG(...) __attribute__((deprecated(__VA_ARGS__)))
#endif
#if __has_feature(attribute_diagnose_if_objc)
# define SWIFT_DEPRECATED_OBJC(Msg) __attribute__((diagnose_if(1, Msg, "warning")))
#else
# define SWIFT_DEPRECATED_OBJC(Msg) SWIFT_DEPRECATED_MSG(Msg)
#endif
#if defined(__OBJC__)
#if !defined(IBSegueAction)
# define IBSegueAction
#endif
#endif
#if !defined(SWIFT_EXTERN)
# if defined(__cplusplus)
#  define SWIFT_EXTERN extern "C"
# else
#  define SWIFT_EXTERN extern
# endif
#endif
#if !defined(SWIFT_CALL)
# define SWIFT_CALL __attribute__((swiftcall))
#endif
#if defined(__cplusplus)
#if !defined(SWIFT_NOEXCEPT)
# define SWIFT_NOEXCEPT noexcept
#endif
#else
#if !defined(SWIFT_NOEXCEPT)
# define SWIFT_NOEXCEPT 
#endif
#endif
#if defined(__cplusplus)
#if !defined(SWIFT_CXX_INT_DEFINED)
#define SWIFT_CXX_INT_DEFINED
namespace swift {
using Int = ptrdiff_t;
using UInt = size_t;
}
#endif
#endif
#if defined(__OBJC__)
#if __has_feature(modules)
#if __has_warning("-Watimport-in-framework-header")
#pragma clang diagnostic ignored "-Watimport-in-framework-header"
#endif
@import CoreFoundation;
@import Foundation;
@import ObjectiveC;
@import UIKit;
#endif

#endif
#pragma clang diagnostic ignored "-Wproperty-attribute-mismatch"
#pragma clang diagnostic ignored "-Wduplicate-method-arg"
#if __has_warning("-Wpragma-clang-attribute")
# pragma clang diagnostic ignored "-Wpragma-clang-attribute"
#endif
#pragma clang diagnostic ignored "-Wunknown-pragmas"
#pragma clang diagnostic ignored "-Wnullability"
#pragma clang diagnostic ignored "-Wdollar-in-identifier-extension"

#if __has_attribute(external_source_symbol)
# pragma push_macro("any")
# undef any
# pragma clang attribute push(__attribute__((external_source_symbol(language="Swift", defined_in="PayPalCheckout",generated_declaration))), apply_to=any(function,enum,objc_interface,objc_category,objc_protocol))
# pragma pop_macro("any")
#endif

#if defined(__OBJC__)
@class NSCoder;

SWIFT_CLASS("_TtC14PayPalCheckout24AccessibilityCloseButton")
@interface AccessibilityCloseButton : UIView
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)coder SWIFT_UNAVAILABLE;
- (nonnull instancetype)initWithFrame:(CGRect)frame SWIFT_UNAVAILABLE;
@end


SWIFT_CLASS("_TtC14PayPalCheckout10AmountView")
@interface AmountView : UIView
- (nonnull instancetype)initWithFrame:(CGRect)frame SWIFT_UNAVAILABLE;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)aDecoder SWIFT_UNAVAILABLE;
@end

@class PPCApprovalData;
@class PPCApprovalActions;

/// Encapsulates metadata after <code>CheckoutConfig.onApprove</code> is called.
/// This meta information can be utilized to properly capture an order.
SWIFT_CLASS_NAMED("Approval")
@interface PPCApproval : NSObject
/// Data associated with the approved payment
@property (nonatomic, readonly, strong) PPCApprovalData * _Nonnull data;
/// Actions to handle capturing or authorizing an approved payment.
/// These could be used in place of server side functions to do the same.
@property (nonatomic, readonly, strong) PPCApprovalActions * _Nonnull actions;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@class PPCCaptureActionSuccess;
@class PPCAuthorizeActionSuccess;
@class PPCPatchRequest;
@class PPCPatchActionSuccess;
@class PPCBillingActionData;
@class PPCOrderDetails;

/// Provides an interface to make common order requests from within the PayPal Checkout SDK.
SWIFT_CLASS_NAMED("ApprovalActions")
@interface PPCApprovalActions : NSObject
/// Makes a request to the PayPal API to capture the approved payment.
/// Uses the approval data to
/// <ul>
///   <li>
///     Generate a low scoped access token
///   </li>
///   <li>
///     Upgrade the access token in order to capture the payment
///   </li>
///   <li>
///     Make a request to capture the approved payment
///   </li>
/// </ul>
/// More information can be found in the API documentation:
/// <a href="https://developer.paypal.com/docs/api/orders/v2/#orders_capture">Capture Documentation</a>
/// note:
///
/// <ul>
///   <li>
///     Should only be invoked on transactions with an <code>intent</code> value of <code>CAPTURE</code>.
///   </li>
///   <li>
///     Only compatible with pay tokens generated by the PayPal <code>v2</code> API
///   </li>
/// </ul>
/// \param onComplete Asynchronously vends either a <code>CaptureActionSuccess</code> or an <code>Error</code> object.
///
- (void)captureOnComplete:(void (^ _Nonnull)(PPCCaptureActionSuccess * _Nullable, NSError * _Nullable))onComplete;
/// Makes a request to the PayPal API to authorize the approved payment.
/// Uses the approval data to
/// <ul>
///   <li>
///     Generate a low scoped access token
///   </li>
///   <li>
///     Upgrade the access token in order to authorize the payment
///   </li>
///   <li>
///     Make a request to authorize the payment
///   </li>
/// </ul>
/// More information can be found in the API documentation:
/// <a href="https://developer.paypal.com/docs/api/orders/v2/#orders_authorize">Authorization Documentation</a>
/// note:
///
/// <ul>
///   <li>
///     Should only be invoked on transactions with an <code>intent</code> value of <code>AUTHORIZE</code>.
///   </li>
///   <li>
///     Only compatible with pay tokens generated by the PayPal <code>v2</code> API
///   </li>
/// </ul>
/// \param onComplete Asynchronously vends either an <code>AuthorizationActionSuccess</code> or an <code>Error</code> object.
///
- (void)authorizeOnComplete:(void (^ _Nonnull)(PPCAuthorizeActionSuccess * _Nullable, NSError * _Nullable))onComplete;
/// Makes a request to the PayPal API to update an order.
/// note:
///
/// <ul>
///   <li>
///     Only compatible with pay tokens generated by the PayPal <code>v2</code> API.
///   </li>
///   <li>
///     Can only be applied to orders with the <code>CREATED</code> or <code>APPROVED</code> status.
///     You cannot update an order with the <code>COMPLETED</code> status.
///   </li>
///   <li>
///     You will need to handle any errors vended on the order request as part of the patch function.
///   </li>
/// </ul>
/// \param request The request(s) to update the order with.
/// <ul>
///   <li>
///     Currently only supports the following:
///     <ul>
///       <li>
///         <code>shippingName</code> - add, replace
///       </li>
///       <li>
///         <code>shippingAddress</code> - add, replace
///       </li>
///       <li>
///         <code>shippingOptions</code> - add, replace
///       </li>
///       <li>
///         <code>amount</code> - replace
///       </li>
///     </ul>
///   </li>
/// </ul>
///
/// \param onComplete Closure invoked when the patch request has resolved.
/// Asynchronously vends either a <code>PatchActionSuccess</code> or an <code>Error</code> object.
///
- (void)patchWithRequest:(PPCPatchRequest * _Nonnull)request onComplete:(void (^ _Nonnull)(PPCPatchActionSuccess * _Nullable, NSError * _Nullable))onComplete;
/// Execute the <code>billingToken</code> to create a billing agreement and get a Billing-ID to be used for subsequent transactions.
/// Uses the approval data to
/// note:
///
/// <ul>
///   <li>
///     Should only be invoked on billing agreement transactions with a <code>billingToken</code> in the <code>ApprovalData</code>.
///   </li>
///   <li>
///     Only compatible with billing token generated by the PayPal Billing Agreements <code>v1</code> API
///   </li>
/// </ul>
/// <ul>
///   <li>
///     Generate a low scoped access token
///   </li>
///   <li>
///     Make a request to execute the billing agreement to obtain a Billing-ID
///   </li>
/// </ul>
/// \param onComplete Asynchronously vends either a <code>BillingActionData</code> or an <code>Error</code> object.
///
- (void)executeBillingAgreementOnComplete:(void (^ _Nonnull)(PPCBillingActionData * _Nullable, NSError * _Nullable))onComplete;
/// Get the details for an Order previously approved by the buyer. This function makes REST request to the <code>orders/v2</code> API to
/// retrieve the order details.
/// For more information on the data returned from the Orders API, see https://developer.paypal.com/docs/api/orders/v2/#orders_get
/// note:
/// <em>Getting order details is only supported for tokens generated using the <code>orders/v2/</code> API</em>.
/// Tokens generated using other endpoints (for example, billing agreements, or the <code>payments/v1/</code>, will not be compatible with
/// this function.
/// \param onComplete Callback for when the order details have been fetched or an error is encountered.
///
- (void)getOrderDetailsOnComplete:(void (^ _Nonnull)(PPCOrderDetails * _Nullable, NSError * _Nullable))onComplete;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@class NSString;
enum PPCApprovalOrderIntent : NSInteger;
@class NSURL;
@class PPCVaultData;
@class PPCCorrelationIDs;

/// Data describing an approved order
SWIFT_CLASS_NAMED("ApprovalData")
@interface PPCApprovalData : NSObject
/// Payer ID is also the user id associated with the transaction.
@property (nonatomic, readonly, copy) NSString * _Nonnull payerID;
/// The payment token associated with the order, also known as the order id.
@property (nonatomic, readonly, copy) NSString * _Nonnull ecToken;
/// The billing agreement token
@property (nonatomic, readonly, copy) NSString * _Nullable billingToken;
/// Intent, this will be <code>CAPTURE</code> or <code>AUTHORIZE</code> if the order token was generated using the <code>v2/</code> API
/// and can be <code>CAPTURE</code>, <code>AUTHORIZE</code> or <code>ORDER</code> if order token was generated using the <code>v1/</code> API
/// <code>SALE</code> intent on <code>v1/</code> will be considered as a <code>CAPTURE</code>
@property (nonatomic, readonly) enum PPCApprovalOrderIntent intent;
/// Return URL can be used to redirect control back to the merchant
@property (nonatomic, readonly, copy) NSURL * _Nullable returnURL;
/// Unique identifier for a payment. Associated with tokens generated with the <code>v1/payments</code> API.
/// Will be <code>nil</code> for payments associated with the <code>v2</code> API.
@property (nonatomic, readonly, copy) NSString * _Nullable paymentID;
/// Data describing an approved vault flow
@property (nonatomic, readonly, strong) PPCVaultData * _Nullable vaultData;
/// Container for identifiers associated with PayPal domain specific events
@property (nonatomic, readonly, strong) PPCCorrelationIDs * _Nonnull correlationIDs;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// The intent of an order.
/// <ul>
///   <li>
///     <code>authorize</code>: The merchant intends to authorize a payment and place funds on hold after the customer makes a payment.
///   </li>
///   <li>
///     <code>capture</code>: The merchant intends to capture payment immediately after the customer makes a payment.
///   </li>
///   <li>
///     <code>order</code>: The merchant intends to save an order, then authorize to place funds on hold after the customer makes a payment.
///   </li>
/// </ul>
/// <a href="https://developer.paypal.com/docs/api/orders/v2/#orders_create">Intent enum documentation guide</a>
typedef SWIFT_ENUM_NAMED(NSInteger, PPCApprovalOrderIntent, "ApprovalOrderIntent", open) {
/// Non mapped or empty intent
  PPCApprovalOrderIntentNone = 0,
/// The merchant intends to capture payment immediately after the customer makes a payment.
  PPCApprovalOrderIntentCapture = 1,
/// The merchant intends to authorize a payment and place funds on hold after the customer makes a payment.
  PPCApprovalOrderIntentAuthorize = 2,
/// The merchant intends to save an order, then authorize to place funds on hold after the customer makes a payment.
  PPCApprovalOrderIntentOrder = 3,
};

@class UIImage;

SWIFT_CLASS("_TtC14PayPalCheckout20AspectRatioImageView")
@interface AspectRatioImageView : UIImageView
- (nonnull instancetype)initWithFrame:(CGRect)frame OBJC_DESIGNATED_INITIALIZER;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)coder OBJC_DESIGNATED_INITIALIZER SWIFT_UNAVAILABLE;
- (nonnull instancetype)initWithImage:(UIImage * _Nullable)image SWIFT_UNAVAILABLE;
- (nonnull instancetype)initWithImage:(UIImage * _Nullable)image highlightedImage:(UIImage * _Nullable)highlightedImage SWIFT_UNAVAILABLE;
@end

@class PPCOrderActionData;

/// Object representing a successful Authorize action. Currently exclusively wraps the <code>OrderActionData</code>,
/// but may be extended in the future.
SWIFT_CLASS_NAMED("AuthorizeActionSuccess")
@interface PPCAuthorizeActionSuccess : NSObject
/// Data associated with a successful <code>authorize</code> order action
@property (nonatomic, readonly, strong) PPCOrderActionData * _Nonnull data;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


SWIFT_CLASS("_TtC14PayPalCheckout10BackAction")
@interface BackAction : UIButton
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
- (nonnull instancetype)initWithFrame:(CGRect)frame OBJC_DESIGNATED_INITIALIZER;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)coder OBJC_DESIGNATED_INITIALIZER;
@end

@class UIEvent;

/// A specified parent class that indicates background views which are applied
/// when specific pages are presented. These background views will be applied to
/// the view controller where the paysheet itself is presented into.
SWIFT_CLASS("_TtC14PayPalCheckout10Background")
@interface Background : UIView
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)coder OBJC_DESIGNATED_INITIALIZER SWIFT_UNAVAILABLE;
/// We need a better means of passing through taps from child views
/// to parent/super views. This is hack to use <code>shouldPassThroughTouches</code>
/// flag to return super view to handle tap from hit test
- (UIView * _Nullable)hitTest:(CGPoint)point withEvent:(UIEvent * _Nullable)event SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)initWithFrame:(CGRect)frame SWIFT_UNAVAILABLE;
@end


/// Data vended in response to a successful OrderAction for executing a billing agreement
SWIFT_CLASS_NAMED("BillingActionData")
@interface PPCBillingActionData : NSObject
/// The Billing-ID to be used for future billing agreement transactions
@property (nonatomic, readonly, copy) NSString * _Nonnull billingId;
/// The state of the billing agreement, which should be <code>ACTIVE</code> after the billing agreement is executed
@property (nonatomic, readonly, copy) NSString * _Nonnull state;
/// Full JSON response to the billing execute action request
@property (nonatomic, readonly, copy) NSDictionary<NSString *, id> * _Nonnull billingData;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


SWIFT_CLASS("_TtC14PayPalCheckout21BrandedBackgroundView") SWIFT_DEPRECATED_MSG("Please use the new backgrounds member in ExtendedCheckoutConfig")
@interface BrandedBackgroundView : UIView
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)coder SWIFT_UNAVAILABLE;
- (nonnull instancetype)initWithFrame:(CGRect)frame SWIFT_UNAVAILABLE;
@end



/// Object representing a successful capture action. Currently exclusively wraps the <code>OrderActionData</code>,
/// but may be extended in the future.
SWIFT_CLASS_NAMED("CaptureActionSuccess")
@interface PPCCaptureActionSuccess : NSObject
/// Data associated with a successful <code>capture</code> order action
@property (nonatomic, readonly, strong) PPCOrderActionData * _Nonnull data;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


/// The <code>Carousel Cell</code> class hold the FI image and labels, notification label and
/// the preferred view
SWIFT_CLASS("_TtC14PayPalCheckout12CarouselCell")
@interface CarouselCell : UICollectionViewCell
- (nonnull instancetype)initWithFrame:(CGRect)frame SWIFT_UNAVAILABLE;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)aDecoder SWIFT_UNAVAILABLE;
/// Re-setting the cells before they’re reused
- (void)prepareForReuse;
/// Custom HitTest has an additional check before the normal behavior to
/// check if this is something preferredView could handle despite being
/// outside of the cell’s bounds. This is necessary to do because the default
/// behavior does not allow for taps outside of the superview to be claimed
/// by subviews.
- (UIView * _Nullable)hitTest:(CGPoint)point withEvent:(UIEvent * _Nullable)event SWIFT_WARN_UNUSED_RESULT;
@end

@class UITraitCollection;
@class UICollectionView;
@class NSIndexPath;
@class UIScrollView;

/// The carousel view denotes the primary wallet and funding instrument selection
/// component
SWIFT_CLASS("_TtC14PayPalCheckout12CarouselView")
@interface CarouselView : UIView <UICollectionViewDelegate>
- (nonnull instancetype)initWithFrame:(CGRect)frame SWIFT_UNAVAILABLE;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)aDecoder SWIFT_UNAVAILABLE;
- (void)traitCollectionDidChange:(UITraitCollection * _Nullable)previousTraitCollection;
- (void)layoutSubviews;
- (void)collectionView:(UICollectionView * _Nonnull)collectionView didSelectItemAtIndexPath:(NSIndexPath * _Nonnull)indexPath;
/// Cancel previous pending performs on this object and ensure that
/// <code>scrollViewDidEndScrollAnimation</code> is called. This also
/// ensures that <code>selectFIIfNeeded</code> is called if the user scrolls
/// and then drags their finger off the screen. The <code>ensureDelay</code>
/// is to simulate the same delay from <code>scrollViewDidEndDecelerating</code>.
- (void)scrollViewDidScroll:(UIScrollView * _Nonnull)scrollView;
/// This specific method detects when the scroll ends due to the following -
/// • When the user lifts their finger off the screen
/// • When the user drags their finger across and off the screen without lifting their finger
- (void)scrollViewDidEndScrollingAnimation:(UIScrollView * _Nonnull)scrollView;
@end


SWIFT_CLASS("_TtC14PayPalCheckout15CartDetailsView")
@interface CartDetailsView : UIView
- (nonnull instancetype)initWithFrame:(CGRect)frame SWIFT_UNAVAILABLE;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)aDecoder SWIFT_UNAVAILABLE;
@end

/// Information about the channel used to start the checkout flow
typedef SWIFT_ENUM_NAMED(NSInteger, PPCChannel, "Channel", open) {
/// Checkout flow started from a native app
  PPCChannelNative = 0,
/// Checkout flow started from a mobile web browser
  PPCChannelMobileWeb = 1,
/// Checkout flow started from a desktop web browser and continued on a mobile device
  PPCChannelDesktopWeb = 2,
};

enum PPCUserAction : NSInteger;
@class PPCCreateOrderAction;
@class PPCShippingChange;
@class PPCShippingChangeAction;
@class PPCErrorInfo;
@class PPCheckoutConfig;
enum PPCCurrencyCode : NSInteger;
@class UIViewController;

/// The main interface where you can change or start behavior of the Checkout paysheet.
SWIFT_CLASS_NAMED("Checkout")
@interface PPCheckout : NSObject
/// The current version of the Checkout SDK
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, copy) NSString * _Nonnull sdkVersion;)
+ (NSString * _Nonnull)sdkVersion SWIFT_WARN_UNUSED_RESULT;
/// Pay mode used for a checkout session (Continue, Pay Now)
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly) enum PPCUserAction userAction;)
+ (enum PPCUserAction)userAction SWIFT_WARN_UNUSED_RESULT;
/// Determines if the SDK displays an alert before dismissing the paysheet
SWIFT_CLASS_PROPERTY(@property (nonatomic, class) BOOL showsExitAlert;)
+ (BOOL)showsExitAlert SWIFT_WARN_UNUSED_RESULT;
+ (void)setShowsExitAlert:(BOOL)value;
SWIFT_CLASS_PROPERTY(@property (nonatomic, class) BOOL showsExitSurvey SWIFT_DEPRECATED_MSG("The exit survey has been removed. Setting a value to this variable will have no effect.");)
+ (BOOL)showsExitSurvey SWIFT_WARN_UNUSED_RESULT;
+ (void)setShowsExitSurvey:(BOOL)value;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
/// Allows you to set the createOrder callback to be passed into the config object.
/// This will be called when creating order/requesting order ID from merchant.
/// note:
///
/// <ul>
///   <li>
///     This function cannot be called before <code>Checkout.set(config:)</code> or during an active session.
///     Attempting to call this function before <code>Checkout.set(config:)</code> or during an active session will result in
///     the callback not being set.
///   </li>
///   <li>
///     Calling this function will override the createOrder callback of the config set with <code>Checkout.set(config:)</code>
///   </li>
/// </ul>
+ (void)setCreateOrderCallback:(void (^ _Nonnull)(PPCCreateOrderAction * _Nonnull))createOrder;
/// Allows you to set the onApprove callback to be passed into the config object.
/// This will be called when the transaction has been approved.
/// note:
///
/// <ul>
///   <li>
///     This function cannot be called before <code>Checkout.set(config:)</code> or during an active session.
///     Attempting to call this function before <code>Checkout.set(config:)</code> or during an active session will result in
///     the callback not being set.
///   </li>
///   <li>
///     Calling this function will override the onApprove callback of the config set with <code>Checkout.set(config:)</code>
///   </li>
/// </ul>
+ (void)setOnApproveCallback:(void (^ _Nonnull)(PPCApproval * _Nonnull))onApprove;
/// Allows you to set the onShippingChange callback to be passed into the config object.
/// This will be called when the shipping address is changed.
/// note:
///
/// <ul>
///   <li>
///     This function cannot be called before <code>Checkout.set(config:)</code> or during an active session.
///     Attempting to call this function before <code>Checkout.set(config:)</code> or during an active session will result in
///     the callback not being set.
///   </li>
///   <li>
///     Calling this function will override the onShippingChange callback of the config set with <code>Checkout.set(config:)</code>
///   </li>
/// </ul>
+ (void)setOnShippingChangeCallback:(void (^ _Nonnull)(PPCShippingChange * _Nonnull, PPCShippingChangeAction * _Nonnull))onShippingChange;
/// Allows you to set the onCancel callback to be passed into the config object.
/// This will be called when the user has cancelled the transaction.
/// note:
///
/// <ul>
///   <li>
///     This function cannot be called before <code>Checkout.set(config:)</code> or during an active session.
///     Attempting to call this function before <code>Checkout.set(config:)</code> or during an active session will result in
///     the callback not being set.
///   </li>
///   <li>
///     Calling this function will override the onCancel callback of the config set with <code>Checkout.set(config:)</code>
///   </li>
/// </ul>
+ (void)setOnCancelCallback:(void (^ _Nonnull)(void))onCancel;
/// Allows you to set the onError callback to be passed into the config object.
/// This will be called when an error cannot be recovered from, and the transaction has been cancelled.
/// note:
///
/// <ul>
///   <li>
///     This function cannot be called before <code>Checkout.set(config:)</code> or during an active session.
///     Attempting to call this function before <code>Checkout.set(config:)</code> or during an active session will result in
///     the callback not being set.
///   </li>
///   <li>
///     Calling this function will override the onError callback of the config set with <code>Checkout.set(config:)</code>
///   </li>
/// </ul>
+ (void)setOnErrorCallback:(void (^ _Nonnull)(PPCErrorInfo * _Nonnull))onError;
/// Logs out the current user, this will force the user to authenticate on the next session.
/// note:
///
/// <ul>
///   <li>
///     This function cannot be called during an active session.
///     Attempting to call this function during an active session will not logout the user.
///   </li>
/// </ul>
+ (void)logoutUser;
+ (void)setConfig:(PPCheckoutConfig * _Nonnull)config;
/// Set the currency code used to check PaymentButton’s eligibility.
/// Funding eligibility request for buttons will be made again if currency code changes.
/// \param currency the currency code
///
+ (void)setCurrencyCode:(enum PPCCurrencyCode)currency;
/// This function invokes the UI experience for display and must be called from main thread.
/// The hosting app may call this but doing so before <code>set(config:)</code> results in
/// an undefined experience likely resulting in error.
/// note:
/// Callbacks provided in this function will be used only for this checkout session, and
/// won’t override the callbacks you set previously with <code>Checkout.set___Callback()</code>, or with <code>CheckoutConfig.init()</code>.
/// If callbacks are not provided in this function, the callbacks you set previously will be used.
/// <ul>
///   <li>
///     Parameters:
///   </li>
///   <li>
///     presentingViewController: The UIViewController to be used to present the SDK’s experience.
///     If not provided, Checkout.config.presentingViewController will be used if available,
///     otherwise, the top most view controller currently being presented will be used.
///   </li>
///   <li>
///     createOrder: Called when creating order
///   </li>
///   <li>
///     onApprove: Called when the transaction has been approved
///   </li>
///   <li>
///     onCancel: Called when the transaction has been canceled
///   </li>
///   <li>
///     onError: Called when an error cannot be recovered from, and the transaction has been cancelled
///   </li>
/// </ul>
+ (void)startWithPresentingViewController:(UIViewController * _Nullable)presentingViewController createOrder:(void (^ _Nullable)(PPCCreateOrderAction * _Nonnull))createOrder onApprove:(void (^ _Nullable)(PPCApproval * _Nonnull))onApprove onShippingChange:(void (^ _Nullable)(PPCShippingChange * _Nonnull, PPCShippingChangeAction * _Nonnull))onShippingChange onCancel:(void (^ _Nullable)(void))onCancel onError:(void (^ _Nullable)(PPCErrorInfo * _Nonnull))onError;
@end


enum PPCEnvironment : NSInteger;
@class EnvironmentConfig;

/// Holds all the configuration values required by checkout experiences and
/// checkout flows. Modified and provided by the merchant, to start the checkout
/// flow desired.
SWIFT_CLASS_NAMED("CheckoutConfig")
@interface PPCheckoutConfig : NSObject <NSCopying>
/// The clientID is a value that application engineers can receive after registering their
/// application for use with PayPal’s services. Setup for this can be performed here:
/// https://developer.paypal.com/developer/applications/create
@property (nonatomic, copy) NSString * _Nonnull clientID;
/// The EC-Token or Pay-Token or Order ID. This token type is generated in various ways by
/// the merchant, in most cases, and sometimes by PayPal. Nonetheless, this token is required
/// on the base configuration for normal operation.
@property (nonatomic, copy) NSString * _Nullable payToken;
/// Value sent to the payments web experience to determine what payment button should be rendered to the user
/// in the case that the native SDK needs to fall back to the web based checkout flow.
/// This is a property to support the deprecated <code>payments/v1</code> web API. It is disregarded for both
/// the native checkout flow and for users of the <code>payments/v2</code> web API.
@property (nonatomic) enum PPCUserAction userAction;
/// Two separate environments are usually set here, either <code>.sandbox</code> or <code>.live</code>; see <code>Environment</code>
/// documentation for more details on other environments
@property (nonatomic) enum PPCEnvironment environment;
/// An object that allows us to tweak the knobs and levers of the  session to suit our development experience
@property (nonatomic, strong) EnvironmentConfig * _Nonnull environmentConfig;
@property (nonatomic, copy) void (^ _Nullable onAuthenticate)(void (^ _Nonnull)(NSString * _Nullable, NSError * _Nullable));
/// Called when the authentication session needs to be passed from native to web
@property (nonatomic, copy) void (^ _Nullable onAuthStepUp)(NSString * _Nullable, void (^ _Nonnull)(NSString * _Nullable, NSError * _Nullable));
/// Called when creating order/requesting order ID from merchant
/// createOrder passes a CreateOrderAction that can be used to either request the SDK to create an order or set the payToken with your order ID/pay token/EC token
@property (nonatomic, copy) void (^ _Nullable createOrder)(PPCCreateOrderAction * _Nonnull);
/// Called when the transaction has been approved.
@property (nonatomic, copy) void (^ _Nullable onApprove)(PPCApproval * _Nonnull);
/// Called when the user has cancelled the transaction.
@property (nonatomic, copy) void (^ _Nullable onCancel)(void);
/// Called when an error cannot be recovered from, and the transaction has been cancelled
@property (nonatomic, copy) void (^ _Nullable onError)(PPCErrorInfo * _Nonnull);
/// Called if the user logs out. The transaction will allow the user to log in?
@property (nonatomic, copy) void (^ _Nullable onLogout)(void);
/// Called when the user changes their shipping address from the paysheet
@property (nonatomic, copy) void (^ _Nullable onShippingChange)(PPCShippingChange * _Nonnull, PPCShippingChangeAction * _Nonnull);
/// When the application needs to specify which view controller will be used
/// to present the SDK’s experience. Failing this, the root most view
/// controller currently being presented will be used.
@property (nonatomic, strong) UIViewController * _Nullable presentingViewController;
/// Value to force a fallback to the Web Checkout experience instead of the Native experience.
@property (nonatomic) BOOL showWebCheckout;
/// Determines whether to show a button to copy debug payload into clipboard
@property (nonatomic) BOOL debugEnabled;
/// Optional merchant ID(s) for partners used for PaymentButton’s eligibility check.
/// This is only used for partner, marketplaces, and cart solutions when they are acting
/// on behalf of another merchant. For merchants acting on behalf of several merchants,
/// pass each merchant ID into the array. For merchants action on behalf of a single merchant,
/// you will only need to pass a single merchant ID into the array.
@property (nonatomic, copy) NSArray<NSString *> * _Nullable merchantIDs;
- (nonnull instancetype)initWithClientID:(NSString * _Nonnull)clientID createOrder:(void (^ _Nullable)(PPCCreateOrderAction * _Nonnull))createOrder onApprove:(void (^ _Nullable)(PPCApproval * _Nonnull))onApprove onShippingChange:(void (^ _Nullable)(PPCShippingChange * _Nonnull, PPCShippingChangeAction * _Nonnull))onShippingChange onCancel:(void (^ _Nullable)(void))onCancel onError:(void (^ _Nullable)(PPCErrorInfo * _Nonnull))onError environment:(enum PPCEnvironment)environment OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)initWithClientID:(NSString * _Nonnull)clientID returnUrl:(NSString * _Nonnull)returnUrl createOrder:(void (^ _Nullable)(PPCCreateOrderAction * _Nonnull))createOrder onApprove:(void (^ _Nullable)(PPCApproval * _Nonnull))onApprove onShippingChange:(void (^ _Nullable)(PPCShippingChange * _Nonnull, PPCShippingChangeAction * _Nonnull))onShippingChange onCancel:(void (^ _Nullable)(void))onCancel onError:(void (^ _Nullable)(PPCErrorInfo * _Nonnull))onError environment:(enum PPCEnvironment)environment SWIFT_DEPRECATED_MSG("`init(clientID:returnUrl: ...)` has been deprecated and will be removed in a future version of the SDK. Use `init(clientID: ...)` instead");
- (id _Nonnull)copyWithZone:(struct _NSZone * _Nullable)zone SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@class PPCSessionIDs;

/// Correlation IDs are debug IDs that the PayPal team uses to track issues.
SWIFT_CLASS_NAMED("CorrelationIDs")
@interface PPCCorrelationIDs : NSObject
/// Our correlation id associated when checking funding eligibility for payment buttons
@property (nonatomic, readonly, copy) NSString * _Nullable fundingEligibilityDebugID;
/// Our correlation id associated when checking eligibility.
@property (nonatomic, readonly, copy) NSString * _Nullable eligibilityDebugID;
/// Our correlation id associated when updating client config.
@property (nonatomic, readonly, copy) NSString * _Nullable updateClientConfigDebugID;
/// Our correlation id associated when upgrading LSAT.
@property (nonatomic, readonly, copy) NSString * _Nullable lsatUpgradeDebugID;
/// Our correlation id associated when fetching user info.
@property (nonatomic, readonly, copy) NSString * _Nullable fetchPayloadDebugID;
/// Our correlation ids associated when fetching cart on shipping callback
@property (nonatomic, readonly, copy) NSArray<NSString *> * _Nonnull fetchCartDebugIDs;
/// Our correlation id associated when converting currency info.
@property (nonatomic, readonly, copy) NSString * _Nullable currencyConversionDebugID;
/// Our correlation id associated when completing SCA.
@property (nonatomic, readonly, copy) NSString * _Nullable completeSCADebugID;
/// Our correlation id associated when finishing the checkout flow.
@property (nonatomic, readonly, copy) NSString * _Nullable finishCheckoutDebugID;
@property (nonatomic, readonly, copy) NSString * _Nullable riskCorrelationID;
/// Our session identifiers
@property (nonatomic, readonly, strong) PPCSessionIDs * _Nonnull sessionIDs;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

@class PPCOrderRequest;

/// CreateOrderAction object to be passed in CreateOrderCallback,
/// allowing merchants options to create order and obtain EC-Token (or Pay-Token or Order ID),
/// either by their own means or using built in functions in the SDK.
SWIFT_CLASS_NAMED("CreateOrderAction")
@interface PPCCreateOrderAction : NSObject
/// Request the SDK to create an order and get an order ID with PayPal Orders API.
/// Once completed, payToken is set with the order ID requested from Orders API to be used internally in the SDK.
/// Documentation on Orders API: https://developer.paypal.com/docs/api/orders/v2/#orders_create
/// \param order an OrderRequest object representing the order
///
/// \param completion a closure with the order ID once the SDK finishes creating order
///
- (void)createWithOrder:(PPCOrderRequest * _Nonnull)order completion:(void (^ _Nonnull)(NSString * _Nullable))completion;
/// Set payToken to be used internally in the SDK if you have an order ID/pay token/EC token
/// \param orderId an order ID/pay token/EC token
///
- (void)setWithOrderId:(NSString * _Nonnull)orderId;
/// Interface to provide the SDK with a Billing Agreement token. This will trigger a fallback to a web experience for a user
/// to log in and complete the agreement.
/// note:
///
/// To generate a billing agreement token using your server implementation,
/// <a href="https://developer.paypal.com/docs/limited-release/reference-transactions/#create-billing-agreement-token">see our documentation on reference transactions</a>
/// \param billingAgreementToken Billing agreement token
///
- (void)setWithBillingAgreementToken:(NSString * _Nonnull)billingAgreementToken;
/// Interface to provide the SDK with a Vault approval session ID to let user add a funding instrument to vault to be used for future transactions.
/// note:
///
/// To generate a vault approval session ID using your server implementation,
/// <a href="https://developer.paypal.com/limited-release/vault-payment-methods/vault-api">see our documentation on reference transactions</a>
/// \param vaultApprovalSessionID Vault approval session ID
///
- (void)setWithVaultApprovalSessionID:(NSString * _Nonnull)vaultApprovalSessionID;
/// In case your request to create order fails, call this function instead of <code>set(orderId:)</code> in order to close the Paysheet.
- (void)cancel;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


SWIFT_CLASS("_TtC14PayPalCheckout14CryptoRateView")
@interface CryptoRateView : UIView
- (nonnull instancetype)initWithFrame:(CGRect)frame SWIFT_UNAVAILABLE;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)aDecoder SWIFT_UNAVAILABLE;
@end

/// An enum of the possible values to be passed as the curency code.
/// <a href="https://developer.paypal.com/docs/api/orders/v2/#definition-currency_code">Currency code enum documentation guide</a>
typedef SWIFT_ENUM_NAMED(NSInteger, PPCCurrencyCode, "CurrencyCode", open) {
  PPCCurrencyCodeAud = 0,
  PPCCurrencyCodeBrl = 1,
  PPCCurrencyCodeCad = 2,
  PPCCurrencyCodeCny = 3,
  PPCCurrencyCodeCzk = 4,
  PPCCurrencyCodeDkk = 5,
  PPCCurrencyCodeEur = 6,
  PPCCurrencyCodeHkd = 7,
  PPCCurrencyCodeHuf = 8,
  PPCCurrencyCodeInr = 9,
  PPCCurrencyCodeIls = 10,
  PPCCurrencyCodeJpy = 11,
  PPCCurrencyCodeMyr = 12,
  PPCCurrencyCodeMxn = 13,
  PPCCurrencyCodeTwd = 14,
  PPCCurrencyCodeNzd = 15,
  PPCCurrencyCodeNok = 16,
  PPCCurrencyCodePhp = 17,
  PPCCurrencyCodePln = 18,
  PPCCurrencyCodeGbp = 19,
  PPCCurrencyCodeRub = 20,
  PPCCurrencyCodeSgd = 21,
  PPCCurrencyCodeSek = 22,
  PPCCurrencyCodeChf = 23,
  PPCCurrencyCodeThb = 24,
  PPCCurrencyCodeUsd = 25,
};


SWIFT_CLASS("_TtC14PayPalCheckout12DeliveryView")
@interface DeliveryView : UIView
- (nonnull instancetype)initWithFrame:(CGRect)frame SWIFT_UNAVAILABLE;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)aDecoder SWIFT_UNAVAILABLE;
@end


/// Used to determine which endpoints to target for interactions with the PayPal API.
typedef SWIFT_ENUM_NAMED(NSInteger, PPCEnvironment, "Environment", open) {
/// The live environent for use in production
  PPCEnvironmentLive = 0,
/// The environment used for development and testing
  PPCEnvironmentSandbox = 1,
/// Environment for internal PayPal use. Inaccessible for third party.
  PPCEnvironmentStage = 2,
};


/// A config that toggles shims in the code for development purposes.
SWIFT_CLASS("_TtC14PayPalCheckout17EnvironmentConfig")
@interface EnvironmentConfig : NSObject <NSCopying>
/// Toggle  eligibility check for stage or sandbox
/// The default true setting will check for eligibility while false will force
/// <code>State.isNativeEligible = true</code> and skip the actual network call
@property (nonatomic) BOOL checksEligibility;
- (id _Nonnull)copyWithZone:(struct _NSZone * _Nullable)zone SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end


/// Encapsulates metadata after <code>CheckoutConfig.onError</code> is called.
/// This meta information can be utilized to debug our checkout sessions.
SWIFT_CLASS_NAMED("ErrorInfo")
@interface PPCErrorInfo : NSObject
/// The actual error.
@property (nonatomic, readonly) NSError * _Nonnull error;
/// The error reason.
@property (nonatomic, readonly, copy) NSString * _Nonnull reason;
/// Container for identifiers associated with PayPal domain specific events
@property (nonatomic, readonly, strong) PPCCorrelationIDs * _Nonnull correlationIDs;
/// Pay token/EC-Token/OrderID
@property (nonatomic, readonly, copy) NSString * _Nonnull payToken;
/// SDK version.
@property (nonatomic, readonly, copy) NSString * _Nonnull nativeSdkVersion;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


/// This class should contain all the extended featurs privy to first party
/// or implicity trusted host applications. Those not explicity validated to
/// be on the whitelist for the PayPal iOS Checkout SDK will find that all
/// extended features in this class are ignored.
SWIFT_CLASS("_TtC14PayPalCheckout22ExtendedCheckoutConfig")
@interface ExtendedCheckoutConfig : PPCheckoutConfig
/// A  session ID generated from the Smart Payment
/// Button will be required to authenticate the Firebase App.
/// The sessionUID is retrieved from the merchant and
/// then used with PayPal’s GraphQL to generate a sessionToken.
@property (nonatomic, copy) NSString * _Nullable sessionUID;
/// The button session id associated with the merchant from SPB (web to app).
@property (nonatomic, copy) NSString * _Nullable buttonSessionID;
/// The stickiness id associated passed from SPB
@property (nonatomic, copy) NSString * _Nullable stickinessID;
@property (nonatomic, copy) NSString * _Nullable pageUrl;
/// Merchant’s client ID
@property (nonatomic, copy) NSString * _Nullable facilitatorClientID;
/// Merchant’s domain
@property (nonatomic, copy) NSString * _Nullable domain;
/// Allows merchants to force an experience on, for example Venmo (passed from SPB)
@property (nonatomic, copy) NSArray<NSString *> * _Nonnull enableFunding;
/// Information about the channel used to start the checkout flow (native, mobile web, desktop web, etc)
@property (nonatomic) enum PPCChannel channel;
/// The app guid is passed from consumer app, stored in Keychain. It is utilized
/// as a way to tie together events from different components when triaging issues
/// on the server-side.
@property (nonatomic, copy) NSString * _Nullable appGuid;
/// The device id is passed from the consumer app, stored in Keychain. It is utilized
/// as a way to tie together events from different components when triaging issues
/// on the server side.
@property (nonatomic, copy) NSString * _Nullable deviceId;
/// When transaction requires a shipping address and a user does not have one
/// SDK cannot proceed and falls back to web. Setting this property to <code>true</code> allows SDK to proceed
/// with responsibility to collect a shipping address and provide it to SDK moving to the host app.
@property (nonatomic) BOOL skipsShippingAddressContingency;
/// Indicates whether Billing Agreements are supported by a host or not.
/// If not, the checkout flow will fallback to web if this is supported (see <code>supportsWebFallbacks</code>).
@property (nonatomic) BOOL supportsBillingAgreements;
/// Indicates whether or not web fallbacks are supported
@property (nonatomic) BOOL supportsWebFallbacks;
/// Determines if SDK should skip updating any functionality/process
/// that depends on a returned experiment and treatment value
/// and defaults the functionality/process to its control state
@property (nonatomic, copy) NSArray<NSString *> * _Nullable elmoExperimentsToSkip;
/// Used to determine whether we’re using Firebase in the current lifecycle
@property (nonatomic, readonly) BOOL usesFirebase;
/// Called right after a user clicks to Add Card natively. We need to
/// upgrade the auth state of the user so that we can perform the
/// Add Card action server side.
@property (nonatomic, copy) void (^ _Nullable onAddCardStepUp)(void (^ _Nonnull)(NSString * _Nullable, NSError * _Nullable));
- (nonnull instancetype)initWithClientID:(NSString * _Nonnull)clientID createOrder:(void (^ _Nullable)(PPCCreateOrderAction * _Nonnull))createOrder onApprove:(void (^ _Nullable)(PPCApproval * _Nonnull))onApprove onShippingChange:(void (^ _Nullable)(PPCShippingChange * _Nonnull, PPCShippingChangeAction * _Nonnull))onShippingChange onCancel:(void (^ _Nullable)(void))onCancel onError:(void (^ _Nullable)(PPCErrorInfo * _Nonnull))onError environment:(enum PPCEnvironment)environment SWIFT_UNAVAILABLE;
@end



SWIFT_CLASS("_TtC14PayPalCheckout8Legalese")
@interface Legalese : UIView
- (nonnull instancetype)initWithFrame:(CGRect)frame OBJC_DESIGNATED_INITIALIZER;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)coder OBJC_DESIGNATED_INITIALIZER;
@end


SWIFT_CLASS("_TtC14PayPalCheckout21LineItemContainerView")
@interface LineItemContainerView : UIView
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)aDecoder SWIFT_UNAVAILABLE;
- (nonnull instancetype)initWithFrame:(CGRect)frame SWIFT_UNAVAILABLE;
@end


SWIFT_CLASS("_TtC14PayPalCheckout13LogoImageView")
@interface LogoImageView : UIImageView
- (nonnull instancetype)initWithFrame:(CGRect)frame OBJC_DESIGNATED_INITIALIZER;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)coder OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)initWithImage:(UIImage * _Nullable)image OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)initWithImage:(UIImage * _Nullable)image highlightedImage:(UIImage * _Nullable)highlightedImage OBJC_DESIGNATED_INITIALIZER;
@end







/// Data vended in response to a successful OrderAction for capturing/authorizing funds
SWIFT_CLASS_NAMED("OrderActionData")
@interface PPCOrderActionData : NSObject
/// Identifier of the response
@property (nonatomic, readonly, copy) NSString * _Nonnull id;
/// Status of the response
@property (nonatomic, readonly, copy) NSString * _Nonnull status;
/// Full JSON response to the order action request
@property (nonatomic, copy) NSDictionary<NSString *, id> * _Nonnull orderData;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


/// Describes an address.
/// Should be used in the creation of the folowing objects
/// <ul>
///   <li>
///     <a href="https://developer.paypal.com/docs/api/orders/v2/#definition-shipping_detail.address_portable">PurchaseUnit.shipping.address</a>
///   </li>
///   <li>
///     <a href="https://developer.paypal.com/docs/api/orders/v2/#definition-payer.address_portable">Payer.address</a>
///   </li>
/// </ul>
SWIFT_CLASS_NAMED("OrderAddress")
@interface PPCOrderAddress : NSObject
/// The first line of the address. For example, number or street. For example, 173 Drury Lane.
/// Required for data entry and compliance and risk checks. Must contain the full address. Maximum length: 300.
@property (nonatomic, readonly, copy) NSString * _Nullable addressLine1;
/// The second line of the address. For example, suite or apartment number.
/// Maximum length: 300.
@property (nonatomic, readonly, copy) NSString * _Nullable addressLine2;
/// The highest level sub-division in a country, which is usually a province, state, or ISO-3166-2 subdivision.
/// Format for postal delivery. For example, CA and not California.
/// Value, by country, is:
/// <ul>
///   <li>
///     UK: A county.
///   </li>
///   <li>
///     US: A state.
///   </li>
///   <li>
///     Canada: A province.
///   </li>
///   <li>
///     Japan: A prefecture.
///   </li>
///   <li>
///     Switzerland: A kanton.
///   </li>
/// </ul>
/// Maximum length: 300.
@property (nonatomic, readonly, copy) NSString * _Nullable adminArea1;
/// A city, town, or village. Smaller than admin_area_level_1.
/// <ul>
///   <li>
///     Maximum length: 120.
///   </li>
/// </ul>
@property (nonatomic, readonly, copy) NSString * _Nullable adminArea2;
/// The postal code, which is the zip code or equivalent. Typically required for countries with a postal code or an equivalent.
/// <ul>
///   <li>
///     Maximum length: 60.
///   </li>
/// </ul>
@property (nonatomic, readonly, copy) NSString * _Nullable postalCode;
/// The <a href="https://developer.paypal.com/docs/api/reference/country-codes/">two-character ISO 3166-1 code</a> that identifies the country or region.
@property (nonatomic, readonly, copy) NSString * _Nonnull countryCode;
- (nonnull instancetype)initWithCountryCode:(NSString * _Nonnull)countryCode addressLine1:(NSString * _Nullable)addressLine1 addressLine2:(NSString * _Nullable)addressLine2 adminArea1:(NSString * _Nullable)adminArea1 adminArea2:(NSString * _Nullable)adminArea2 postalCode:(NSString * _Nullable)postalCode OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

enum PPCOrderApplicationContextShippingPreference : NSInteger;
enum PPCOrderApplicationContextUserAction : NSInteger;
@class PPCOrderApplicationContextPaymentMethod;
@class PPCOrderApplicationContextStoredPaymentSource;

/// A class that represents the possible values to be passed as part of the application context object.
/// <a href="https://developer.paypal.com/docs/api/orders/v2/#definition-order_application_context">OrderApplicationContext object documentation guide</a>
SWIFT_CLASS_NAMED("OrderApplicationContext")
@interface PPCOrderApplicationContext : NSObject
/// The label that overrides the business name in the PayPal account on the PayPal site. Maximum length: 127.
@property (nonatomic, readonly, copy) NSString * _Nullable brandName;
/// The BCP 47-formatted locale of pages that the PayPal payment experience shows. PayPal supports a five-character code.
/// For example, da-DK, he-IL, id-ID, ja-JP, no-NO, pt-BR, ru-RU, sv-SE, th-TH, zh-CN, zh-HK, or zh-TW.
/// <ul>
///   <li>
///     Minimum length: 2
///   </li>
///   <li>
///     Maximum length: 10
///   </li>
///   <li>
///     Pattern: ^[a-z]{2}(?:-[A-Z][a-z]{3})?(?:-(?:[A-Z]{2}))?$
///   </li>
/// </ul>
@property (nonatomic, readonly, copy) NSString * _Nullable locale;
/// The shipping preference
/// <ul>
///   <li>
///     Displays the shipping address to the customer.
///   </li>
///   <li>
///     Enables the customer to choose an address on the PayPal site.
///   </li>
///   <li>
///     Restricts the customer from changing the address during the payment-approval process.
///   </li>
/// </ul>
@property (nonatomic, readonly) enum PPCOrderApplicationContextShippingPreference shippingPreference;
/// Configures a Continue or Pay Now checkout flow.
@property (nonatomic, readonly) enum PPCOrderApplicationContextUserAction userAction;
/// The customer and merchant payment preferences.
@property (nonatomic, readonly, strong) PPCOrderApplicationContextPaymentMethod * _Nullable paymentMethod;
/// The URL where the customer is redirected after the customer approves the payment.
@property (nonatomic, readonly, copy) NSString * _Nullable returnUrl;
/// The URL where the customer is redirected after the customer cancels the payment.
@property (nonatomic, readonly, copy) NSString * _Nullable cancelUrl;
/// Provides additional details to process a payment using a <code>payment_source</code>
/// that has been stored or is intended to be stored (also referred to as stored_credential or card-on-file).
@property (nonatomic, readonly, strong) PPCOrderApplicationContextStoredPaymentSource * _Nullable storedPaymentSource;
- (nonnull instancetype)initWithBrandName:(NSString * _Nullable)brandName locale:(NSString * _Nullable)locale shippingPreference:(enum PPCOrderApplicationContextShippingPreference)shippingPreference userAction:(enum PPCOrderApplicationContextUserAction)userAction paymentMethod:(PPCOrderApplicationContextPaymentMethod * _Nullable)paymentMethod returnUrl:(NSString * _Nullable)returnUrl cancelUrl:(NSString * _Nullable)cancelUrl storedPaymentSource:(PPCOrderApplicationContextStoredPaymentSource * _Nullable)storedPaymentSource OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// Shipping preference set by the merchant. Affects the ability of the payer to change their shipping information
/// within the PayPal SDK
typedef SWIFT_ENUM_NAMED(NSInteger, PPCOrderApplicationContextShippingPreference, "ShippingPreference", open) {
  PPCOrderApplicationContextShippingPreferenceNone = 0,
/// Use the customer-provided shipping address on the PayPal site.
  PPCOrderApplicationContextShippingPreferenceGetFromFile = 1,
/// Redact the shipping address from the PayPal site. Recommended for digital goods.
  PPCOrderApplicationContextShippingPreferenceNoShipping = 2,
/// Use the merchant-provided address. The customer cannot change this address on the PayPal site.
  PPCOrderApplicationContextShippingPreferenceSetProvidedAddress = 3,
};

/// Defines whether to present the customer with a Continue or Pay Now checkout flow.
typedef SWIFT_ENUM_NAMED(NSInteger, PPCOrderApplicationContextUserAction, "UserAction", open) {
  PPCOrderApplicationContextUserActionNone = 0,
/// Use this option when the final amount is not known when the checkout flow is initiated and you want
/// to redirect the customer to the merchant page without processing the payment.
  PPCOrderApplicationContextUserActionContinue = 1,
/// Use this option when the final amount is known when the checkout is initiated and you want to process
/// the payment immediately when the customer clicks Pay Now.
  PPCOrderApplicationContextUserActionPayNow = 2,
};

enum PPCOrderApplicationContextPayerSelected : NSInteger;
enum PPCOrderApplicationContextPayeePreferred : NSInteger;
enum PPCOrderApplicationContextStandardEntryClassCode : NSInteger;

/// The customer and merchant payment preferences.
SWIFT_CLASS_NAMED("PaymentMethod")
@interface PPCOrderApplicationContextPaymentMethod : NSObject
/// The customer-selected payment method on the merchant site.
/// <ul>
///   <li>
///     Minimum length: 1
///   </li>
///   <li>
///     Pattern: ^[0-9A-Z_]+$
///   </li>
/// </ul>
@property (nonatomic, readonly) enum PPCOrderApplicationContextPayerSelected payerSelected;
/// The merchant-preferred payment methods.
@property (nonatomic, readonly) enum PPCOrderApplicationContextPayeePreferred payeePreferred;
/// NACHA (the regulatory body governing the ACH network) requires that API callers
/// (merchants, partners) obtain the consumer’s explicit authorization before initiating a transaction. To stay compliant,
/// you’ll need to make sure that you retain a compliant authorization for each transaction that you originate to the ACH Network
/// using this API. ACH transactions are categorized (using SEC codes) by how you capture authorization from the Receiver
/// (the person whose bank account is being debited or credited).
@property (nonatomic, readonly) enum PPCOrderApplicationContextStandardEntryClassCode standardEntryClassCode;
- (nonnull instancetype)initWithPayerSelected:(enum PPCOrderApplicationContextPayerSelected)payerSelected payeePreferred:(enum PPCOrderApplicationContextPayeePreferred)payeePreferred standardEntryClassCode:(enum PPCOrderApplicationContextStandardEntryClassCode)standardEntryClassCode OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// The customer-selected payment method on the merchant site.
/// Possible values are:
/// <ul>
///   <li>
///     PayPal
///   </li>
///   <li>
///     PayPal Credit
///   </li>
/// </ul>
typedef SWIFT_ENUM_NAMED(NSInteger, PPCOrderApplicationContextPayerSelected, "PayerSelected", open) {
  PPCOrderApplicationContextPayerSelectedNone = 0,
  PPCOrderApplicationContextPayerSelectedPaypal = 1,
  PPCOrderApplicationContextPayerSelectedPaypalCredit = 2,
  PPCOrderApplicationContextPayerSelectedPaypalPayLater = 3,
  PPCOrderApplicationContextPayerSelectedFlexPay = 4,
};

/// Describes possible merchant-preferred payment methods.
typedef SWIFT_ENUM_NAMED(NSInteger, PPCOrderApplicationContextPayeePreferred, "PayeePreferred", open) {
  PPCOrderApplicationContextPayeePreferredNone = 0,
/// Accepts any type of payment from the customer.
  PPCOrderApplicationContextPayeePreferredUnrestricted = 1,
/// Accepts only immediate payment from the customer.
/// For example, credit card, PayPal balance, or instant ACH. Ensures that at the time of capture,
/// the payment does not have the <code>pending</code> status.
  PPCOrderApplicationContextPayeePreferredImmediatePaymentRequired = 2,
};

/// Describes the possible entry class codes
typedef SWIFT_ENUM_NAMED(NSInteger, PPCOrderApplicationContextStandardEntryClassCode, "StandardEntryClassCode", open) {
  PPCOrderApplicationContextStandardEntryClassCodeNone = 0,
/// The API caller (merchant/partner) accepts authorization and payment information from a consumer over the telephone.
  PPCOrderApplicationContextStandardEntryClassCodeTel = 1,
/// The API caller (merchant/partner) accepts Debit transactions from a consumer on their website.
  PPCOrderApplicationContextStandardEntryClassCodeWeb = 2,
/// Cash concentration and disbursement for corporate debit transaction. Used to disburse or consolidate funds.
/// Entries are usually Optional high-dollar, low-volume, and time-critical. (e.g. intra-company transfers or invoice
/// payments to suppliers).
  PPCOrderApplicationContextStandardEntryClassCodeCcd = 3,
/// Prearranged payment and deposit entries. Used for debit payments authorized by a consumer account holder,<br/>
/// and usually initiated by a company. These are usually recurring debits (such as insurance premiums).
  PPCOrderApplicationContextStandardEntryClassCodePpd = 4,
};

enum PPCOrderApplicationContextPaymentInitiator : NSInteger;
enum PPCOrderApplicationContextPaymentType : NSInteger;
enum PPCOrderApplicationContextUsage : NSInteger;
@class PPCOrderApplicationContextPreviousNetworkTransactionReference;

/// Provides additional details to process a payment using a <code>payment_source</code>
/// that has been stored or is intended to be stored (also referred to as stored_credential or card-on-file).
SWIFT_CLASS_NAMED("StoredPaymentSource")
@interface PPCOrderApplicationContextStoredPaymentSource : NSObject
/// The person or party who initiated or triggered the payment.
@property (nonatomic, readonly) enum PPCOrderApplicationContextPaymentInitiator paymentInitiator;
/// Indicates the type of the stored payment_source payment.
@property (nonatomic, readonly) enum PPCOrderApplicationContextPaymentType paymentType;
/// Indicates if this is a first or subsequent payment using a stored payment source
/// (also referred to as stored credential or card on file).
@property (nonatomic, readonly) enum PPCOrderApplicationContextUsage usage;
/// Reference values used by the card network to identify a transaction.
@property (nonatomic, readonly, strong) PPCOrderApplicationContextPreviousNetworkTransactionReference * _Nullable previousNetworkTransactionReference;
- (nonnull instancetype)initWithPaymentInitiator:(enum PPCOrderApplicationContextPaymentInitiator)paymentInitiator paymentType:(enum PPCOrderApplicationContextPaymentType)paymentType usage:(enum PPCOrderApplicationContextUsage)usage previousNetworkTransactionReference:(PPCOrderApplicationContextPreviousNetworkTransactionReference * _Nullable)previousNetworkTransactionReference OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// Describes the person or party who initiated or triggered the payment.
typedef SWIFT_ENUM_NAMED(NSInteger, PPCOrderApplicationContextPaymentInitiator, "PaymentInitiator", open) {
/// Payment is initiated with the active engagement of the customer. e.g. a customer checking out on a merchant website.
  PPCOrderApplicationContextPaymentInitiatorCustomer = 0,
/// Payment is initiated by merchant on behalf of the customer without the active engagement of customer.
/// e.g. a merchant charging the monthly payment of a subscription to the customer.
  PPCOrderApplicationContextPaymentInitiatorMerchant = 1,
};

/// Describes the type of payment
typedef SWIFT_ENUM_NAMED(NSInteger, PPCOrderApplicationContextPaymentType, "PaymentType", open) {
/// One Time payment such as online purchase or donation. (e.g. Checkout with one-click).
  PPCOrderApplicationContextPaymentTypeOneTime = 0,
/// Payment which is part of a series of payments with fixed or variable amounts, following a fixed time interval.
/// (e.g. Subscription payments).
  PPCOrderApplicationContextPaymentTypeRecurring = 1,
/// Payment which is part of a series of payments that occur on a non-fixed schedule and/or have variable amounts.
/// (e.g. Account Topup payments).
  PPCOrderApplicationContextPaymentTypeUnscheduled = 2,
};

/// Indicates if this is a first or subsequent payment using a stored payment source
/// (also referred to as stored credential or card on file).
typedef SWIFT_ENUM_NAMED(NSInteger, PPCOrderApplicationContextUsage, "Usage", open) {
  PPCOrderApplicationContextUsageNone = 0,
/// Indicates the Initial/First payment with a payment_source that is intended to be stored upon successful processing of the payment.
  PPCOrderApplicationContextUsageFirst = 1,
/// Indicates a payment using a stored payment_source which has been successfully used previously for a payment.
  PPCOrderApplicationContextUsageSubsequent = 2,
/// Indicates that PayPal will derive the value of <code>FIRST</code> or <code>SUBSEQUENT</code> based on data available to PayPal.
  PPCOrderApplicationContextUsageDerived = 3,
};

enum PPCOrderApplicationContextNetwork : NSInteger;

/// Reference values used by the card network to identify a transaction.
SWIFT_CLASS_NAMED("PreviousNetworkTransactionReference")
@interface PPCOrderApplicationContextPreviousNetworkTransactionReference : NSObject
/// Transaction reference id returned by the scheme. For Visa and Amex, this is the “Tran id” field in response. For MasterCard,
/// this is the “BankNet reference id” field in response. For Discover, this is the “NRID” field in response.
/// <ul>
///   <li>
///     Minimum length: 9
///   </li>
///   <li>
///     Maximum length: 15.
///   </li>
///   <li>
///     Pattern: ^[a-zA-Z0-9]+$
///   </li>
/// </ul>
@property (nonatomic, readonly, copy) NSString * _Nonnull id;
/// The date that the transaction was authorized by the scheme. For MasterCard, this is the “BankNet reference date” field in response.
/// <ul>
///   <li>
///     Minimum length: 4
///   </li>
///   <li>
///     Maximum length: 4
///   </li>
///   <li>
///     Pattern: ^[0-9]+$.
///   </li>
/// </ul>
@property (nonatomic, readonly, copy) NSString * _Nullable date;
/// Name of the card network through which the transaction was routed.
@property (nonatomic, readonly) enum PPCOrderApplicationContextNetwork network;
- (nonnull instancetype)initWithId:(NSString * _Nonnull)id network:(enum PPCOrderApplicationContextNetwork)network date:(NSString * _Nullable)date OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// The possible value of network types
typedef SWIFT_ENUM_NAMED(NSInteger, PPCOrderApplicationContextNetwork, "Network", open) {
  PPCOrderApplicationContextNetworkVisa = 0,
  PPCOrderApplicationContextNetworkMastercard = 1,
  PPCOrderApplicationContextNetworkDiscover = 2,
  PPCOrderApplicationContextNetworkAmex = 3,
  PPCOrderApplicationContextNetworkSolo = 4,
  PPCOrderApplicationContextNetworkJcb = 5,
  PPCOrderApplicationContextNetworkStar = 6,
  PPCOrderApplicationContextNetworkDelta = 7,
  PPCOrderApplicationContextNetworkSwitchCard = 8,
  PPCOrderApplicationContextNetworkMaestro = 9,
  PPCOrderApplicationContextNetworkCbNationale = 10,
  PPCOrderApplicationContextNetworkConfigoga = 11,
  PPCOrderApplicationContextNetworkConfidis = 12,
  PPCOrderApplicationContextNetworkElectron = 13,
  PPCOrderApplicationContextNetworkCetelem = 14,
  PPCOrderApplicationContextNetworkChinaUnionPay = 15,
};

@class PPCOrderPayer;
@class PPCPurchaseUnit;

/// Data vended in response to a successful <code>OrderAction</code> for getting the current details of an existing order
/// The <code>Payer</code> and <code>PurchaseUnits</code> properties contain most of the information related to a specific order.
SWIFT_CLASS_NAMED("OrderDetails")
@interface PPCOrderDetails : PPCOrderActionData
/// An object representing the current Payer of the order
@property (nonatomic, readonly, strong) PPCOrderPayer * _Nullable payer;
/// Array of <code>PurchaseUnit</code> that are part of the order. This also contains other useful details
/// about the order such as payment history containing details about captures.
@property (nonatomic, readonly, copy) NSArray<PPCPurchaseUnit *> * _Nonnull purchaseUnits;
@end

/// An enum of the possible values to be passed as the intent of an order.
/// Possible vales are: <code>authorize</code> and <code>capture</code>
/// <a href="https://developer.paypal.com/docs/api/orders/v2/#orders_create">Intent enum documentation guide</a>
typedef SWIFT_ENUM_NAMED(NSInteger, PPCOrderIntent, "OrderIntent", open) {
  PPCOrderIntentCapture = 0,
  PPCOrderIntentAuthorize = 1,
};

@class PPCOrderPayerName;
@class PPCOrderPayerPhone;
@class PPCOrderPayerTaxInfo;

/// A class that represents the possible values to be passed as part of the payer object.
/// <a href="https://developer.paypal.com/docs/api/orders/v2/#definition-payer">Payer object documentation guide</a>
SWIFT_CLASS_NAMED("OrderPayer")
@interface PPCOrderPayer : NSObject
/// The name of the payer. Supports only the <code>given_name</code> and <code>surname</code> properties.
@property (nonatomic, readonly, strong) PPCOrderPayerName * _Nullable name;
/// The email address of the payer.
@property (nonatomic, readonly, copy) NSString * _Nullable emailAddress;
/// The PayPal-assigned ID for the payer.
@property (nonatomic, readonly, copy) NSString * _Nullable payerId;
/// The phone number of the customer. Available only when you enable the Contact Telephone Number option
/// in the Profile & Settings for themerchant’s PayPal account. The <code>phone.phone_number</code> supports only <code>national_number</code>.
@property (nonatomic, readonly, strong) PPCOrderPayerPhone * _Nullable phone;
/// The birth date of the payer in YYYY-MM-DD format.
@property (nonatomic, readonly, copy) NSString * _Nullable birthDate;
/// The tax information of the payer. Required only for Brazilian payers. Both <code>tax_id</code> and <code>tax_id_type</code> are required.
@property (nonatomic, readonly, strong) PPCOrderPayerTaxInfo * _Nullable taxInfo;
/// The address of the payer. Supports only the <code>address_line_1</code>, <code>address_line_2</code>,
/// <code>admin_area_1</code>, <code>admin_area_2</code>, <code>postal_code</code>, and <code>country_code</code> properties.
/// Also referred to as the billing address of the customer.
@property (nonatomic, readonly, strong) PPCOrderAddress * _Nullable address;
- (nonnull instancetype)initWithName:(PPCOrderPayerName * _Nullable)name emailAddress:(NSString * _Nullable)emailAddress payerId:(NSString * _Nullable)payerId phone:(PPCOrderPayerPhone * _Nullable)phone birthDate:(NSString * _Nullable)birthDate taxInfo:(PPCOrderPayerTaxInfo * _Nullable)taxInfo address:(PPCOrderAddress * _Nullable)address OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


/// The name of the payer. Supports only the <code>given_name</code> and <code>surname</code> properties.
SWIFT_CLASS_NAMED("Name")
@interface PPCOrderPayerName : NSObject
/// When the party is a person, the party’s given, or first, name. Maximum length: 140.
@property (nonatomic, readonly, copy) NSString * _Nullable givenName;
/// When the party is a person, the party’s surname or family name. Also known as the last name.
/// Required when the party is a person. Use also to store multiple surnames including the matronymic, or mother’s, surname.
/// Maximum length: 140.
@property (nonatomic, readonly, copy) NSString * _Nullable surname;
- (nonnull instancetype)initGivenName:(NSString * _Nullable)givenName surname:(NSString * _Nullable)surname OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

enum PPCOrderPayerPhoneType : NSInteger;
@class PPCOrderPayerPhoneNumber;

/// The phone number of the customer. Available only when you enable the Contact Telephone Number option in the
/// Profile & Settings for the merchant’s PayPal account. The <code>phone.phone_number</code> supports only <code>national_number</code>.
SWIFT_CLASS_NAMED("Phone")
@interface PPCOrderPayerPhone : NSObject
/// The phone type.
@property (nonatomic, readonly) enum PPCOrderPayerPhoneType phoneType;
/// The phone number, in its canonical international
/// <a href="https://www.itu.int/rec/T-REC-E.164/en">E.164 numbering plan format.</a>
/// Supports only the national_number property.
@property (nonatomic, readonly, strong) PPCOrderPayerPhoneNumber * _Nonnull phoneNumber;
- (nonnull instancetype)initWithPhoneNumber:(PPCOrderPayerPhoneNumber * _Nonnull)phoneNumber phoneType:(enum PPCOrderPayerPhoneType)phoneType OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// The phone type.
typedef SWIFT_ENUM_NAMED(NSInteger, PPCOrderPayerPhoneType, "PhoneType", open) {
  PPCOrderPayerPhoneTypeNone = 0,
  PPCOrderPayerPhoneTypeFax = 1,
  PPCOrderPayerPhoneTypeHome = 2,
  PPCOrderPayerPhoneTypeMobile = 3,
  PPCOrderPayerPhoneTypeOther = 4,
  PPCOrderPayerPhoneTypePager = 5,
};


/// The phone number, in its canonical international <a href="https://www.itu.int/rec/T-REC-E.164/en">E.164 numbering plan format.</a>
/// Supports only the national_number property.
SWIFT_CLASS_NAMED("PhoneNumber")
@interface PPCOrderPayerPhoneNumber : NSObject
/// The national number, in its canonical international E.164 numbering plan format.
/// The combined length of the country calling code (CC) and the national number must not be greater than 15 digits.
/// The national number consists of a national destination code (NDC) and subscriber number (SN).
/// <ul>
///   <li>
///     Minimum length: 1
///   </li>
///   <li>
///     Maximum length: 14
///   </li>
///   <li>
///     Pattern: ^[0-9]{1,14}?$
///   </li>
/// </ul>
@property (nonatomic, readonly, copy) NSString * _Nonnull nationalNumber;
- (nonnull instancetype)initWithNationalNumber:(NSString * _Nonnull)nationalNumber OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

enum PPCOrderPayerTaxIdType : NSInteger;

/// The tax information of the payer. Required only for Brazilian payer’s. Both <code>tax_id</code> and <code>tax_id_type</code> are required.
SWIFT_CLASS_NAMED("TaxInfo")
@interface PPCOrderPayerTaxInfo : NSObject
/// The customer’s tax ID. Supported for the PayPal payment method only. Typically, the tax ID is 11 characters long
/// for individuals and 14 characters long for businesses.
/// <ul>
///   <li>
///     Maximum length: 14
///   </li>
/// </ul>
@property (nonatomic, readonly, copy) NSString * _Nonnull taxId;
/// The customer’s tax ID type. Supported for the PayPal payment method only.
@property (nonatomic, readonly) enum PPCOrderPayerTaxIdType taxIdType;
- (nonnull instancetype)initWithTaxId:(NSString * _Nonnull)taxId taxIdType:(enum PPCOrderPayerTaxIdType)taxIdType OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// The type of the Tax ID
typedef SWIFT_ENUM_NAMED(NSInteger, PPCOrderPayerTaxIdType, "TaxIdType", open) {
/// BR_CPF. The individual tax ID type.
  PPCOrderPayerTaxIdTypeIndividual = 0,
/// BR_CNPJ. The business tax ID type.
  PPCOrderPayerTaxIdTypeBuisness = 1,
};

enum PPCOrderProcessingInstruction : NSInteger;

/// The order request object is used to format the <code>orderRequest</code> for the <code>CreateOrderAction</code>
/// <a href="https://developer.paypal.com/docs/api/orders/v2/#orders_create">Create order documentation</a>
/// note:
/// This class is for use exclusively with the order v2 API
SWIFT_CLASS_NAMED("OrderRequest")
@interface PPCOrderRequest : NSObject
/// The intent to either capture payment immediately or authorize a payment for an order after order creation.
@property (nonatomic, readonly) enum PPCOrderIntent intent;
/// The customer who approves and pays for the order. The customer is also known as the payer.
@property (nonatomic, readonly, strong) PPCOrderPayer * _Nullable payer;
/// An array of purchase units. Each purchase unit establishes a contract between a payer and the payee.
/// Each purchase unit represents either a full or partial order that the payer intends to purchase from the payee.
@property (nonatomic, readonly, copy) NSArray<PPCPurchaseUnit *> * _Nonnull purchaseUnits;
/// Customize the payer experience during the approval process for the payment with PayPal.
@property (nonatomic, readonly, strong) PPCOrderApplicationContext * _Nullable applicationContext;
- (nonnull instancetype)initWithIntent:(enum PPCOrderIntent)intent purchaseUnits:(NSArray<PPCPurchaseUnit *> * _Nonnull)purchaseUnits processingInstruction:(enum PPCOrderProcessingInstruction)processingInstruction payer:(PPCOrderPayer * _Nullable)payer applicationContext:(PPCOrderApplicationContext * _Nullable)applicationContext OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


/// A successful request returns the HTTP 204 No Content status code with an empty object in the JSON response body.
SWIFT_CLASS_NAMED("PatchActionSuccess")
@interface PPCPatchActionSuccess : NSObject
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

@class PPCPurchaseUnitShippingName;
@class PPCShippingMethod;
@class PPCPurchaseUnitAmount;

/// Represents each operation and their accepted path, as well as the paths accepted value for each type.
/// <a href="https://developer.paypal.com/docs/api/orders/v2#orders_patch">Patch Order Documentation</a>
/// note:
///
/// <ul>
///   <li>
///     To make an update, you may optionally provide a <code>reference_id</code>. If you omit a <code>reference_id</code>,
///     PayPal defaults to a <code>reference_id</code> of <code>default</code>.
///   </li>
/// </ul>
SWIFT_CLASS_NAMED("PatchRequest")
@interface PPCPatchRequest : NSObject
/// Adds a <code>shippingName</code> to the order request.
/// \param shippingName The name of the person to whom to ship the items. Supports only the <code>full_name</code> property.
///
/// \param referenceId The API caller-provided external ID for the purchase unit if more than one purchase unit was provided.
///
- (void)addWithShippingName:(PPCPurchaseUnitShippingName * _Nonnull)shippingName referenceId:(NSString * _Nullable)referenceId;
/// Adds a <code>shippingAddress</code> to the order request.
/// \param shippingAddress The address of the person to whom to ship the items.
///
/// \param referenceId The API caller-provided external ID for the purchase unit if more than one purchase unit was provided.
///
- (void)addWithShippingAddress:(PPCOrderAddress * _Nonnull)shippingAddress referenceId:(NSString * _Nullable)referenceId;
/// Adds <code>shippingOptions</code> to the order request
/// \param shippingOptions A list of shipping options for the order.
///
/// \param referenceId The API caller-provided external ID for the purchase unit if more than one purchase unit was provided.
///
- (void)addWithShippingOptions:(NSArray<PPCShippingMethod *> * _Nonnull)shippingOptions referenceId:(NSString * _Nullable)referenceId;
/// Replaces the <code>shippingName</code> of the order request.
/// \param shippingName The name of the person to whom to ship the items. Supports only the <code>full_name</code> property.
///
/// \param referenceId The API caller-provided external ID for the purchase unit if more than one purchase unit was provided.
///
- (void)replaceWithShippingName:(PPCPurchaseUnitShippingName * _Nonnull)shippingName referenceId:(NSString * _Nullable)referenceId;
/// Replaces the <code>shippingAddress</code> of the order request.
/// \param shippingAddress The address of the person to whom to ship the items.
///
/// \param referenceId The API caller-provided external ID for the purchase unit if more than one purchase unit was provided.
///
- (void)replaceWithShippingAddress:(PPCOrderAddress * _Nonnull)shippingAddress referenceId:(NSString * _Nullable)referenceId;
/// Replaces the <code>shippingOptions</code> of the order request.
/// \param shippingOptions A list of shipping options for the order.
///
/// \param referenceId The API caller-provided external ID for the purchase unit if more than one purchase unit was provided.
///
- (void)replaceWithShippingOptions:(NSArray<PPCShippingMethod *> * _Nonnull)shippingOptions referenceId:(NSString * _Nullable)referenceId;
/// Replaces the <code>amount</code> of the order request.
/// \param amount The total order amount with an optional breakdown that provides details, such as the total item
/// amount, total tax amount, shipping, handling, insurance, and discounts, if any.
///
/// \param referenceId The API caller-provided external ID for the purchase unit if more than one purchase unit was provided.
///
- (void)replaceWithAmount:(PPCPurchaseUnitAmount * _Nonnull)amount referenceId:(NSString * _Nullable)referenceId;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

enum PPCPayPalPayLaterButtonColor : NSInteger;
@class PPCPaymentButtonAttributes;

/// Configuration for Pay Later Smart Payment Button.
/// \param color Defines the colors available for PayPal buttons, see <code>PayPalButtonColor</code>.
///
/// \param attributes Defines different attributes to configure shape and size of Pay Later button, see <code>ButtonAttributes</code>.
///
SWIFT_CLASS_NAMED("PayLaterButtonUIConfiguration")
@interface PPCPayLaterButtonUIConfiguration : NSObject
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)initWithColor:(enum PPCPayPalPayLaterButtonColor)color attributes:(PPCPaymentButtonAttributes * _Nonnull)attributes OBJC_DESIGNATED_INITIALIZER;
@end

enum PPCPaymentButtonFundingSource : NSInteger;
enum PPCPaymentButtonColor : NSInteger;
enum PPCPaymentButtonEdges : NSInteger;
enum PPCPaymentButtonSize : NSInteger;

/// The <code>PaymentButton</code> is utilized to provide a seamless integration for a checkout
/// experience similar to how the web handles PayPal checkout experiences.
SWIFT_CLASS_NAMED("PaymentButton") SWIFT_DEPRECATED_MSG("Use PaymentButtonContainer() instead.")
@interface PPCPaymentButton : UIButton
@property (nonatomic, getter=isHighlighted) BOOL highlighted;
- (void)checkoutFinished;
/// The type of the button’s funding source (e.g. PayPal, Pay Later, Credit)
@property (nonatomic, readonly) enum PPCPaymentButtonFundingSource fundingSource;
/// The color of the button
@property (nonatomic) enum PPCPaymentButtonColor color;
/// The corners of the button and how they should be shaped.
@property (nonatomic) enum PPCPaymentButtonEdges edges;
/// The size enum determines how the button will be shown.
@property (nonatomic) enum PPCPaymentButtonSize size;
@property (nonatomic, getter=isEnabled) BOOL enabled;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)coder SWIFT_UNAVAILABLE;
- (void)layoutSubviews;
- (nonnull instancetype)initWithFrame:(CGRect)frame SWIFT_UNAVAILABLE;
@end

enum PPCPayPalButtonColor : NSInteger;
enum PPCPayPalButtonLabel : NSInteger;

/// PayPalButton provides a PayPal button with the ability to modify color, edges, size, insets and label.
/// Tapping on PayPalButton will start checkout with Native Checkout SDK Paysheet.
SWIFT_CLASS_NAMED("PayPalButton") SWIFT_DEPRECATED_MSG("Use PaymentButtonContainer() instead.")
@interface PPCPayPalButton : PPCPaymentButton
/// Initialize a PayPalButton
/// \param insets Edge insets of the button, defining the spacing of the button’s edges relative to its content.
///
/// \param color Color of the button. Default to gold if not provided.
///
/// \param edges Edges of the button. Default to softEdges if not provided.
///
/// \param size Size of the button. Default to collapsed if not provided.
///
/// \param label Label displayed next to the button’s logo. Default to no label.
///
- (nonnull instancetype)initWithInsets:(NSDirectionalEdgeInsets)insets color:(enum PPCPayPalButtonColor)color edges:(enum PPCPaymentButtonEdges)edges size:(enum PPCPaymentButtonSize)size label:(enum PPCPayPalButtonLabel)label isEnabled:(BOOL)isEnabled SWIFT_DEPRECATED_MSG("Use PaymentButtonContainer() instead.");
/// Initialize a PayPalButton. The insets of the button will be set appropriately depending on the button’s size.
/// \param color Color of the button. Default to gold if not provided.
///
/// \param edges Edges of the button. Default to softEdges if not provided.
///
/// \param size Size of the button. Default to collapsed if not provided.
///
/// \param label Label displayed next to the button’s logo. Default to no label.
///
- (nonnull instancetype)initWithColor:(enum PPCPayPalButtonColor)color edges:(enum PPCPaymentButtonEdges)edges size:(enum PPCPaymentButtonSize)size label:(enum PPCPayPalButtonLabel)label isEnabled:(BOOL)isEnabled SWIFT_DEPRECATED_MSG("Use PaymentButtonContainer() instead.");
@end

/// Available colors for PayPalButton.
typedef SWIFT_ENUM_NAMED(NSInteger, PPCPayPalButtonColor, "Color", open) {
  PPCPayPalButtonColorGold = 0,
  PPCPayPalButtonColorWhite = 1,
  PPCPayPalButtonColorBlack = 2,
  PPCPayPalButtonColorSilver = 3,
  PPCPayPalButtonColorBlue = 4,
};

/// Available labels for PayPalButton.
typedef SWIFT_ENUM_NAMED(NSInteger, PPCPayPalButtonLabel, "Label", open) {
/// Display no label
  PPCPayPalButtonLabelNone = -1,
/// Display “Checkout” on the right side of the button’s logo
  PPCPayPalButtonLabelCheckout = 0,
/// Display “Buy now” on the right side of the button’s logo
  PPCPayPalButtonLabelBuyNow = 1,
/// Display “Pay with” on the left side of the button’s logo
  PPCPayPalButtonLabelPayWith = 2,
};


/// Configuration for PayPal Smart Payment Button.
/// \param color Defines the colors available for PayPal buttons, see <code>PayPalButtonColor</code>.
///
/// \param label Defines the labels available for payment buttons. If no label is provided then it will
/// default to <code>PAYPAL</code>, which will default to no label and only displaying the PayPal wordmark. For
/// other labels they will have the label value itself along with a position either at the start or
/// the end of the button, see <code>PayPalButtonLabel</code>.
///
/// \param attributes Defines different attributes to configure shape and size of PayPal button, see <code>ButtonAttributes</code>.
///
SWIFT_CLASS_NAMED("PayPalButtonUIConfiguration")
@interface PPCPayPalButtonUIConfiguration : NSObject
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)initWithColor:(enum PPCPayPalButtonColor)color label:(enum PPCPayPalButtonLabel)label attributes:(PPCPaymentButtonAttributes * _Nonnull)attributes OBJC_DESIGNATED_INITIALIZER;
@end

enum PPCPayPalCreditButtonColor : NSInteger;

/// PayPalCreditButton provides a PayPal Credit button with the ability to modify color, edges, size and insets.
/// Tapping on PayPalCreditButton will bring users to checkout with PayPalCredit on web.
SWIFT_CLASS_NAMED("PayPalCreditButton") SWIFT_DEPRECATED_MSG("Use PaymentButtonContainer() instead.")
@interface PPCPayPalCreditButton : PPCPaymentButton
/// Initialize a PayPalCreditButton
/// \param insets Edge insets of the button, defining the spacing of the button’s edges relative to its content.
///
/// \param color Color of the button. Default to dark blue if not provided.
///
/// \param edges Edges of the button. Default to softEdges if not provided.
///
/// \param size Size of the button. Default to collapsed if not provided.
///
- (nonnull instancetype)initWithInsets:(NSDirectionalEdgeInsets)insets color:(enum PPCPayPalCreditButtonColor)color edges:(enum PPCPaymentButtonEdges)edges size:(enum PPCPaymentButtonSize)size isEnabled:(BOOL)isEnabled SWIFT_DEPRECATED_MSG("Use PaymentButtonContainer() instead.");
/// Initialize a PayPalCreditButton. The insets of the button will be set appropriately depending on the button’s size.
/// \param color Color of the button. Default to dark blue if not provided.
///
/// \param edges Edges of the button. Default to softEdges if not provided.
///
/// \param size Size of the button. Default to collapsed if not provided.
///
- (nonnull instancetype)initWithColor:(enum PPCPayPalCreditButtonColor)color edges:(enum PPCPaymentButtonEdges)edges size:(enum PPCPaymentButtonSize)size isEnabled:(BOOL)isEnabled SWIFT_DEPRECATED_MSG("Use PaymentButtonContainer() instead.");
@end

/// Available colors for PayPalCreditButton.
typedef SWIFT_ENUM_NAMED(NSInteger, PPCPayPalCreditButtonColor, "Color", open) {
  PPCPayPalCreditButtonColorWhite = 1,
  PPCPayPalCreditButtonColorBlack = 2,
  PPCPayPalCreditButtonColorDarkBlue = 5,
};


/// Configuration for PayPal Credit Smart Payment Button.
/// \param color Defines the colors available for PayPal Credit button, see <code>PayPalCreditButtonColor</code>.
///
/// \param attributes Defines different attributes to configure shape and size of PayPal Credit button, see <code>ButtonAttributes</code>.
///
SWIFT_CLASS_NAMED("PayPalCreditButtonUIConfiguration")
@interface PPCPayPalCreditButtonUIConfiguration : NSObject
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)initWithColor:(enum PPCPayPalCreditButtonColor)color attributes:(PPCPaymentButtonAttributes * _Nonnull)attributes OBJC_DESIGNATED_INITIALIZER;
@end


/// PayPalPayLaterButton provides a Pay in 4 with PayPal button with the ability to modify color, edges, size and insets.
/// Tapping on PayPalPayLaterButton will bring users to checkout with Pay in 4 on web, where users can apply for and pay with Pay in 4.
SWIFT_CLASS_NAMED("PayPalPayLaterButton") SWIFT_DEPRECATED_MSG("Use PaymentButtonContainer() instead.")
@interface PPCPayPalPayLaterButton : PPCPaymentButton
/// Initialize a PayPalPayLaterButton
/// \param insets Edge insets of the button, defining the spacing of the button’s edges relative to its content.
///
/// \param color Color of the button. Default to gold if not provided.
///
/// \param edges Edges of the button. Default to softEdges if not provided.
///
/// \param size Size of the button. Default to collapsed if not provided.
///
- (nonnull instancetype)initWithInsets:(NSDirectionalEdgeInsets)insets color:(enum PPCPayPalPayLaterButtonColor)color edges:(enum PPCPaymentButtonEdges)edges size:(enum PPCPaymentButtonSize)size isEnabled:(BOOL)isEnabled SWIFT_DEPRECATED_MSG("Use PaymentButtonContainer() instead.");
/// Initialize a PayPalPayLaterButton. The insets of the button will be set appropriately depending on the button’s size.
/// \param color Color of the button. Default to gold if not provided.
///
/// \param edges Edges of the button. Default to softEdges if not provided.
///
/// \param size Size of the button. Default to collapsed if not provided.
///
- (nonnull instancetype)initWithColor:(enum PPCPayPalPayLaterButtonColor)color edges:(enum PPCPaymentButtonEdges)edges size:(enum PPCPaymentButtonSize)size isEnabled:(BOOL)isEnabled SWIFT_DEPRECATED_MSG("Use PaymentButtonContainer() instead.");
@end

/// Available colors for PayPalPayLaterButton.
typedef SWIFT_ENUM_NAMED(NSInteger, PPCPayPalPayLaterButtonColor, "Color", open) {
  PPCPayPalPayLaterButtonColorGold = 0,
  PPCPayPalPayLaterButtonColorWhite = 1,
  PPCPayPalPayLaterButtonColorBlack = 2,
  PPCPayPalPayLaterButtonColorSilver = 3,
  PPCPayPalPayLaterButtonColorBlue = 4,
};



/// These are different attributes to configure the native Smart Payment Button style.
/// \param edges Defines the edge available for payment buttons. If no edge is provided then the default
/// button style will be retrieved from the applications root style, see <code>PaymentButtonSize</code>.
///
/// \param size Defines the sizes available for payment buttons. If no size is provided then it will
/// default to medium. Button size is used for setting properties like minimum width and height to
/// allow for the use of wrap_content where necessary along with modifying the size of the wordmark
/// and adjusting padding within the button, see <code>PaymentButtonSize</code>.
///
/// \param isEnabled Is a flag set by the merchant to control whether to show or hide the native Smart Payment Button.
/// if native Smart Payment Button is ineligible we will ignore this flag and we will not show the button.
///
SWIFT_CLASS_NAMED("PaymentButtonAttributes")
@interface PPCPaymentButtonAttributes : NSObject
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)initWithEdges:(enum PPCPaymentButtonEdges)edges size:(enum PPCPaymentButtonSize)size isEnabled:(BOOL)isEnabled OBJC_DESIGNATED_INITIALIZER;
@end

/// The Smart Payment Button type, this will adjust our images, colors, sizes, etc.
typedef SWIFT_ENUM_NAMED(NSInteger, PPCPaymentButtonColor, "PaymentButtonColor", open) {
/// The gold background and blue wordmark, monogram, and black text.
  PPCPaymentButtonColorGold = 0,
/// The white background and blue wordmark, monogram, and black text.
  PPCPaymentButtonColorWhite = 1,
/// The black background and monochrome wordmark, monogram, and white text.
  PPCPaymentButtonColorBlack = 2,
/// The silver background and blue wordmark, monogram, and black text.
  PPCPaymentButtonColorSilver = 3,
/// The blue background and white wordmark, blue monogram, and white text.
  PPCPaymentButtonColorBlue = 4,
/// The dark blue background with PayPal Credit wordmark and monogram.
  PPCPaymentButtonColorDarkBlue = 5,
};

@protocol PPCPaymentButtonContainerDelegate;
enum PPCPaymentButtonEligibilityStatus : NSInteger;

/// A container UI element that groups all the PayPal buttons (PayPal, PayLater, Credit).
/// PaymentButtonContainer provides PayPal buttons with the ability to
/// modify the PayPalButtonUI, PayPalCreditButtonUI, and PayLaterButtonUI, their attributes,
/// and implement the PaymentButtonContainerDelegate
SWIFT_CLASS_NAMED("PaymentButtonContainer")
@interface PPCPaymentButtonContainer : UIView
/// Returns a container that includes a single PayPal button only.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) PPCPaymentButtonContainer * _Nonnull withPayPalButtonOnly;)
+ (PPCPaymentButtonContainer * _Nonnull)withPayPalButtonOnly SWIFT_WARN_UNUSED_RESULT;
/// A closure provided to create an order based on an action item.
@property (nonatomic, copy) void (^ _Nullable createOrder)(PPCCreateOrderAction * _Nonnull);
/// A closure that gets executed when Checkout was approved.
@property (nonatomic, copy) void (^ _Nullable onApproval)(PPCApproval * _Nonnull);
/// A closure that gets executed when Checkout was cancelled.
@property (nonatomic, copy) void (^ _Nullable onCancel)(void);
/// A closure that gets executed when Checkout fails.
@property (nonatomic, copy) void (^ _Nullable onError)(PPCErrorInfo * _Nonnull);
/// A closure that gets executed when shipping was changed.
@property (nonatomic, copy) void (^ _Nullable onShippingChange)(PPCShippingChange * _Nonnull, PPCShippingChangeAction * _Nonnull);
/// Initializer to configure the container button
/// \param payPalButtonUI Setup ui of PayPal button
///
/// \param payPalCreditButtonUI Setup ui of PayPal Credit button
///
/// \param payLaterButtonUI Setup ui of Pay Later button
///
/// \param delegate provide some lifecycles methods to be called.
///
- (nonnull instancetype)initWithPayPalButtonUIConfiguration:(PPCPayPalButtonUIConfiguration * _Nonnull)payPalButtonUIConfiguration payPalCreditButtonUIConfiguration:(PPCPayPalCreditButtonUIConfiguration * _Nonnull)payPalCreditButtonUIConfiguration payLaterButtonUIConfiguration:(PPCPayLaterButtonUIConfiguration * _Nonnull)payLaterButtonUIConfiguration delegate:(id <PPCPaymentButtonContainerDelegate> _Nullable)delegate OBJC_DESIGNATED_INITIALIZER;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)coder SWIFT_UNAVAILABLE;
/// Configures the callback closures.
/// \param createOrder Callback to either supply an order token or order details to the Checkout SDK.
///
/// \param onApproval This will be called when the transaction has been approved.
///
/// \param onCancel This will be called when transaction has been cancelled.
///
/// \param onError This will be called when an error cannot be recovered from, and the transaction has been cancelled.
///
/// \param onShippingChange This will be called when the user selects a new shipping address or shipping method.
///
- (void)setupWithCreateOrder:(void (^ _Nullable)(PPCCreateOrderAction * _Nonnull))createOrder onApproval:(void (^ _Nullable)(PPCApproval * _Nonnull))onApproval onCancel:(void (^ _Nullable)(void))onCancel onError:(void (^ _Nullable)(PPCErrorInfo * _Nonnull))onError onShippingChange:(void (^ _Nullable)(PPCShippingChange * _Nonnull, PPCShippingChangeAction * _Nonnull))onShippingChange;
/// Update payPalButtonUI the attributes programmatically and override the values.
/// \param configuration Instance to update the payPalButtonUI
///
- (void)configurePayPalButtonWith:(PPCPayPalButtonUIConfiguration * _Nonnull)configuration;
/// Update payPalCreditButtonUI the attributes programmatically and override the values.
/// \param configuration Instance to update the payPalCreditButtonUI
///
- (void)configurePayPalCreditButtonWith:(PPCPayPalCreditButtonUIConfiguration * _Nonnull)configuration;
/// Update payLaterButtonUI the attributes programmatically and override the values.
/// \param configuration Instance to update the payLaterButtonUI
///
- (void)configurePayLaterButtonWith:(PPCPayLaterButtonUIConfiguration * _Nonnull)configuration;
- (void)onButtonStart:(PPCPaymentButton * _Nonnull)button;
- (void)onButtonFinish:(PPCPaymentButton * _Nonnull)button;
- (void)button:(PPCPaymentButton * _Nonnull)button changedEligibilityStatus:(enum PPCPaymentButtonEligibilityStatus)status;
- (nonnull instancetype)initWithFrame:(CGRect)frame SWIFT_UNAVAILABLE;
@end

@class PPCPaymentFundingEligibilityState;

/// PaymentButtonContainerDelegate for managing native Smart Payment Button container eligibility and ui status
SWIFT_PROTOCOL_NAMED("PaymentButtonContainerDelegate")
@protocol PPCPaymentButtonContainerDelegate
/// This function will be invoked as soon as the eligibility call is triggered and PaymentButtonContainer view starts loading.
- (void)onLoading;
/// This function will be invoked as soon as the eligibility call is triggered and PaymentButtonContainer view is finished.
/// \param fundingEligibilityState Contains information about each one of the native smart payments button
/// [PAYPAL], [PAYPAL_CREDIT] or [PAY_LATER] and whether the button is eligible or not
/// indication for which button is eligible.
///
- (void)onFinishWithFundingEligibilityState:(PPCPaymentFundingEligibilityState * _Nonnull)fundingEligibilityState;
@end

/// Edges for the Smart Payment Button, these affect the corner radius.
typedef SWIFT_ENUM_NAMED(NSInteger, PPCPaymentButtonEdges, "PaymentButtonEdges", open) {
/// Hard edges on button with 0 corner radius.
  PPCPaymentButtonEdgesHardEdges = 0,
/// Soft edges with a corner radius of 4 pts.
  PPCPaymentButtonEdgesSoftEdges = 1,
/// Pill shaped corner radius.
  PPCPaymentButtonEdgesRounded = 2,
};

/// Status of PaymentButton’s eligibility
typedef SWIFT_ENUM_NAMED(NSInteger, PPCPaymentButtonEligibilityStatus, "PaymentButtonEligibilityStatus", open) {
/// Button’s eligibility check is in progress
  PPCPaymentButtonEligibilityStatusLoading = 0,
/// Button’s eligibility check is finished and button is eligible
  PPCPaymentButtonEligibilityStatusEligible = 1,
/// Button’s eligibility check is finished and button is not eligible
  PPCPaymentButtonEligibilityStatusIneligible = 2,
/// Button’s eligibility check failed
  PPCPaymentButtonEligibilityStatusError = 3,
};

/// The funding source to be used when checkout with PaymentButton
typedef SWIFT_ENUM_NAMED(NSInteger, PPCPaymentButtonFundingSource, "PaymentButtonFundingSource", open) {
  PPCPaymentButtonFundingSourcePayPal = 0,
  PPCPaymentButtonFundingSourcePayLater = 1,
  PPCPaymentButtonFundingSourceCredit = 2,
};

/// The label displayed next to PaymentButton’s logo.
typedef SWIFT_ENUM_NAMED(NSInteger, PPCPaymentButtonLabel, "PaymentButtonLabel", open) {
/// Add “Checkout” to the right of button’s logo
  PPCPaymentButtonLabelCheckout = 0,
/// Add “Buy Now” to the right of button’s logo
  PPCPaymentButtonLabelBuyNow = 1,
/// Add “Pay with” to the left of button’s logo
  PPCPaymentButtonLabelPayWith = 2,
/// Add “Pay later” to the right of button’s logo, only used for PayPalPayLaterButton
  PPCPaymentButtonLabelPayLater = 3,
};

/// The size category which determines how the button is shown.
typedef SWIFT_ENUM_NAMED(NSInteger, PPCPaymentButtonSize, "PaymentButtonSize", open) {
/// Circle shaped button similar to a floating action button will show the monogram, if <code>.venmo</code> then will show <code>Venmo</code> logo.
  PPCPaymentButtonSizeMini = 0,
/// Collapsed will only show the wordmark.
  PPCPaymentButtonSizeCollapsed = 1,
/// Expanded shows the wordmark along with the suffix.
  PPCPaymentButtonSizeExpanded = 2,
/// Full will show the wordmark along with the prefix and suffix.
  PPCPaymentButtonSizeFull = 3,
};


/// PaymentFundingEligibilityState is a model to provide the eligibility response for each Funding
/// Each funding will have the reasons for eligibility/ineligibility
SWIFT_CLASS_NAMED("PaymentFundingEligibilityState")
@interface PPCPaymentFundingEligibilityState : NSObject
/// If the response has failed or received any kind of error.
@property (nonatomic, readonly) NSError * _Nullable error;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// An enum of the possible values to be passed as the instruction to process an order.
/// Possible vales are: <code>ORDER_SAVED_EXPLICITLY</code>, <code>ORDER_SAVED_ON_BUYER_APPROVAL</code>, <code>ORDER_COMPLETE_ON_PAYMENT_APPROVAL</code>, <code>NO_INSTRUCTION</code>
/// <a href="https://developer.paypal.com/docs/limited-release/orders/v2/api/#orders_create">Processing instruction enum documentation guide</a>
typedef SWIFT_ENUM_NAMED(NSInteger, PPCOrderProcessingInstruction, "ProcessingInstruction", open) {
  PPCOrderProcessingInstructionNone = 0,
/// The API caller saves the order for future payment processing by making an explicit v2/checkout/orders/id/save call after the payer approves the order.
  PPCOrderProcessingInstructionOrderSavedExplicitly = 1,
/// PayPal implicitly saves the order on behalf of the API caller after the payer approves the order. Note that this option is not currently supported.
  PPCOrderProcessingInstructionOrderSavedOnBuyerApproval = 2,
/// API Caller expects the Order to be auto completed (i.e. for PayPal to authorize or capture depending on the intent) on completion of payer approval.
/// This option is not relevant for payment_source that typically do not require a payer approval or interaction. This option is currently only available
/// for the following payment_source: Alipay, Bancontact, BLIK, eps, giropay, Multibanco, MyBank, P24, PayU, POLi, Sofort, Trustly, TrustPay,
/// Verkkopankki, WeChat Pay
  PPCOrderProcessingInstructionOrderCompleteOnPaymentApproval = 3,
/// The API caller intends to authorize v2/checkout/orders/id/authorize or capture v2/checkout/orders/id/capture after the payer approves the order.
  PPCOrderProcessingInstructionNoInstruction = 4,
};


SWIFT_CLASS("_TtC14PayPalCheckout18ProfileImageBubble")
@interface ProfileImageBubble : UIImageView
- (nonnull instancetype)initWithFrame:(CGRect)frame SWIFT_UNAVAILABLE;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)aDecoder SWIFT_UNAVAILABLE;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
- (void)traitCollectionDidChange:(UITraitCollection * _Nullable)previousTraitCollection;
- (nonnull instancetype)initWithImage:(UIImage * _Nullable)image SWIFT_UNAVAILABLE;
- (nonnull instancetype)initWithImage:(UIImage * _Nullable)image highlightedImage:(UIImage * _Nullable)highlightedImage SWIFT_UNAVAILABLE;
@end

@class PPCPurchaseUnitPayee;
@class PPCPurchaseUnitPaymentInstruction;
@class PPCPurchaseUnitItem;
@class PPCPurchaseUnitShipping;

/// A class that represents the possible values to be passed as part of the purchase unit object.
/// <a href="https://developer.paypal.com/docs/api/orders/v2/#definition-purchase_unit_request">Purchase units request documentation guide</a>
SWIFT_CLASS_NAMED("PurchaseUnit")
@interface PPCPurchaseUnit : NSObject
/// The API caller-provided external ID for the purchase unit.
/// If you omit this value and the order contains only one purchase unit, PayPal sets this value to <code>default</code>. Maximum length: 256.
@property (nonatomic, readonly, copy) NSString * _Nullable referenceId;
/// The total order amount with an optional breakdown that provides details,
/// such as the total item amount, total tax amount, shipping, handling, insurance, and discounts, if any.
/// If you specify amount.breakdown, the amount equals item_total plus tax_total plus shipping plus handling plus
/// insurance minus shipping_discount minus discount. The amount must be a positive number.
@property (nonatomic, readonly, strong) PPCPurchaseUnitAmount * _Nonnull amount;
/// The merchant who receives payment for this transaction.
@property (nonatomic, readonly, strong) PPCPurchaseUnitPayee * _Nullable payee;
/// Any additional payment instructions for PayPal Commerce Platform customers.
/// Enables features for the PayPal Commerce Platform, such as delayed disbursement and collection of a platform fee.
/// Applies during order creation for captured payments or during capture of authorized payments.
@property (nonatomic, readonly, strong) PPCPurchaseUnitPaymentInstruction * _Nullable paymentInstruction;
/// The purchase description. Maximum length: 127.
@property (nonatomic, readonly, copy) NSString * _Nullable purchaseUnitDescription;
/// The API caller-provided external ID. Used to reconcile client transactions with PayPal transactions.
/// Appears in transaction and settlement reports but is not visible to the payer. Maximum length: 127.
@property (nonatomic, readonly, copy) NSString * _Nullable customId;
/// The API caller-provided external invoice number for this order.
/// Appears in both the payer’s transaction history and the emails that the payer receives. Maximum length: 127.
@property (nonatomic, readonly, copy) NSString * _Nullable invoiceId;
/// The soft descriptor is the dynamic text used to construct the
/// statement descriptor that appears on a payer’s card statement. Maximum length: 22.
/// Full requirements can be found in the API documentation for <a href="https://developer.paypal.com/docs/api/orders/v2/#definition-purchase_unit_request">purchase
/// unit</a>
@property (nonatomic, readonly, copy) NSString * _Nullable softDescriptor;
/// An array of items that the customer purchases from the merchant.
@property (nonatomic, readonly, copy) NSArray<PPCPurchaseUnitItem *> * _Nullable items;
/// The name and address of the person to whom to ship the items.
@property (nonatomic, readonly, strong) PPCPurchaseUnitShipping * _Nullable shipping;
- (nonnull instancetype)initWithAmount:(PPCPurchaseUnitAmount * _Nonnull)amount referenceId:(NSString * _Nullable)referenceId payee:(PPCPurchaseUnitPayee * _Nullable)payee paymentInstruction:(PPCPurchaseUnitPaymentInstruction * _Nullable)paymentInstruction purchaseUnitDescription:(NSString * _Nullable)purchaseUnitDescription customId:(NSString * _Nullable)customId invoiceId:(NSString * _Nullable)invoiceId softDescriptor:(NSString * _Nullable)softDescriptor items:(NSArray<PPCPurchaseUnitItem *> * _Nullable)items shipping:(PPCPurchaseUnitShipping * _Nullable)shipping OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@class PPCPurchaseUnitBreakdown;

/// The total order amount with an optional breakdown that provides details,
/// such as the total item amount, total tax amount, shipping, handling, insurance, and discounts, if any.
/// If you specify amount.breakdown, the amount equals item_total plus tax_total plus shipping plus handling plus
/// insurance minus shipping_discount minus discount. The amount must be a positive number.
SWIFT_CLASS_NAMED("Amount")
@interface PPCPurchaseUnitAmount : NSObject
/// The <a href="https://developer.paypal.com/docs/api/reference/currency-codes/">three-character ISO-4217 currency code</a>
/// that identifies the currency.
@property (nonatomic, readonly) enum PPCCurrencyCode currencyCode;
/// The value, which might be:
/// An integer for currencies like JPY that are not typically fractional.
/// A decimal fraction for currencies like TND that are subdivided into thousandths.
/// <ul>
///   <li>
///     Maximum length: 32.
///   </li>
///   <li>
///     Pattern: ^((-?[0-9]+)|(-?([0-9]+)?[.][0-9]+))$
///   </li>
/// </ul>
@property (nonatomic, readonly, copy) NSString * _Nonnull value;
/// The breakdown of the amount. Breakdown provides details such as total item amount,
/// total tax amount, shipping, handling, insurance, and discounts, if any.
@property (nonatomic, readonly, strong) PPCPurchaseUnitBreakdown * _Nullable breakdown;
- (nonnull instancetype)initWithCurrencyCode:(enum PPCCurrencyCode)currencyCode value:(NSString * _Nonnull)value breakdown:(PPCPurchaseUnitBreakdown * _Nullable)breakdown OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@class PPCUnitAmount;

/// The breakdown of the amount. Breakdown provides details such as total item amount,
/// total tax amount, shipping, handling, insurance, and discounts, if any.
SWIFT_CLASS_NAMED("Breakdown")
@interface PPCPurchaseUnitBreakdown : NSObject
/// The subtotal for all items. Required if the request includes <code>purchase_units[].items[].unit_amount</code>.
/// Must equal the sum of (<code>items[].unit_amount * items[].quantity</code>) for all items.
/// Can not be a negative number.
@property (nonatomic, readonly, strong) PPCUnitAmount * _Nullable itemTotal;
/// The shipping fee for all items within a given <code>PurchaseUnit</code>.
/// Can not be a negative number.
@property (nonatomic, readonly, strong) PPCUnitAmount * _Nullable shipping;
/// The handling fee for all items within a given <code>PurchaseUnit</code>.
/// Can not be a negative number.
@property (nonatomic, readonly, strong) PPCUnitAmount * _Nullable handling;
/// The total tax for all items. Required if the request includes <code>purchase_units.items.tax</code>.
/// Must equal the sum of (<code>items[].tax * items[].quantity</code>) for all items.
/// Can not be a negative number.
@property (nonatomic, readonly, strong) PPCUnitAmount * _Nullable taxTotal;
/// The insurance fee for all items within a given <code>PurchaseUnit</code>.
/// Can not be a negative number.
@property (nonatomic, readonly, strong) PPCUnitAmount * _Nullable insurance;
/// The shipping discount for all items within a given <code>PurchaseUnit</code>.
/// Can not be a negative number.
@property (nonatomic, readonly, strong) PPCUnitAmount * _Nullable shippingDiscount;
/// The discount for all items within a given <code>PurchaseUnit</code>.
/// Can not be a negative number.
@property (nonatomic, readonly, strong) PPCUnitAmount * _Nullable discount;
- (nonnull instancetype)initWithItemTotal:(PPCUnitAmount * _Nullable)itemTotal shipping:(PPCUnitAmount * _Nullable)shipping handling:(PPCUnitAmount * _Nullable)handling taxTotal:(PPCUnitAmount * _Nullable)taxTotal insurance:(PPCUnitAmount * _Nullable)insurance shippingDiscount:(PPCUnitAmount * _Nullable)shippingDiscount discount:(PPCUnitAmount * _Nullable)discount OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


/// The merchant who receives payment for this transaction.
SWIFT_CLASS_NAMED("Payee")
@interface PPCPurchaseUnitPayee : NSObject
/// The email address of merchant
@property (nonatomic, readonly, copy) NSString * _Nullable emailAddress;
/// The encrypted PayPal account ID of the merchant.
@property (nonatomic, readonly, copy) NSString * _Nullable merchantId;
- (nonnull instancetype)initWithEmailAddress:(NSString * _Nullable)emailAddress merchantId:(NSString * _Nullable)merchantId OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@class PPCPurchaseUnitPlatformFees;
enum PPCPurchaseUnitDisbursementMode : NSInteger;

/// Any additional payment instructions for PayPal Commerce Platform customers.
/// Enables features for the PayPal Commerce Platform, such as delayed disbursement and collection of a platform fee.
/// Applies during order creation for captured payments or during capture of authorized payments.
SWIFT_CLASS_NAMED("PaymentInstruction")
@interface PPCPurchaseUnitPaymentInstruction : NSObject
/// An array of various fees, commissions, tips, or donations.
@property (nonatomic, readonly, copy) NSArray<PPCPurchaseUnitPlatformFees *> * _Nullable platformFees;
/// The funds that are held on behalf of the merchant.
@property (nonatomic, readonly) enum PPCPurchaseUnitDisbursementMode disbursementMode;
- (nonnull instancetype)initWithPlatformFees:(NSArray<PPCPurchaseUnitPlatformFees *> * _Nullable)platformFees disbursementMode:(enum PPCPurchaseUnitDisbursementMode)disbursementMode OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


/// An array of various fees, commissions, tips, or donations.
SWIFT_CLASS_NAMED("PlatformFees")
@interface PPCPurchaseUnitPlatformFees : NSObject
/// The fee for this transaction
@property (nonatomic, readonly, strong) PPCPurchaseUnitAmount * _Nonnull amount;
/// The recipient of the fee for this transaction. If you omit this value, the default is the API caller.
@property (nonatomic, readonly, strong) PPCPurchaseUnitPayee * _Nullable payee;
- (nonnull instancetype)initWithAmount:(PPCPurchaseUnitAmount * _Nonnull)amount payee:(PPCPurchaseUnitPayee * _Nullable)payee OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// The funds that are held on behalf of the merchant.
typedef SWIFT_ENUM_NAMED(NSInteger, PPCPurchaseUnitDisbursementMode, "DisbursementMode", open) {
  PPCPurchaseUnitDisbursementModeNone = 0,
/// The funds are released to the merchant immediately.
  PPCPurchaseUnitDisbursementModeInstant = 1,
/// The funds are held for a finite number of days. The actual duration depends
/// on the region and type of integration. You can release the funds through a referenced
/// payout. Otherwise, the funds disbursed automatically after the specified duration.
  PPCPurchaseUnitDisbursementModeDelayed = 2,
};

@class PPCPurchaseUnitTax;
enum PPCPurchaseUnitCategory : NSInteger;

/// An array of items that the customer purchases from the merchant.
SWIFT_CLASS_NAMED("Item")
@interface PPCPurchaseUnitItem : NSObject
/// The item name or title. Minumum length: 1. Maximum length: 127
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
/// The item price or rate per unit. If you specify <code>unitAmount</code>, <code>purchase_units[].amount.breakdown.item_total</code>
/// is required. Must equal <code>unitAmount * quantity</code> for all items.
/// <code>unitAmount.value</code> can not be a negative number.
@property (nonatomic, readonly, strong) PPCUnitAmount * _Nonnull unitAmount;
/// The item tax for each unit. If tax is specified, <code>purchase_units[].amount.breakdown.tax_total</code> is required.
/// Must equal <code>tax * quantity</code> for all items. <code>tax.value</code> can not be a negative number.
@property (nonatomic, readonly, strong) PPCPurchaseUnitTax * _Nullable tax;
/// The item quantity. Must be a whole number. Maximum length: 10. Pattern: ^[1-9][0-9]{0,9}$.
@property (nonatomic, readonly, copy) NSString * _Nonnull quantity;
/// The detailed item description. Maximum length: 127.
@property (nonatomic, readonly, copy) NSString * _Nullable itemDescription;
/// The stock keeping unit (SKU) for the item. Maximum length: 127.
@property (nonatomic, readonly, copy) NSString * _Nullable sku;
/// The item category type.
@property (nonatomic, readonly) enum PPCPurchaseUnitCategory category;
- (nonnull instancetype)initWithName:(NSString * _Nonnull)name unitAmount:(PPCUnitAmount * _Nonnull)unitAmount quantity:(NSString * _Nonnull)quantity tax:(PPCPurchaseUnitTax * _Nullable)tax itemDescription:(NSString * _Nullable)itemDescription sku:(NSString * _Nullable)sku category:(enum PPCPurchaseUnitCategory)category OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


/// The item tax for each unit. If tax is specified, <code>purchase_units[].amount.breakdown.tax_total</code> is required.
/// Must equal <code>tax * quantity</code> for all items. <code>tax.value</code> can not be a negative number.
SWIFT_CLASS_NAMED("Tax")
@interface PPCPurchaseUnitTax : NSObject
/// The currency code that identifies the currency.
@property (nonatomic, readonly) enum PPCCurrencyCode currencyCode;
/// The value, which might be:
/// An integer for currencies like JPY that are not typically fractional.
/// A decimal fraction for currencies like TND that are subdivided into thousandths.
/// <ul>
///   <li>
///     Maximum length: 32.
///   </li>
///   <li>
///     Pattern: ^((-?[0-9]+)|(-?([0-9]+)?[.][0-9]+))$
///   </li>
/// </ul>
@property (nonatomic, readonly, copy) NSString * _Nonnull value;
- (nonnull instancetype)initWithCurrencyCode:(enum PPCCurrencyCode)currencyCode value:(NSString * _Nonnull)value OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// The item category type.
typedef SWIFT_ENUM_NAMED(NSInteger, PPCPurchaseUnitCategory, "Category", open) {
  PPCPurchaseUnitCategoryNone = 0,
/// Goods that are stored, delivered, and used in their electronic format.
/// This value is not currently supported for API callers that leverage the <a href="https://www.paypal.com/us/webapps/mpp/commerce-platform">PayPal for Commerce
/// Platform</a> product.
  PPCPurchaseUnitCategoryDigitalGoods = 1,
/// A tangible item that can be shipped with proof of delivery.
  PPCPurchaseUnitCategoryPhysicalGoods = 2,
};


/// The name and address of the person to whom to ship the items.
SWIFT_CLASS_NAMED("Shipping")
@interface PPCPurchaseUnitShipping : NSObject
/// The name of the person to whom to ship the items. Supports only the <code>full_name</code> property.
@property (nonatomic, readonly, strong) PPCPurchaseUnitShippingName * _Nullable shippingName;
/// The address of the person to whom to ship the items.
/// Supports only the <code>address_line_1</code>, <code>address_line_2</code>, <code>admin_area_1</code>, <code>admin_area_2</code>,
/// <code>postal_code</code>, and <code>country_code</code> properties.
@property (nonatomic, readonly, strong) PPCOrderAddress * _Nullable address;
/// All available shipping options for an order
@property (nonatomic, readonly, copy) NSArray<PPCShippingMethod *> * _Nullable options;
- (nonnull instancetype)initWithShippingName:(PPCPurchaseUnitShippingName * _Nullable)shippingName address:(PPCOrderAddress * _Nullable)address options:(NSArray<PPCShippingMethod *> * _Nullable)options OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


/// The name of the person to whom to ship the items. Supports only the <code>full_name</code> property.
SWIFT_CLASS_NAMED("ShippingName")
@interface PPCPurchaseUnitShippingName : NSObject
/// When the party is a person, the party’s full name.
/// Maximum length: 300.
@property (nonatomic, readonly, copy) NSString * _Nullable fullName;
- (nonnull instancetype)initWithFullName:(NSString * _Nullable)fullName OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


SWIFT_CLASS("_TtC14PayPalCheckout14RateChangeView")
@interface RateChangeView : UIView
- (nonnull instancetype)initWithFrame:(CGRect)frame SWIFT_UNAVAILABLE;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)aDecoder SWIFT_UNAVAILABLE;
@end


/// Unique identifiers for an SDK session/checkout session
SWIFT_CLASS_NAMED("SessionIdentifiers")
@interface PPCSessionIDs : NSObject
/// A unique identifier for a session of the SDK
@property (nonatomic, copy) NSString * _Nullable sdkSessionID;
/// A unique identifier for a single checkout session
@property (nonatomic, copy) NSString * _Nullable orderSessionID;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

enum PPCShippingChangeType : NSInteger;
@class PPCShippingChangeAddress;

SWIFT_CLASS_NAMED("ShippingChange")
@interface PPCShippingChange : NSObject
/// An enum indicating whether the buyer has selected a new shipping address or shipping method
@property (nonatomic, readonly) enum PPCShippingChangeType type;
/// The current selected shipping address
@property (nonatomic, readonly, strong) PPCShippingChangeAddress * _Nonnull selectedShippingAddress;
/// The list of available shipping methods
@property (nonatomic, readonly, copy) NSArray<PPCShippingMethod *> * _Nonnull shippingMethods;
/// The current selected shipping method
@property (nonatomic, readonly, strong) PPCShippingMethod * _Nullable selectedShippingMethod;
@property (nonatomic, readonly, copy) NSString * _Nonnull payToken;
@property (nonatomic, readonly, copy) NSString * _Nullable paymentID;
@property (nonatomic, readonly, copy) NSString * _Nullable billingToken;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


SWIFT_CLASS_NAMED("ShippingChangeAction")
@interface PPCShippingChangeAction : NSObject
/// Makes a request to the PayPal API to update an order.
/// note:
///
/// <ul>
///   <li>
///     Only compatible with orders generated by the PayPal <code>v2</code> API that are one time payment transactions.
///   </li>
///   <li>
///     Can only be applied to orders with the <code>CREATED</code> or <code>APPROVED</code> status.
///     You cannot update an order with the <code>COMPLETED</code> status.
///   </li>
///   <li>
///     You will need to handle any errors vended on the order request as part of the patch function.
///   </li>
///   <li>
///     You do not need to invoke <code>approve()</code> or <code>rejected()</code> when patching an order.
///     These actions will be updated based on the result of the patch request by the SDK.
///   </li>
/// </ul>
/// \param request The request to update the order with.
/// <ul>
///   <li>
///     Currently supports the following:
///     <ul>
///       <li>
///         <code>shippingName</code> - add, replace
///       </li>
///       <li>
///         <code>shippingAddress</code> - add, replace
///       </li>
///       <li>
///         <code>shippingOptions</code> - add, replace
///       </li>
///       <li>
///         <code>amount</code> - replace
///       </li>
///     </ul>
///   </li>
/// </ul>
///
/// \param onComplete Closure invoked when the patch request has resolved.
/// Asynchronously vends either a <code>PatchActionSuccess</code> or an <code>Error</code> object.
///
- (void)patchWithRequest:(PPCPatchRequest * _Nonnull)request onComplete:(void (^ _Nonnull)(PPCPatchActionSuccess * _Nullable, NSError * _Nullable))onComplete;
/// This should only be used if not using the ‘patch’ function to update your order.
/// If you are using the <code>reject</code> action you will need to resolve to <code>approve</code>
/// in cases where you want to remove the error message.
/// This will be set automatically if using the patch order request.
- (void)approve;
/// Makes a request to the SDK to refresh the UI with an error message.
/// This should be used in cases where you want to display an error message
/// under the shipping address and redirect the user to select another address
/// before continuing the checkout flow. This will be set automatically if using
/// the patch order request.
- (void)reject;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


SWIFT_CLASS_NAMED("ShippingChangeAddress")
@interface PPCShippingChangeAddress : NSObject
/// The ID of the shipping address
@property (nonatomic, readonly, copy) NSString * _Nullable addressID;
/// The highest level sub-division in a country, which is usually a province, state, or ISO-3166-2 subdivision.
/// Format for postal delivery. For example, <code>CA</code> and not <code>California</code>. Value, by country, is:
/// <ul>
///   <li>
///     UK: A county.
///   </li>
///   <li>
///     US: A state.
///   </li>
///   <li>
///     Canada: A province.
///   </li>
///   <li>
///     Japan: A prefecture.
///   </li>
///   <li>
///     Switzerland: A kanton.
///   </li>
/// </ul>
@property (nonatomic, readonly, copy) NSString * _Nullable adminArea1;
/// The city, town, or village. Smaller than <code>adminArea1</code>.
@property (nonatomic, readonly, copy) NSString * _Nullable adminArea2;
/// The postal code, which is the zip code or equivalent. Typically required for countries with a postal code or an equivalent.
@property (nonatomic, readonly, copy) NSString * _Nullable postalCode;
/// The two-character ISO 3166-1 code that identifies the country or region.
/// For more information, refer to: https://developer.paypal.com/api/rest/reference/country-codes/
@property (nonatomic, readonly, copy) NSString * _Nullable countryCode;
@property (nonatomic, readonly, copy) NSString * _Nullable city SWIFT_DEPRECATED_MSG("", "adminArea2");
@property (nonatomic, readonly, copy) NSString * _Nullable state SWIFT_DEPRECATED_MSG("", "adminArea1");
@property (nonatomic, readonly, copy) NSString * _Nullable country SWIFT_DEPRECATED_MSG("", "countryCode");
- (nonnull instancetype)initWithAddressID:(NSString * _Nullable)addressID adminArea1:(NSString * _Nullable)adminArea1 adminArea2:(NSString * _Nullable)adminArea2 postalCode:(NSString * _Nullable)postalCode countryCode:(NSString * _Nullable)countryCode OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)initWithAddressID:(NSString * _Nullable)addressID fullName:(NSString * _Nullable)fullName city:(NSString * _Nullable)city state:(NSString * _Nullable)state postalCode:(NSString * _Nullable)postalCode country:(NSString * _Nullable)country OBJC_DESIGNATED_INITIALIZER SWIFT_DEPRECATED_MSG("", "initWithAddressID:adminArea1:adminArea2:postalCode:countryCode:");
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// This class is responsible for letting our SDK know about the state of shipping changes.
typedef SWIFT_ENUM_NAMED(NSInteger, PPCShippingChangeState, "ShippingChangeState", open) {
/// The shipping callback is currently processing the change.
  PPCShippingChangeStateProcessing = 0,
/// The shipping change was approved.
  PPCShippingChangeStateApproved = 1,
/// The shipping change had an error.
  PPCShippingChangeStateError = 2,
/// The shipping callback has not been called
/// note:
/// This is the default case before the state is set in the callback.
  PPCShippingChangeStateUndetermined = 3,
};

/// The type of shipping change.
typedef SWIFT_ENUM_NAMED(NSInteger, PPCShippingChangeType, "ShippingChangeType", open) {
/// The buyer has selected a new shipping address
  PPCShippingChangeTypeShippingAddress = 0,
/// The buyer has selected a new shipping method
  PPCShippingChangeTypeShippingMethod = 1,
};

enum PPCShippingType : NSInteger;

/// Shipping option for an order used when creating an order with Orders API.
/// If you want to show your shipping options in our Paysheet,
/// you should provide <code>purchaseUnits[].shipping.options</code>,
/// otherwise, our Paysheet won’t display any shipping options.
SWIFT_CLASS_NAMED("ShippingMethod")
@interface PPCShippingMethod : NSObject
/// A unique ID that identifies a payer-selected shipping option.
@property (nonatomic, readonly, copy) NSString * _Nonnull id;
/// A description that the payer sees, which helps them choose an appropriate shipping option.
/// For example, Free Shipping, USPS Priority Shipping, Expédition prioritaire USPS, or USPS yōuxiān fā huò.
/// Localize this description to the payer’s locale.
@property (nonatomic, readonly, copy) NSString * _Nonnull label;
/// If true it represents the shipping option that the merchant expects to be selected for the buyer
/// when they view the shipping options within the PayPal Checkout experience.
/// The selected shipping option must match the shipping cost in the order breakdown.
/// Only one shipping option per purchase unit can be selected.
@property (nonatomic, readonly) BOOL selected;
/// The method by which the payer wants to get their items.
@property (nonatomic, readonly) enum PPCShippingType type;
/// The shipping cost for the selected option.
@property (nonatomic, readonly, strong) PPCUnitAmount * _Nullable amount;
- (nonnull instancetype)initWithId:(NSString * _Nonnull)id label:(NSString * _Nonnull)label selected:(BOOL)selected type:(enum PPCShippingType)type amount:(PPCUnitAmount * _Nullable)amount OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// The method by which the payer wants to get their items.
typedef SWIFT_ENUM_NAMED(NSInteger, PPCShippingType, "ShippingType", open) {
/// The payer intends to receive the items at a specified address.
  PPCShippingTypeShipping = 0,
/// The payer intends to pick up the items at a specified address. For example, a store address.
  PPCShippingTypePickup = 1,
  PPCShippingTypeNone = 2,
};


SWIFT_CLASS("_TtC14PayPalCheckout12ShippingView")
@interface ShippingView : UIView
- (nonnull instancetype)initWithFrame:(CGRect)frame SWIFT_UNAVAILABLE;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)aDecoder SWIFT_UNAVAILABLE;
@end

@class UICollectionViewLayout;

SWIFT_CLASS("_TtC14PayPalCheckout15SuggestionsView")
@interface SuggestionsView : UIView <UICollectionViewDelegateFlowLayout>
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)coder SWIFT_UNAVAILABLE;
- (void)layoutSubviews;
- (CGSize)collectionView:(UICollectionView * _Nonnull)collectionView layout:(UICollectionViewLayout * _Nonnull)collectionViewLayout sizeForItemAtIndexPath:(NSIndexPath * _Nonnull)indexPath SWIFT_WARN_UNUSED_RESULT;
- (CGSize)collectionView:(UICollectionView * _Nonnull)collectionView layout:(UICollectionViewLayout * _Nonnull)collectionViewLayout referenceSizeForFooterInSection:(NSInteger)section SWIFT_WARN_UNUSED_RESULT;
- (void)collectionView:(UICollectionView * _Nonnull)collectionView didSelectItemAtIndexPath:(NSIndexPath * _Nonnull)indexPath;
- (nonnull instancetype)initWithFrame:(CGRect)frame SWIFT_UNAVAILABLE;
@end


SWIFT_CLASS("_TtC14PayPalCheckout15TransitionLabel")
@interface TransitionLabel : UILabel
- (nonnull instancetype)initWithFrame:(CGRect)frame OBJC_DESIGNATED_INITIALIZER;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)coder OBJC_DESIGNATED_INITIALIZER SWIFT_UNAVAILABLE;
@end




























SWIFT_CLASS("_TtC14PayPalCheckout22UnconstrainedTextLabel")
@interface UnconstrainedTextLabel : UILabel
- (nonnull instancetype)initWithFrame:(CGRect)frame OBJC_DESIGNATED_INITIALIZER;
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)coder OBJC_DESIGNATED_INITIALIZER;
@end


/// UnitAmount should be used for the following objects:
/// <ul>
///   <li>
///     all breakdown.amount objects - https://developer.paypal.com/docs/api/orders/v2#definition-amount_breakdown
///   </li>
///   <li>
///     item.unitAmount - https://developer.paypal.com/docs/api/orders/v2#definition-item
///   </li>
///   <li>
///     shipping.options.amount - https://developer.paypal.com/docs/api/orders/v2/#definition-shipping_detail
///   </li>
/// </ul>
SWIFT_CLASS_NAMED("UnitAmount")
@interface PPCUnitAmount : NSObject
/// The value, which might be:
/// An integer for currencies like JPY that are not typically fractional.
/// A decimal fraction for currencies like TND that are subdivided into thousandths.
/// <ul>
///   <li>
///     Maximum length: 32.
///   </li>
///   <li>
///     Pattern: ^((-?[0-9]+)|(-?([0-9]+)?[.][0-9]+))$
///   </li>
/// </ul>
@property (nonatomic, readonly, copy) NSString * _Nullable value;
/// Currency code in text format (example: “USD”)
@property (nonatomic, readonly, copy) NSString * _Nullable currencyCodeString;
/// Formatted currency symbol and value (example: “$0.01”)
@property (nonatomic, readonly, copy) NSString * _Nullable currencyFormat;
/// \param currencyCode The currency code that identifies the currency
///
/// \param value The value
///
- (nonnull instancetype)initWithCurrencyCode:(enum PPCCurrencyCode)currencyCode value:(NSString * _Nonnull)value OBJC_DESIGNATED_INITIALIZER;
- (BOOL)isEqual:(id _Nullable)object SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

typedef SWIFT_ENUM_NAMED(NSInteger, PPCUserAction, "UserAction", open) {
/// Does not correspond with any user action value. Necessary for Objective-C exposure.
  PPCUserActionDefault = 0,
/// Corresponds with a <code>continue</code> button
  PPCUserActionContinue = 1,
/// Corresponds with a <code>Pay Now</code> button.
/// Also associated with the query parameter value of <code>userAction=commit</code>
  PPCUserActionPayNow = 2,
};



/// Data describing an approved vault flow
SWIFT_CLASS_NAMED("VaultData")
@interface PPCVaultData : NSObject
/// Unique identifier representing a vault approval session.
@property (nonatomic, readonly, copy) NSString * _Nonnull approvalSessionID;
/// The temporary PayPal-generated ID of an approval token. This token will have a lifespan of 3 hours.
/// Once approved, use the <a href="https://developer.paypal.com/api/limited-release/payment-tokens/v2/#approval-tokens_confirm-payment-token">/confirm-payment-token API</a>
/// with this token to create a Payment Token that can be used for payments.
@property (nonatomic, readonly, copy) NSString * _Nonnull approvalTokenID;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

#endif
#if defined(__cplusplus)
#endif
#if __has_attribute(external_source_symbol)
# pragma clang attribute pop
#endif
#pragma clang diagnostic pop
#endif

#else
#error unsupported Swift architecture
#endif
