[View SDK Wiki](https://github.com/ExpresspaySa/expresspay-ios-sdk-pod/wiki) | [Report new issue](https://github.com/ExpresspaySa/expresspay-ios-sdk-pod/issues/new)

# ExpressPay iOS SDK

ExpressPay is a payment gateway. Thanks to our 15+ years of experience in the payment industry, we’ve developed a state-of-the-art white-label payment system that ensures smooth and uninterrupted payment flow for merchants across industries.

<p align="center">
  <a href="https://expresspay.sa">
      <img src="/media/header.png" alt="ExpressPay" width="400px"/>
  </a>
</p>

ExpressPay iOS SDK was developed and designed with one purpose: to help the iOS developers easily integrate the ExpressPay API Payment Platform for a specific merchant. 

The main aspects of the ExpressPay iOS SDK:

- [Swift](https://developer.apple.com/swift/) is the main language 
- Minimum iOS 11
- Sample Application

To get used to the SDK, download a [sample app](https://github.com/ExpresspaySa/expresspay-ios-sdk-sample).

## Setup

Add to the `Podfile`:

```
pod 'ExpressPaySDK'
```

Always download latest version by run `pod update` or `pod install --repo-update`

[Follow further at wiki](https://github.com/ExpresspaySa/expresspay-ios-sdk-framework/wiki/Setup) | [Report new issue](https://github.com/ExpresspaySa/expresspay-ios-sdk-pod/issues/new)

## Sample

| Sale | Recurring Sale | Capture |
|-|-|-|
| ![](/media/sale.png) | ![](/media/recurring-sale.png) | ![](/media/capture.png) |

| Creditvoid | Get Trans Status | Get Trans Details |
|-|-|-|
| ![](/media/creditvoid.png) | ![](/media/get-trans-status.png) | ![](/media/get-trans-details.png) |

## Getting help

To report a specific issue or feature request, open a [new issue](https://github.com/ExpresspaySa/expresspay-ios-sdk-pod/issues/new).

Or write a direct letter to the [itsupport@expresspay.sa](mailto:admin@expresspay.sa).

## License

MIT License. See the [LICENSE](https://github.com/ExpresspaySa/expresspay-ios-sdk-pod/blob/main/LICENSE) file for more details.

## Contacts

Website: https://expresspay.sa  
Phone: [+966920033633](tel:+966920033633)  
Email: [itsupport@expresspay.sa](mailto:itsupport@expresspay.sa)  
Address: ExpressPay, Olaya Street, Riyadh, Saudi Arabia

© 2023 - 2024 ExpressPay. All rights reserved.
